/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ConfettiParticle
extends TextureSheetParticle {
    protected static final PerlinSimplexNoise X_NOISE = ConfettiParticle.noise(58637214);
    protected static final PerlinSimplexNoise Z_NOISE = ConfettiParticle.noise(823917);
    protected static final PerlinSimplexNoise YAW_NOISE = ConfettiParticle.noise(28943157);
    protected static final PerlinSimplexNoise ROLL_NOISE = ConfettiParticle.noise(80085);
    protected static final PerlinSimplexNoise PITCH_NOISE = ConfettiParticle.noise(49715286);
    private final int particleRandom;
    private float pitch = 0.0f;
    private float oPitch = 0.0f;
    private float yaw = 0.0f;
    private float oYaw = 0.0f;
    private float dPitch = 0.0f;
    private float dYaw = 0.0f;
    private float dRoll = 0.0f;

    private static PerlinSimplexNoise noise(int seed) {
        return new PerlinSimplexNoise((RandomSource)new LegacyRandomSource((long)seed), List.of(Integer.valueOf(-7), Integer.valueOf(-2), Integer.valueOf(-1), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)));
    }

    private ConfettiParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, SpriteSet sprites) {
        super(world, x, y, z);
        this.pickSprite(sprites);
        this.particleRandom = this.random.nextInt();
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.setSize(0.001f, 0.001f);
        this.gravity = 0.2f;
        this.friction = 0.94f;
        this.lifetime = this.random.nextInt(400, 700);
        this.quadSize *= 1.25f;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 vec3 = renderInfo.getPosition();
        float f = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float g = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - vec3.y());
        float h = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - vec3.z());
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
        quaternionf.rotateY(Mth.lerp((float)partialTicks, (float)this.oYaw, (float)this.yaw));
        quaternionf.rotateX(Mth.lerp((float)partialTicks, (float)this.oPitch, (float)this.pitch));
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float i = this.getQuadSize(partialTicks);
        for (int j = 0; j < 4; ++j) {
            Vector3f vector3f = vector3fs[j];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(i);
            vector3f.add(f, g, h);
        }
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int light = this.getLightColor(partialTicks);
        int lu = VertexUtil.lightU((int)light);
        int lv = VertexUtil.lightV((int)light);
        buffer.addVertex(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lu, lv);
        buffer.addVertex(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lu, lv);
        buffer.addVertex(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lu, lv);
        buffer.addVertex(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lu, lv);
        buffer.addVertex(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lu, lv);
        buffer.addVertex(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lu, lv);
        buffer.addVertex(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lu, lv);
        buffer.addVertex(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lu, lv);
    }

    public void tick() {
        boolean still = this.x == this.xo && this.z == this.zo && this.y == this.yo && this.age != 0;
        boolean hasLanded = this.onGround || still;
        float posChange = 0.01f;
        this.xd += (double)posChange * X_NOISE.getValue((double)this.particleRandom, (double)this.age, false);
        this.zd += (double)posChange * Z_NOISE.getValue((double)this.particleRandom, (double)this.age, false);
        this.oYaw = this.yaw;
        this.oPitch = this.pitch;
        this.oRoll = this.roll;
        if (!hasLanded) {
            float rotChange = 0.1f;
            this.dYaw += (float)((double)rotChange * YAW_NOISE.getValue((double)this.particleRandom, (double)this.age, false));
            this.dRoll += (float)((double)rotChange * ROLL_NOISE.getValue((double)this.particleRandom, (double)this.age, false));
            this.dPitch += (float)((double)rotChange * PITCH_NOISE.getValue((double)this.particleRandom, (double)this.age, false));
            this.yaw += this.dYaw;
            this.pitch += this.dPitch;
            this.roll += this.dRoll;
        } else {
            this.age = Math.max(this.age, this.lifetime - 20);
        }
        float moment = 0.98f;
        this.dYaw *= moment;
        this.dRoll *= moment;
        this.dPitch *= moment;
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ConfettiParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
        }
    }
}

