/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils.neoforge;

import net.mehvahdjukaar.supplementaries.common.block.IKeyLockable;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.common.items.components.SafeOwner;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ItemsUtilImpl {
    public static boolean extractFromContainerItemIntoSlot(Player player, ItemStack containerStack, Slot slot) {
        IItemHandler handler;
        if (slot.mayPickup(player) && containerStack.getCount() == 1 && (handler = ItemsUtilImpl.getItemHandler(containerStack, player)) != null) {
            for (int s = 0; s < handler.getSlots(); ++s) {
                ItemStack selected = handler.getStackInSlot(s);
                if (selected.isEmpty()) continue;
                ItemStack dropped = handler.extractItem(s, 1, false);
                if (slot.mayPlace(dropped)) {
                    slot.set(dropped);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static boolean addToContainerItem(Player player, ItemStack containerStack, ItemStack stack, Slot slot, boolean simulate, boolean inSlot) {
        IItemHandler handler;
        if (slot.mayPickup(player) && containerStack.getCount() == 1 && (handler = ItemsUtilImpl.getItemHandler(containerStack, player)) != null) {
            boolean success;
            ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.copy(), (boolean)simulate);
            boolean bl = success = result.isEmpty() || result.getCount() != stack.getCount();
            if (success) {
                if (simulate) {
                    return true;
                }
                CompoundTag newTag = new CompoundTag();
                if (inSlot) {
                    stack.setCount(result.getCount());
                    ItemStack newStack = containerStack.copy();
                    if (slot.mayPlace(newStack)) {
                        slot.set(newStack);
                        return true;
                    }
                } else {
                    int i = stack.getCount() - result.getCount();
                    slot.safeTake(i, i, player);
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static IItemHandler getItemHandler(ItemStack containerStack, Player player) {
        IItemHandler itemHandler = (IItemHandler)containerStack.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler != null) {
            SafeOwner safeOwer = (SafeOwner)containerStack.get(ModComponents.SAFE_OWNER.get());
            if (safeOwer != null && !safeOwer.canPlayerOpen(player)) {
                return null;
            }
            return itemHandler;
        }
        return null;
    }

    public static float getEncumbermentFromInventory(ItemStack stack, ServerPlayer player) {
        float amount = 0.0f;
        IItemHandler itemHandler = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY);
        if (itemHandler != null) {
            for (int idx = 0; idx < itemHandler.getSlots(); ++idx) {
                ItemStack slotItem = itemHandler.getStackInSlot(idx);
                amount += SackItem.getEncumber(slotItem);
            }
            if (CompatHandler.QUARK) {
                ItemStack backpack = player.getItemBySlot(EquipmentSlot.CHEST);
                amount += QuarkCompat.getEncumbermentFromBackpack(backpack);
            }
        }
        return amount;
    }

    public static IKeyLockable.KeyStatus getPlayerKeyStatus(Player player, String key) {
        if (key == null) {
            return IKeyLockable.KeyStatus.CORRECT_KEY;
        }
        IKeyLockable.KeyStatus found = CompatHandler.getKeyFromModsSlots(player, key);
        if (found == IKeyLockable.KeyStatus.CORRECT_KEY) {
            return found;
        }
        IItemHandler itemHandler = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY);
        if (itemHandler != null) {
            for (int idx = 0; idx < itemHandler.getSlots(); ++idx) {
                ItemStack stack = itemHandler.getStackInSlot(idx);
                IKeyLockable.KeyStatus status = IKeyLockable.getKeyStatus(stack, key);
                if (status == IKeyLockable.KeyStatus.CORRECT_KEY) {
                    return status;
                }
                if (status != IKeyLockable.KeyStatus.INCORRECT_KEY) continue;
                found = status;
            }
        }
        return found;
    }

    public static ItemStack tryExtractingItem(Level level, Direction dir, BlockPos pos, BlockEntity tile) {
        IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, level.getBlockState(pos), tile, (Object)dir);
        if (itemHandler != null) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack extracted;
                ItemStack itemstack = itemHandler.getStackInSlot(slot);
                if (itemstack.isEmpty() || (extracted = itemHandler.extractItem(slot, 1, false)).isEmpty()) continue;
                if (tile instanceof Container) {
                    Container c = (Container)tile;
                    c.setChanged();
                }
                return extracted.copy();
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack tryAddingItem(ItemStack stack, Level level, Entity entity) {
        IItemHandler itemHandler = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY);
        if (itemHandler != null) {
            return ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static ItemStack tryAddingItem(ItemStack stack, Level level, Direction dir, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, state, be, (Object)dir);
        if (itemHandler != null) {
            return ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }
}

