/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicServerResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.biome.Biomes;

public class ModServerDynamicResources
extends DynamicServerResourceProvider {
    public static final Map<ResourceLocation, Resource> TAG_TRANSLATION_HACK = new HashMap<ResourceLocation, Resource>();

    public ModServerDynamicResources() {
        super(Supplementaries.res("generated_pack"), CommonConfigs.General.DYNAMIC_ASSETS_GEN_MODE.get().toStrategy());
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of();
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((manager, sink) -> {
            SimpleTagBuilder builder = SimpleTagBuilder.of((ResourceLocation)Supplementaries.res("way_signs"));
            builder.addEntries(ModRegistry.WAY_SIGN_ITEMS.values());
            sink.addTag(builder, Registries.ITEM);
            builder = SimpleTagBuilder.of((ResourceLocation)Supplementaries.res("cannon_boats"));
            builder.addEntries(ModRegistry.CANNON_BOAT_ITEMS.values());
            sink.addTag(builder, Registries.ITEM);
            if (CommonConfigs.Building.WAY_SIGN_ENABLED.get().booleanValue()) {
                this.addSignPostRecipes(manager, sink);
            }
            if (CommonConfigs.Functional.CANNON_BOAT_ENABLED.get().booleanValue()) {
                this.addCannonBoatRecipes(manager, sink);
            }
            if (PlatHelper.getPlatform().isForge()) {
                builder = SimpleTagBuilder.of(ModTags.HAS_WAY_SIGNS);
                if (CommonConfigs.Building.ROAD_SIGN_ENABLED.get().booleanValue() && CommonConfigs.Building.WAY_SIGN_ENABLED.get().booleanValue()) {
                    builder.addTag(BiomeTags.IS_OVERWORLD);
                }
                sink.addTag(builder, Registries.BIOME);
                builder = SimpleTagBuilder.of(ModTags.HAS_CAVE_URNS);
                if (CommonConfigs.Functional.URN_PILE_ENABLED.get().booleanValue() && CommonConfigs.Functional.URN_ENABLED.get().booleanValue()) {
                    builder.addTag(BiomeTags.IS_OVERWORLD);
                }
                sink.addTag(builder, Registries.BIOME);
                builder = SimpleTagBuilder.of(ModTags.HAS_WILD_FLAX);
                if (CommonConfigs.Functional.WILD_FLAX_ENABLED.get().booleanValue()) {
                    builder.addTag(BiomeTags.IS_OVERWORLD);
                }
                sink.addTag(builder, Registries.BIOME);
                builder = SimpleTagBuilder.of(ModTags.HAS_BASALT_ASH);
                if (CommonConfigs.Building.BASALT_ASH_ENABLED.get().booleanValue()) {
                    builder.add(Biomes.BASALT_DELTAS.location());
                    builder.addOptionalElement(ResourceLocation.parse((String)"incendium:volcanic_deltas"));
                }
                sink.addTag(builder, Registries.BIOME);
            }
        });
    }

    private void addCannonBoatRecipes(ResourceManager manager, ResourceSink sink) {
        Recipe recipeTemplate = RPUtils.readRecipe((ResourceManager)manager, (ResourceLocation)Supplementaries.res("cannon_boat_oak"));
        WoodType oak = VanillaWoodTypes.OAK;
        ModRegistry.CANNON_BOAT_ITEMS.forEach((w, i) -> {
            WoodType bamboo = (WoodType)WoodTypeRegistry.INSTANCE.get(ResourceLocation.withDefaultNamespace((String)"bamboo"));
            if (w != oak && w != bamboo) {
                try {
                    RecipeHolder newR = RPUtils.makeSimilarRecipe((Recipe)recipeTemplate, (BlockType)VanillaWoodTypes.OAK, (BlockType)w, (ResourceLocation)Supplementaries.res("cannon_boat_oak"));
                    sink.addRecipe(newR);
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("Failed to generate recipe for cannon boat {}:", (Object)i, (Object)e);
                }
            }
        });
    }

    private void addSignPostRecipes(ResourceManager manager, ResourceSink sink) {
        Recipe recipe = RPUtils.readRecipe((ResourceManager)manager, (ResourceLocation)Supplementaries.res("way_sign_oak"));
        Recipe recipe2 = RPUtils.readRecipe((ResourceManager)manager, (ResourceLocation)Supplementaries.res("way_sign_mod_template"));
        WoodType oak = VanillaWoodTypes.OAK;
        ModRegistry.WAY_SIGN_ITEMS.forEach((w, i) -> {
            if (w != oak) {
                try {
                    Recipe recipeTemplate = w.getChild("sign") == null ? recipe2 : recipe;
                    RecipeHolder newR = RPUtils.makeSimilarRecipe((Recipe)recipeTemplate, (BlockType)VanillaWoodTypes.OAK, (BlockType)w, (ResourceLocation)Supplementaries.res("way_sign_oak"));
                    sink.addRecipe(newR);
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("Failed to generate recipe for sign post {}:", (Object)i, (Object)e);
                }
            }
        });
    }
}

