/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AwningBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BuntingCeilingBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BuntingWallBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.items.BuntingItem;
import net.mehvahdjukaar.supplementaries.common.items.CannonBoatItem;
import net.mehvahdjukaar.supplementaries.common.items.FlagItem;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.common.items.components.LunchBaskedContent;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.BuzzierBeesCompat;
import net.mehvahdjukaar.supplementaries.integration.CaveEnhancementsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;

public class RegUtils {
    protected static final BlockBehaviour.StatePredicate NEVER = (state, reader, pos) -> false;

    public static void initDynamicRegistry() {
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerSignPostItems, WoodType.class);
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerCannonBoatItems, WoodType.class);
    }

    public static void registerAdditionalPlacements() {
        AdditionalItemPlacementsAPI.registerSimplePlacement((Item)ModRegistry.PANCAKE_ITEM.get(), (Block)ModRegistry.PANCAKE.get());
        if (CommonConfigs.Tweaks.PLACEABLE_STICKS.get().booleanValue()) {
            AdditionalItemPlacementsAPI.registerPlacement((Item)Items.STICK, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.STICK_BLOCK.get()));
        }
        if (CommonConfigs.Tweaks.PLACEABLE_RODS.get().booleanValue()) {
            AdditionalItemPlacementsAPI.registerPlacement((Item)Items.BLAZE_ROD, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.BLAZE_ROD_BLOCK.get()));
        }
        if (CommonConfigs.Tweaks.PLACEABLE_GUNPOWDER.get().booleanValue()) {
            AdditionalItemPlacementsAPI.registerPlacement((Item)Items.GUNPOWDER, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.GUNPOWDER_BLOCK.get()));
        }
        if (CommonConfigs.Tools.LUNCH_BOX_PLACEABLE.get().booleanValue()) {
            AdditionalItemPlacementsAPI.registerPlacement((Item)ModRegistry.LUNCH_BASKET_ITEM.get(), (AdditionalItemPlacement)new AdditionalItemPlacement(ModRegistry.LUNCH_BASKET.get()){

                public InteractionResult overrideUseOn(UseOnContext pContext, FoodProperties foodProperties) {
                    if (!pContext.getPlayer().isSecondaryUseActive()) {
                        return InteractionResult.PASS;
                    }
                    ItemStack basket = pContext.getItemInHand();
                    LunchBaskedContent content = (LunchBaskedContent)basket.get(ModComponents.LUNCH_BASKET_CONTENT.get());
                    if (content != null && content.canEatFrom()) {
                        return InteractionResult.PASS;
                    }
                    return super.overrideUseOn(pContext, foodProperties);
                }
            });
        }
    }

    public static <T extends Item> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)Supplementaries.res(name), sup);
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((ResourceLocation)Supplementaries.res(name), sup);
    }

    public static <T extends Block> RegSupplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)Supplementaries.res(name), sup);
    }

    public static <T extends Block> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory) {
        return RegUtils.regWithItem(name, blockFactory, new Item.Properties());
    }

    public static <T extends Block> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, Item.Properties properties) {
        RegSupplier<T> block = RegUtils.regBlock(name, blockFactory);
        RegUtils.regBlockItem(name, block, properties);
        return block;
    }

    public static RegSupplier<BlockItem> regBlockItem(String name, Supplier<? extends Block> blockSup, Item.Properties properties) {
        return RegHelper.registerItem((ResourceLocation)Supplementaries.res(name), () -> new BlockItem((Block)blockSup.get(), properties));
    }

    public static Map<DyeColor, Supplier<Block>> registerCandleHolders(ResourceLocation baseName) {
        return RegUtils.registerCandleHolders(baseName, CandleHolderBlock::getParticleOffsets);
    }

    public static Map<DyeColor, Supplier<Block>> registerCandleHolders(ResourceLocation baseName, Function<BlockState, List<Vec3>> particleOffsets) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.of().noCollission().pushReaction(PushReaction.DESTROY).noOcclusion().instabreak().sound(SoundType.LANTERN);
        RegSupplier block = RegHelper.registerBlockWithItem((ResourceLocation)baseName, () -> new CandleHolderBlock(null, prop, particleOffsets));
        map.put(null, block);
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName.getPath() + "_" + color.getName();
            RegSupplier coloredBlock = RegHelper.registerBlockWithItem((ResourceLocation)baseName.withPath(name), () -> new CandleHolderBlock(color, prop, particleOffsets));
            map.put(color, coloredBlock);
        }
        ModRegistry.ALL_CANDLE_HOLDERS.addAll(map.values());
        if (CompatHandler.BUZZIER_BEES) {
            BuzzierBeesCompat.registerCandle(baseName, particleOffsets);
        }
        if (CompatHandler.CAVE_ENHANCEMENTS) {
            CaveEnhancementsCompat.registerCandle(baseName, particleOffsets);
        }
        return map;
    }

    public static Map<DyeColor, Supplier<Block>> registerBuntings(String baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            BlockBehaviour.Properties prop = BlockBehaviour.Properties.of().ignitedByLava().mapColor(color.getMapColor()).instabreak().noOcclusion().sound(SoundType.WOOL);
            RegSupplier<Block> wallBlock = RegUtils.regBlock(baseName + "_wall_" + color.getName(), () -> new BuntingWallBlock(color, prop));
            RegSupplier<Block> ceilingBlock = RegUtils.regBlock(baseName + "_" + color.getName(), () -> new BuntingCeilingBlock(color, prop));
            map.put(color, ceilingBlock);
            ModRegistry.BUNTING_WALL_BLOCKS.put(color, (Supplier<Block>)wallBlock);
            RegUtils.regItem(baseName + "_" + color.getName(), () -> new BuntingItem(color, (Block)ceilingBlock.get(), (Block)wallBlock.get(), new Item.Properties(), Direction.UP));
        }
        return map;
    }

    public static Map<DyeColor, Supplier<Block>> registerFlags(String baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.getName();
            RegSupplier<Block> block = RegUtils.regBlock(name, () -> new FlagBlock(color, BlockBehaviour.Properties.of().ignitedByLava().mapColor(color.getMapColor()).strength(1.0f).noOcclusion().sound(SoundType.WOOD)));
            map.put(color, block);
            RegUtils.regItem(name, () -> new FlagItem((Block)block.get(), new Item.Properties().component(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY).stacksTo(16)));
        }
        return map;
    }

    public static Map<DyeColor, Supplier<Block>> registerPresents(String baseName, BiFunction<DyeColor, BlockBehaviour.Properties, Block> presentFactory, BiFunction<Block, Item.Properties, PresentItem> itemFactory) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        RegSupplier<Block> block = RegUtils.regBlock(baseName, () -> (Block)presentFactory.apply(null, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).pushReaction(PushReaction.DESTROY).strength(0.5f).sound((SoundType)ModSounds.PRESENT)));
        map.put(null, block);
        RegUtils.regItem(baseName, () -> (PresentItem)((Object)((Object)itemFactory.apply((Block)block.get(), new Item.Properties()))));
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.getName();
            RegSupplier<Block> bb = RegUtils.regBlock(name, () -> (Block)presentFactory.apply(color, BlockBehaviour.Properties.of().mapColor(color.getMapColor()).pushReaction(PushReaction.DESTROY).strength(0.5f).sound((SoundType)ModSounds.PRESENT)));
            map.put(color, bb);
            RegUtils.regItem(name, () -> (PresentItem)((Object)((Object)itemFactory.apply((Block)bb.get(), new Item.Properties()))));
        }
        return map;
    }

    private static void registerSignPostItems(Registrator<Item> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("way_sign");
            SignPostItem item = new SignPostItem(ModRegistry.WAY_SIGN_WALL.get(), new Item.Properties().stacksTo(16), wood);
            wood.addChild("supplementaries:way_sign", (Object)item);
            event.register(Supplementaries.res(name), (Object)item);
            ModRegistry.WAY_SIGN_ITEMS.put(wood, item);
        }
    }

    private static void registerCannonBoatItems(Registrator<Item> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            if (wood.getChild("boat") == null) continue;
            String name = wood.getVariantId("cannon_boat");
            CannonBoatItem item = new CannonBoatItem(new Item.Properties().stacksTo(1), wood);
            wood.addChild("supplementaries:cannon_boat", (Object)item);
            event.register(Supplementaries.res(name), (Object)item);
            ModRegistry.CANNON_BOAT_ITEMS.put(wood, item);
        }
    }

    public static Map<DyeColor, Supplier<Block>> registerAwnings(String baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        RegSupplier<Block> defAwning = RegUtils.regBlock(baseName, () -> new AwningBlock(null, BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.SAND).strength(1.0f).forceSolidOff().noOcclusion().sound(SoundType.WOOL)));
        map.put(null, defAwning);
        RegUtils.regItem(baseName, () -> new BlockItem((Block)defAwning.get(), new Item.Properties()));
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.getName();
            RegSupplier<Block> block = RegUtils.regBlock(name, () -> new AwningBlock(color, BlockBehaviour.Properties.of().ignitedByLava().mapColor(color.getMapColor()).strength(1.0f).forceSolidOff().noOcclusion().sound(SoundType.WOOL)));
            map.put(color, block);
            RegUtils.regItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return map;
    }
}

