/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.config;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ServerConfig;
import java.util.function.IntUnaryOperator;

public enum PriorWorkPenalty {
    NONE(itemRepairCost -> 0),
    VANILLA(IntUnaryOperator.identity()),
    LIMITED(itemRepairCost -> PriorWorkPenalty.limitedRepairCost(PriorWorkPenalty.repairCostToRepairs(itemRepairCost)));

    public final IntUnaryOperator operator;

    private PriorWorkPenalty(IntUnaryOperator operator) {
        this.operator = operator;
    }

    static int repairCostToRepairs(int itemRepairCost) {
        ++itemRepairCost;
        int priorRepairs = 0;
        while (itemRepairCost >= 2) {
            itemRepairCost /= 2;
            ++priorRepairs;
        }
        return priorRepairs;
    }

    static int limitedRepairCost(int priorRepairs) {
        int itemRepairCost = 0;
        for (int i = 0; i < priorRepairs; ++i) {
            itemRepairCost += Math.min(itemRepairCost + 1, ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.maximumPriorWorkPenaltyIncrease);
        }
        return itemRepairCost;
    }
}

