/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.elementalmaces.items;

import dev.foxgirl.elementalmaces.items.AbstractElementalMaceItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EnderMaceItem
extends AbstractElementalMaceItem {
    public EnderMaceItem() {
        super(properties -> properties.component(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.elementalmaces.ender_mace").withStyle(ChatFormatting.LIGHT_PURPLE)).component(DataComponents.LORE, (Object)ItemLore.EMPTY.withLineAdded((Component)Component.translatable((String)"item.elementalmaces.ender_mace.lore.line1")).withLineAdded((Component)Component.translatable((String)"item.elementalmaces.ender_mace.lore.line2"))), attributes -> attributes.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
    }

    @Override
    protected void onTick(ItemStack stack, ServerPlayer player, int slot, boolean isSelected, boolean isInHands) {
    }

    @Override
    protected boolean onSmashAttack(ItemStack stack, ServerPlayer player, LivingEntity target) {
        EnderMaceItem.getNearbyTargets(player, target, 4.0).forEach(entity -> {
            player.serverLevel().explode((Entity)player, player.damageSources().explosion((Entity)player, (Entity)player), new ExplosionDamageCalculator(this, (LivingEntity)entity){
                final /* synthetic */ LivingEntity val$entity;
                {
                    this.val$entity = livingEntity;
                }

                public boolean shouldBlockExplode(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
                    return false;
                }

                public boolean shouldDamageEntity(Explosion explosion, Entity target) {
                    return target == this.val$entity;
                }

                public float getKnockbackMultiplier(Entity target) {
                    return 1.0f;
                }

                public float getEntityDamageAmount(Explosion explosion, Entity target) {
                    return 0.1f;
                }
            }, entity.getX(), entity.getY() + 0.1, entity.getZ(), 0.1f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, (Holder)SoundEvents.BREEZE_WIND_CHARGE_BURST);
            entity.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 100));
        });
        AreaEffectCloud effectCloud = new AreaEffectCloud(player.level(), player.getX(), target.getY(), player.getZ());
        effectCloud.setOwner((LivingEntity)player);
        effectCloud.setRadius(3.5f);
        effectCloud.setRadiusOnUse(-0.5f);
        effectCloud.setWaitTime(0);
        effectCloud.setDuration(60);
        effectCloud.setRadiusPerTick(-effectCloud.getRadius() / (float)effectCloud.getDuration());
        effectCloud.setParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH);
        player.level().addFreshEntity((Entity)effectCloud);
        player.level().playSound(null, player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), SoundEvents.ENDER_DRAGON_GROWL, SoundSource.PLAYERS, 3.0f, 1.0f);
        return true;
    }
}

