/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.CraftingContainerRecipeTransferHandlerServer;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiSlotAccessor;

public record ReiTransferRecipePayload(ResourceLocation recipeId, ResourceLocation recipeTypeId, CompoundTag tag, List<Integer> inputSlots, List<Integer> inventorySlots, boolean maxTransfer) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ReiTransferRecipePayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getRL("rei_move_items"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ReiTransferRecipePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ReiTransferRecipePayload::recipeId, (StreamCodec)ResourceLocation.STREAM_CODEC, ReiTransferRecipePayload::recipeTypeId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, ReiTransferRecipePayload::tag, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), ReiTransferRecipePayload::inputSlots, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), ReiTransferRecipePayload::inventorySlots, (StreamCodec)ByteBufCodecs.BOOL, ReiTransferRecipePayload::maxTransfer, ReiTransferRecipePayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(ReiTransferRecipePayload payload, IPayloadContext context) {
        RecipeType recipeType = (RecipeType)BuiltInRegistries.RECIPE_TYPE.get(payload.recipeTypeId);
        if (recipeType == null) {
            return;
        }
        Player player = context.player();
        AbstractContainerMenu container = player.containerMenu;
        List<InputIngredient<ItemStack>> inputs = ReiTransferRecipePayload.readInputs(payload.tag.getList("Inputs", 10));
        RecipeFinder recipeFinder = new RecipeFinder();
        for (int slotId : payload.inventorySlots) {
            ReiSlotAccessor slot = (ReiSlotAccessor)ReiSlotAccessor.fromSlot(container.getSlot(slotId));
            recipeFinder.addNormalItem(slot.getItemStack());
        }
        NonNullList ingredients = NonNullList.create();
        for (InputIngredient<ItemStack> itemStacks : inputs) {
            ingredients.add((Object)CollectionUtils.toIngredient((Iterable)itemStacks.get()));
        }
        IntArrayList recipeItemIds = new IntArrayList();
        if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds)) {
            CraftingContainerRecipeTransferHandlerServer.setItemsWithStacks(player, payload.recipeId, recipeType, recipeItemIds.intStream().mapToObj(RecipeFinder::getStackFromId).toList(), payload.inputSlots, payload.inventorySlots, payload.maxTransfer);
        }
    }

    private static List<InputIngredient<ItemStack>> readInputs(ListTag tag) {
        ArrayList<InputIngredient<ItemStack>> inputs = new ArrayList<InputIngredient<ItemStack>>();
        for (Tag t : tag) {
            CompoundTag compoundTag = (CompoundTag)t;
            InputIngredient stacks = InputIngredient.of((int)compoundTag.getInt("Index"), (List)EntryIngredient.read((ListTag)compoundTag.getList("Ingredient", 10)));
            inputs.add((InputIngredient<ItemStack>)InputIngredient.withType((InputIngredient)stacks, (EntryType)VanillaEntryTypes.ITEM));
        }
        return inputs;
    }
}

