/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.more_bows_and_arrows.platform;

import com.mojang.serialization.MapCodec;
import forge.com.cursee.more_bows_and_arrows.MoreBowsAndArrows;
import forge.com.cursee.more_bows_and_arrows.MoreBowsAndArrowsForge;
import forge.com.cursee.more_bows_and_arrows.core.util.DeferredRegistryObject;
import forge.com.cursee.more_bows_and_arrows.core.util.ForgeDeferredRegistryObject;
import forge.com.cursee.more_bows_and_arrows.core.util.ForgeRegistryHelper;
import forge.com.cursee.more_bows_and_arrows.platform.services.IPlatformHelper;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public String getGameDirectory() {
        return FMLPaths.GAMEDIR.get().toString();
    }

    @Override
    public boolean isClientSide() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @Override
    public CreativeModeTab creativeModeTab(Supplier<ItemStack> icon, Component title, CreativeModeTab.DisplayItemsGenerator displayItemsGenerator) {
        return CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(icon).title(title).displayItems(displayItemsGenerator).build();
    }

    @Override
    public <T extends Entity> EntityType.Builder<T> createEntityType(BiFunction<EntityType<T>, Level, T> constructor, MobCategory category) {
        return EntityType.Builder.of(constructor::apply, (MobCategory)category);
    }

    @Override
    public <T extends EnchantmentEntityEffect> MapCodec<T> createEnchantmentEffect(String name, MapCodec<T> codec) {
        AtomicReference reference = new AtomicReference();
        MoreBowsAndArrowsForge.EVENT_BUS.register(event -> {
            if (event.getRegistryKey() != Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE) {
                return;
            }
            event.register(Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, MoreBowsAndArrows.identifier(name), () -> codec);
            reference.set((MapCodec)BuiltInRegistries.ENCHANTMENT_ENTITY_EFFECT_TYPE.get(MoreBowsAndArrows.identifier(name)));
        });
        return (MapCodec)reference.get();
    }

    @Override
    public <T, U extends T> DeferredRegistryObject<U> register(Registry<T> objRegistry, String objName, Supplier<U> objSupplier) {
        DeferredRegister<T> registry = ForgeRegistryHelper.deferredRegisterFor(objRegistry);
        return new ForgeDeferredRegistryObject(registry.register(objName, objSupplier));
    }

    @Override
    public CreativeModeTab.Builder tabBuilder() {
        return CreativeModeTab.builder();
    }
}

