/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.integration;

import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import net.mehvahdjukaar.amendments.common.block.CeilingBannerBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SconceBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SconceLeverBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SconceWallBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.GunpowderExplosion;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SuppCompat {
    @Deprecated(forRemoval=true)
    private static final Field OFFSETS;

    public static void setup() {
        FaucetBlockTile.registerInteraction((Object)new FaucetCauldronConversion());
    }

    public static boolean canBannerAttachToRope(BlockState state, BlockState above) {
        if (above.getBlock() instanceof RopeBlock && !((Boolean)above.getValue((Property)RopeBlock.DOWN)).booleanValue()) {
            Direction dir = (Direction)state.getValue((Property)CeilingBannerBlock.FACING);
            return (Boolean)above.getValue((Property)RopeBlock.FACING_TO_PROPERTY_MAP.get(dir.getClockWise())) != false && (Boolean)above.getValue((Property)RopeBlock.FACING_TO_PROPERTY_MAP.get(dir.getCounterClockWise())) != false;
        }
        return false;
    }

    public static boolean isVerticalStick(BlockState state, Direction facing) {
        return state.getBlock() instanceof StickBlock && (facing.getAxis() == Direction.Axis.X ? (Boolean)state.getValue((Property)StickBlock.AXIS_X) == false : (Boolean)state.getValue((Property)StickBlock.AXIS_Z) == false);
    }

    public static boolean isRope(Block block) {
        return block instanceof RopeBlock;
    }

    public static void spawnCakeParticles(Level level, BlockPos pos, RandomSource rand) {
        if (MiscUtils.FESTIVITY.isStValentine() && (double)rand.nextFloat() > 0.8) {
            double d0 = (double)pos.getX() + 0.5 + ((double)rand.nextFloat() - 0.5);
            double d1 = (double)pos.getY() + 0.5 + ((double)rand.nextFloat() - 0.5);
            double d2 = (double)pos.getZ() + 0.5 + ((double)rand.nextFloat() - 0.5);
            level.addParticle((ParticleOptions)ParticleTypes.HEART, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static float getSignColorMult() {
        return ClientConfigs.getSignColorMult();
    }

    public static boolean isSupportingCeiling(BlockState upState, BlockPos pos, LevelReader world) {
        return IRopeConnection.isSupportingCeiling((BlockState)upState, (BlockPos)pos, (LevelReader)world);
    }

    public static void createMiniExplosion(ServerLevel level, BlockPos pos, boolean b) {
        GunpowderExplosion.explode((ServerLevel)level, (BlockPos)pos);
    }

    public static boolean canConnectDown(BlockState neighborState) {
        return IRopeConnection.canConnectDown((BlockState)neighborState);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static Material getFlagMaterial(Level l, BannerPatternItem bannerPatternItem) {
        return ModMaterials.getFlagMaterialForPatternItem((Level)l, (BannerPatternItem)bannerPatternItem);
    }

    public static boolean isSconce(Block block) {
        if (block instanceof SconceLeverBlock) {
            return true;
        }
        return block instanceof SconceBlock && !(block instanceof SconceWallBlock);
    }

    public static boolean isCandleHolder(Block block) {
        return block instanceof CandleHolderBlock;
    }

    public static EntityType<? extends Entity> getSlimeBall() {
        return (EntityType)ModEntities.THROWABLE_SLIMEBALL.get();
    }

    public static Vec3 getCandleHolderParticleOffset(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof CandleHolderBlock) {
            CandleHolderBlock cb = (CandleHolderBlock)block;
            try {
                Function offsets = (Function)OFFSETS.get(cb);
                List particleOffsets = (List)offsets.apply(state);
                if (!particleOffsets.isEmpty()) {
                    return ((Vec3)particleOffsets.getFirst()).subtract(0.5, 0.5, 0.5);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Vec3.ZERO;
    }

    static {
        try {
            OFFSETS = CandleHolderBlock.class.getDeclaredField("particleOffsets");
            OFFSETS.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static class FaucetCauldronConversion
    implements FaucetTarget.BlState {
        public Integer fill(Level level, BlockPos pos, BlockState target, FluidOffer offer) {
            if (target.is(Blocks.CAULDRON)) {
                SoftFluidStack fluid = offer.fluid();
                int minAmount = offer.minAmount();
                BlockState newState = CauldronConversion.getNewState(pos, level, fluid);
                if (newState != null) {
                    level.setBlockAndUpdate(pos, newState);
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    if (blockEntity instanceof LiquidCauldronBlockTile) {
                        LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                        SoftFluidTank tank = te.getSoftFluidTank();
                        tank.setFluid(fluid.copyWithCount(minAmount));
                        return minAmount;
                    }
                }
            }
            return null;
        }
    }
}

