/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterstrongholds.module.StructurePlacementTypeModule;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class BetterStrongholdsPlacement
extends RandomSpreadStructurePlacement {
    public static final MapCodec<BetterStrongholdsPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Vec3i.offsetCodec((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.ZERO).forGetter(rec$ -> ((BetterStrongholdsPlacement)((Object)((Object)((Object)rec$)))).locateOffset()), (App)StructurePlacement.FrequencyReductionMethod.CODEC.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(rec$ -> ((BetterStrongholdsPlacement)((Object)((Object)((Object)rec$)))).frequencyReductionMethod()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((BetterStrongholdsPlacement)((Object)((Object)((Object)rec$)))).frequency())), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(rec$ -> ((BetterStrongholdsPlacement)((Object)((Object)((Object)rec$)))).salt()), (App)StructurePlacement.ExclusionZone.CODEC.optionalFieldOf("exclusion_zone").forGetter(rec$ -> ((BetterStrongholdsPlacement)((Object)((Object)((Object)rec$)))).exclusionZone()), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::spacing), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("separation").forGetter(RandomSpreadStructurePlacement::separation), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::spreadType), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("chunk_distance_to_first_ring").forGetter(BetterStrongholdsPlacement::chunkDistanceToFirstRing), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("ring_chunk_thickness").forGetter(BetterStrongholdsPlacement::ringChunkThickness), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("max_ring_section").forGetter(BetterStrongholdsPlacement::maxRingSection)).apply((Applicative)instance, instance.stable(BetterStrongholdsPlacement::new)));
    private final int chunkDistanceToFirstRing;
    private final int ringChunkThickness;
    private final Optional<Integer> maxRingSection;

    public BetterStrongholdsPlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, Float frequency, Integer salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, Integer spacing, Integer separation, RandomSpreadType randomSpreadType, Integer chunkDistanceToFirstRing, Integer ringChunkThickness, Optional<Integer> maxRingSection) {
        super(locateOffset, frequencyReductionMethod, frequency.floatValue(), salt.intValue(), exclusionZone, spacing.intValue(), separation.intValue(), randomSpreadType);
        this.chunkDistanceToFirstRing = chunkDistanceToFirstRing;
        this.ringChunkThickness = ringChunkThickness;
        this.maxRingSection = maxRingSection;
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState chunkGeneratorStructureState, int chunkX, int chunkZ) {
        long seed = chunkGeneratorStructureState.getLevelSeed();
        ChunkPos chunkPos = this.getPotentialStructureChunk(seed, chunkX, chunkZ);
        if (chunkPos.x == chunkX && chunkPos.z == chunkZ) {
            int chunkDistance = (int)Math.sqrt(chunkX * chunkX + chunkZ * chunkZ);
            int shiftedChunkDistance = chunkDistance + (this.ringChunkThickness - this.chunkDistanceToFirstRing);
            int ringSection = shiftedChunkDistance / this.ringChunkThickness;
            if (this.maxRingSection.isPresent() && ringSection > this.maxRingSection.get()) {
                return false;
            }
            return ringSection % 2 == 1;
        }
        return false;
    }

    public StructurePlacementType<?> type() {
        return StructurePlacementTypeModule.BETTER_STRONGHOLD_PLACEMENT;
    }

    public int chunkDistanceToFirstRing() {
        return this.chunkDistanceToFirstRing;
    }

    public int ringChunkThickness() {
        return this.ringChunkThickness;
    }

    public Optional<Integer> maxRingSection() {
        return this.maxRingSection;
    }
}

