/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.math;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.data.IDhApiTerrainDataCache;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.api.objects.DhApiResult;
import com.seibel.distanthorizons.api.objects.data.DhApiRaycastResult;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.CommonClient;

public class Raycast {
    private static IDhApiTerrainDataCache terrainCache = null;
    private static Instant lastCacheLoad = Instant.EPOCH;

    private Raycast() {
    }

    public static void traceDistantAsync(Vec3 direction, float tickDelta, Consumer<BlockHitResult> callback) {
        Entity cameraEntity = CommonClient.Game.cameraEntity;
        if (cameraEntity == null || cameraEntity.level() == null) {
            return;
        }
        Vec3 rayStartVec = cameraEntity.getEyePosition(tickDelta);
        CompletableFuture<BlockHitResult> ft = CompletableFuture.supplyAsync(() -> {
            if (DhApi.Delayed.worldProxy == null) {
                return null;
            }
            IDhApiLevelWrapper levelWrapper = DhApi.Delayed.worldProxy.getSinglePlayerLevel();
            if (levelWrapper == null) {
                return null;
            }
            if (terrainCache == null || Duration.between(lastCacheLoad, Instant.now()).getSeconds() > 10L) {
                terrainCache = DhApi.Delayed.terrainRepo.getSoftCache();
                lastCacheLoad = Instant.now();
            }
            DhApiResult rayCastResult = DhApi.Delayed.terrainRepo.raycast(levelWrapper, rayStartVec.x, rayStartVec.y, rayStartVec.z, (float)direction.x, (float)direction.y, (float)direction.z, 4096, terrainCache);
            if (!rayCastResult.success || rayCastResult.payload == null) {
                return null;
            }
            Vec3 pos = new Vec3((double)((DhApiRaycastResult)rayCastResult.payload).pos.x, (double)((DhApiRaycastResult)rayCastResult.payload).pos.y, (double)((DhApiRaycastResult)rayCastResult.payload).pos.z);
            return new BlockHitResult(pos, Direction.UP, new BlockPos((int)pos.x, (int)pos.y, (int)pos.z), true);
        });
        ft.thenAccept(result -> Optional.ofNullable(result).ifPresent(callback));
    }

    public static HitResult traceDirectional(Vec3 direction, float tickDelta, double maxDistance, boolean hitFluids) {
        Entity cameraEntity = CommonClient.Game.cameraEntity;
        if (cameraEntity == null || cameraEntity.level() == null) {
            return null;
        }
        Vec3 rayStartVec = cameraEntity.getEyePosition(tickDelta);
        Vec3 rayEndVec = rayStartVec.add(direction.scale(maxDistance));
        AABB boundingBox = cameraEntity.getBoundingBox().expandTowards(cameraEntity.getViewVector(1.0f).scale(maxDistance)).inflate(1.0, 1.0, 1.0);
        BlockHitResult blockHitResult = cameraEntity.level().clip(new ClipContext(rayStartVec, rayEndVec, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, cameraEntity));
        EntityHitResult entityHitResult = Raycast.traceEntity(cameraEntity, rayStartVec, rayEndVec, boundingBox, targetEntity -> !targetEntity.isSpectator());
        if (entityHitResult == null) {
            return blockHitResult;
        }
        if (rayStartVec.distanceToSqr(blockHitResult.getLocation()) < rayStartVec.distanceToSqr(entityHitResult.getLocation())) {
            return blockHitResult;
        }
        return entityHitResult;
    }

    private static EntityHitResult traceEntity(Entity entity, Vec3 min, Vec3 max, AABB box, Predicate<Entity> predicate) {
        double minDist = min.distanceToSqr(max);
        EntityHitResult minHitResult = null;
        for (Entity ent : entity.level().getEntities(entity, box, predicate)) {
            EntityHitResult hitResult;
            double hitDist;
            AABB targetBoundingBox = ent.getBoundingBox().inflate((double)ent.getPickRadius()).inflate(0.25);
            Optional hitPos = targetBoundingBox.clip(min, max);
            if (hitPos.isEmpty() || !(minDist > (hitDist = min.distanceToSqr((hitResult = new EntityHitResult(ent, (Vec3)hitPos.get())).getLocation())))) continue;
            minDist = hitDist;
            minHitResult = hitResult;
        }
        return minHitResult;
    }
}

