/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.network;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.network.IPacket;
import nx.pingwheel.common.network.PacketHandler;
import org.jetbrains.annotations.NotNull;

public record PingLocationC2SPacket(String channel, Vec3 pos, UUID entity, int sequence, int dimension) implements IPacket
{
    public static final ResourceLocation PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"ping-wheel-c2s", (String)"ping-location");
    public static final CustomPacketPayload.Type<PingLocationC2SPacket> PACKET_TYPE = new CustomPacketPayload.Type(PACKET_ID);

    public PingLocationC2SPacket() {
        this(null, null, null, 0, 0);
    }

    public PingLocationC2SPacket(FriendlyByteBuf buf) {
        this(buf.readUtf(128), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readBoolean() ? buf.readUUID() : null, buf.readInt(), buf.readInt());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.channel, 128);
        buf.writeDouble(this.pos.x);
        buf.writeDouble(this.pos.y);
        buf.writeDouble(this.pos.z);
        buf.writeBoolean(this.entity != null);
        if (this.entity != null) {
            buf.writeUUID(this.entity);
        }
        buf.writeInt(this.sequence);
        buf.writeInt(this.dimension);
    }

    @Override
    public boolean isCorrupt() {
        return this.channel == null;
    }

    @Override
    public ResourceLocation getId() {
        return PACKET_ID;
    }

    public static PingLocationC2SPacket readSafe(FriendlyByteBuf buf) {
        return PacketHandler.readSafe(buf, PingLocationC2SPacket.class);
    }

    @NotNull
    public CustomPacketPayload.Type<PingLocationC2SPacket> type() {
        return PACKET_TYPE;
    }
}

