/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.core.PingView;
import nx.pingwheel.common.math.ScreenPos;
import nx.pingwheel.common.render.DrawContext;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.util.InputUtils;

public class PingLocationRenderer {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();

    private PingLocationRenderer() {
    }

    public static void draw(DrawContext ctx, PingView ping) {
        boolean showNameLabels;
        ScreenPos screenPos = ping.getScreenPos();
        if (screenPos == null) {
            return;
        }
        PoseStack m = ctx.getMatrices();
        float pingScale = ping.getScale();
        m.pushPose();
        m.translate(screenPos.x, screenPos.y, 0.0f);
        m.scale(pingScale, pingScale, 1.0f);
        MutableComponent distanceText = LanguageUtils.UNIT_METERS.get("%,.1f".formatted(ping.getDistance()));
        ctx.renderLabel((Component)distanceText, -1.5f, null);
        ctx.renderPing(ping.getItemStack(), CLIENT_CONFIG.isItemIconVisible());
        PlayerInfo author = ping.getPlayerInfo();
        boolean bl = showNameLabels = CLIENT_CONFIG.isNameLabelForced() || InputUtils.KEY_BINDING_NAME_LABELS.isDown();
        if (showNameLabels && author != null) {
            MutableComponent displayName = PlayerTeam.formatNameForTeam((Team)author.getTeam(), (Component)Component.literal((String)author.getProfile().getName()));
            ctx.renderLabel((Component)displayName, 1.75f, author);
        }
        m.popPose();
    }
}

