/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.Mth;

public class Configuration {
    private final HashMap<String, Object> options = new HashMap();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path path;

    public Configuration(String fileName) throws IOException {
        Path config = Path.of("config", new String[0]);
        this.path = Path.of(config.toString(), fileName + ".json");
        if (!Files.exists(config, new LinkOption[0])) {
            Files.createDirectory(config, new FileAttribute[0]);
        }
        if (!Files.exists(this.path, new LinkOption[0])) {
            Files.createFile(this.path, new FileAttribute[0]);
        }
    }

    public void save() {
        try {
            Files.write(this.path, List.of(this.gson.toJson(this.options)), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't save configuration " + String.valueOf(this.path));
        }
    }

    public int getInt(String name, int defaultValue, int min, int max) {
        return (Integer)this.options.compute(name, (s, objects) -> objects == null ? defaultValue : Math.clamp((long)((Integer)objects).intValue(), min, max));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return (Boolean)this.options.compute(name, (s, o) -> o == null ? Boolean.valueOf(defaultValue) : o);
    }

    public List<String> getList(String name, List<String> defaultValue) {
        return (List)this.options.compute(name, (s, l) -> l == null ? defaultValue : l);
    }

    public float getFloat(String name, float defaultValue, float min, float max) {
        return ((Float)this.options.compute(name, (s, o) -> Float.valueOf(o == null ? defaultValue : Mth.clamp((float)((Float)o).floatValue(), (float)min, (float)max)))).floatValue();
    }
}

