/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.energy.EnergyStorage;

public class EnergyStorage2
extends EnergyStorage {
    private OnChanged onEnergyChange;

    public EnergyStorage2(int capacity) {
        super(capacity);
    }

    public EnergyStorage2(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public EnergyStorage2(int capacity, int maxReceive, int maxExtract, OnChanged onEnergyChange) {
        super(capacity, maxReceive, maxExtract);
        this.onEnergyChange = onEnergyChange;
    }

    public EnergyStorage2(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public EnergyStorage2(int capacity, int maxTransfer, OnChanged onEnergyChange) {
        super(capacity, maxTransfer);
        this.onEnergyChange = onEnergyChange;
    }

    public void deserializeNBT(HolderLookup.Provider provider, Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)nbt;
            this.energy = compoundTag.getInt("Energy");
        }
    }

    public Tag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt("Energy", this.energy);
        return compoundTag;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        this.onEnergyChanged();
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        if (!simulate) {
            this.onEnergyChanged();
        }
        return super.receiveEnergy(toReceive, simulate);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        if (!simulate) {
            this.onEnergyChanged();
        }
        return super.extractEnergy(toExtract, simulate);
    }

    public void onEnergyChanged() {
        if (this.onEnergyChange != null) {
            this.onEnergyChange.run(this);
        }
    }

    public int selfExtract(int amount, boolean simulate) {
        int energyExtracted = Math.min(this.energy, amount);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public static interface OnChanged {
        public void run(EnergyStorage2 var1);
    }
}

