/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import java.util.function.Predicate;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidContainer
extends FluidTank {
    private Runnable onChangedAction;
    private final boolean canExtract;

    public FluidContainer(int capacity, boolean canExtract) {
        this(capacity, fluidStack -> true, canExtract);
    }

    public FluidContainer(int capacity, Predicate<FluidStack> validator, boolean canExtract) {
        super(capacity, validator);
        this.canExtract = canExtract;
    }

    public FluidContainer(int capacity, boolean canExtract, Runnable onChangedAction) {
        super(capacity);
        this.canExtract = canExtract;
        this.onChangedAction = onChangedAction;
    }

    public FluidContainer(int capacity, Predicate<FluidStack> validator, boolean canExtract, Runnable onChangedAction) {
        super(capacity, validator);
        this.canExtract = canExtract;
        this.onChangedAction = onChangedAction;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.canExtract) {
            return FluidStack.EMPTY;
        }
        return super.drain(maxDrain, action);
    }

    public FluidStack forceExtract(int max, IFluidHandler.FluidAction action) {
        return super.drain(max, action);
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        if (this.onChangedAction != null) {
            this.onChangedAction.run();
        }
    }
}

