/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import dev.buildtool.satako.Constants;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.ItemContainer;
import dev.buildtool.satako.Methods;
import dev.buildtool.satako.Satako;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Functions {
    public static BlockPos findAirAbove(WorldGenLevel serverWorld, BlockPos start) {
        while (!serverWorld.isEmptyBlock(start) && (start = start.above()).getY() >= 2 && start.getY() <= serverWorld.getHeight() - 2) {
        }
        return start;
    }

    public static BlockPos findAirBelow(WorldGenLevel serverWorld, BlockPos start) {
        while (!serverWorld.isEmptyBlock(start) && (start = start.below()).getY() >= 2 && start.getY() <= serverWorld.getHeight() - 2) {
        }
        return start;
    }

    public static boolean isPlayerInSurvivalMode(Player entityPlayer) {
        return !entityPlayer.isSpectator() && !entityPlayer.isCreative();
    }

    public static boolean isSurvivalPlayer(Entity entity) {
        return entity instanceof Player && Functions.isPlayerInSurvival((Player)entity);
    }

    public static float getDefaultXRightLimbRotation(float limbSwing, float swingAmount) {
        return Mth.cos((float)((float)((double)limbSwing + Math.PI))) * swingAmount;
    }

    public static float getDefaultXLeftLimbRotation(float limbSwing, float swingAmount) {
        return Mth.cos((float)limbSwing) * swingAmount;
    }

    public static float getDefaultHeadYaw(float netYaw) {
        return netYaw * ((float)Math.PI / 180);
    }

    public static float getDefaultHeadPitch(float pitch) {
        return pitch * ((float)Math.PI / 180);
    }

    public static boolean isInSightOf(Entity watched, LivingEntity watcher, float angleRange) {
        float threshold;
        assert (angleRange <= 180.0f);
        Vec3 vecOne = new Vec3(watched.getX() - watcher.getX(), watched.getY() + watched.getEyePosition((float)1.0f).y - watcher.getY() - watcher.getEyePosition((float)1.0f).y, watched.getZ() - watcher.getZ()).normalize();
        Vec3 vecTwo = watcher.getViewVector(1.0f).normalize();
        double dotproduct = vecTwo.dot(vecOne);
        if (dotproduct > (double)(threshold = (180.0f - angleRange) / 180.0f)) {
            return watcher.hasLineOfSight(watched);
        }
        return false;
    }

    public static BlockPos performBlockRayTrace(Entity from, double distance, Level world) {
        Vec3 eyesPosition = from.getEyePosition(1.0f);
        Vec3 look = from.getLookAngle();
        BlockPos blockPos = new BlockPos((int)eyesPosition.x, (int)eyesPosition.y, (int)eyesPosition.z);
        while (world.isEmptyBlock(blockPos)) {
            eyesPosition = eyesPosition.add(look);
            blockPos = new BlockPos((int)eyesPosition.x, (int)eyesPosition.y, (int)eyesPosition.z);
            double dist = from.distanceToSqr(eyesPosition.x, eyesPosition.y, eyesPosition.z);
            if (!(dist >= distance * distance)) continue;
            break;
        }
        return blockPos;
    }

    public static boolean isDirectionalBlockPowered(Direction blockDirection, BlockPos blockPosition, BlockPos pulsePosition, Level world) {
        BlockState backstate;
        Direction back = blockDirection.getOpposite();
        BlockPos backPosition = blockPosition.relative(back);
        if (pulsePosition.equals((Object)backPosition) && (backstate = world.getBlockState(backPosition)).isSignalSource()) {
            return world.hasSignal(backPosition, back);
        }
        return false;
    }

    public static Direction getPowerIncomingDirection(BlockPos pulsePosition, BlockPos target, Block notifier, Level world) {
        BlockState source = world.getBlockState(pulsePosition);
        for (Direction value : Direction.values()) {
            BlockState sidestate;
            BlockPos sidepos = target.relative(value);
            if (!sidepos.equals((Object)pulsePosition) || (sidestate = world.getBlockState(sidepos)) != source || notifier != sidestate.getBlock() || sidestate.getDirectSignal((BlockGetter)world, sidepos, value) <= 0) continue;
            return value;
        }
        return null;
    }

    public static int getDirectPower(BlockPos source, BlockPos target, Block notifier, Level world) {
        BlockState sourceState = world.getBlockState(source);
        for (Direction enumFacing : Direction.values()) {
            BlockState sidestate;
            BlockPos sidepos = target.relative(enumFacing);
            if (!sidepos.equals((Object)source) || (sidestate = world.getBlockState(sidepos)) != sourceState || notifier != sidestate.getBlock()) continue;
            return sidestate.getDirectSignal((BlockGetter)world, sidepos, enumFacing);
        }
        return 0;
    }

    public static boolean isNotifierAdjacent(BlockPos source, BlockPos target, Block notifier, Level world) {
        BlockState sourceState = world.getBlockState(source);
        for (Direction enumFacing : Direction.values()) {
            BlockState sidestate;
            BlockPos sidepos = target.relative(enumFacing);
            if (!sidepos.equals((Object)source) || (sidestate = world.getBlockState(sidepos)) != sourceState || notifier != sidestate.getBlock()) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getBlockPositionFrom(ChunkPos chunkPos) {
        return new BlockPos(chunkPos.x << 4, 0, chunkPos.z << 4);
    }

    public static float degreesToRadians(float degrees) {
        return (float)((double)degrees * Math.PI / 180.0);
    }

    public static float translateToXcoord(float degrees) {
        if (degrees == 90.0f || degrees == -90.0f) {
            return 0.0f;
        }
        if (degrees == 180.0f || degrees == -180.0f) {
            return -1.0f;
        }
        return Mth.cos((float)Functions.degreesToRadians(degrees));
    }

    public static float translateToZcoord(float degrees) {
        if (degrees == 90.0f || degrees == -90.0f) {
            return 1.0f;
        }
        if (degrees == 180.0f || degrees == -180.0f) {
            return 0.0f;
        }
        return Mth.sin((float)Functions.degreesToRadians(degrees));
    }

    public static BlockPos getTopBlockPosition(BlockPos pos, Level world) {
        BlockPos blockpos = new BlockPos(pos.getX(), world.getHeight() - 16, pos.getZ());
        BlockState nextstate = world.getBlockState(blockpos);
        while (nextstate == Blocks.AIR.defaultBlockState()) {
            blockpos = blockpos.below();
            nextstate = world.getBlockState(blockpos);
        }
        return blockpos;
    }

    @Nullable
    public static Entity findEntityOnPath(Level world, Entity watcher) {
        Entity entity = null;
        Vec3 position = watcher.getEyePosition(1.0f);
        Vec3 look = watcher.getLookAngle();
        AABB axisAlignedBB = new AABB(new BlockPos((int)watcher.getX(), (int)watcher.getY(), (int)watcher.getZ())).inflate(7.0);
        List entities = world.getEntities(watcher, axisAlignedBB);
        int counter = 0;
        block0: while (true) {
            position = position.add(look);
            for (Entity entity1 : entities) {
                if (!entity1.getBoundingBox().contains(position)) continue;
                entity = entity1;
                break block0;
            }
            if (counter > 10) break;
            ++counter;
        }
        return entity;
    }

    public static boolean writeUUID(CompoundTag nbtTagCompound, String key, UUID uuid) {
        if (uuid != null && !uuid.equals(Util.NIL_UUID)) {
            nbtTagCompound.putUUID(key, uuid);
            return true;
        }
        return false;
    }

    public static UUID readUUID(CompoundTag nbtTagCompound, String key) {
        UUID uuid = nbtTagCompound.getUUID(key);
        return uuid.equals(Util.NIL_UUID) ? null : uuid;
    }

    public static int readEnum(CompoundTag compound, String key) {
        return compound.getByte(key);
    }

    public static boolean isLiquid(Level world, BlockPos pos) {
        FluidState fluidState = world.getFluidState(pos);
        Fluid fluid = fluidState.getType();
        return fluid != Fluids.EMPTY;
    }

    public static boolean isFlowingLiquid(Level world, BlockPos position) {
        FluidState fluidState = world.getFluidState(position);
        Fluid fluid = fluidState.getType();
        return fluid != Fluids.EMPTY && !fluid.isSource(fluidState);
    }

    public static boolean isLiquidSource(Level world, BlockPos position) {
        FluidState fluidState = world.getFluidState(position);
        Fluid fluid = fluidState.getType();
        return fluid != Fluids.EMPTY && fluid.isSource(fluidState);
    }

    public static boolean isLookingAtHead(LivingEntity watcher, Entity target) {
        Vec3 lookvector = watcher.getViewVector(1.0f).normalize();
        Vec3 positionvector = new Vec3(target.getX() - watcher.getX(), watcher.getBoundingBox().minY + (double)target.getEyeHeight() - (watcher.getY() + (double)watcher.getEyeHeight()), target.getZ() - watcher.getZ());
        double lengthVector = positionvector.length();
        double dotProduct = lookvector.dot(positionvector = positionvector.normalize());
        if (dotProduct > 1.0 - 0.025 / lengthVector) {
            return watcher.hasLineOfSight(target);
        }
        return false;
    }

    public static HashSet<BlockPos> getConnectedBlocks(Block of, Direction[] checkedSides, BlockPos pos, Level world, HashSet<BlockPos> positions, int limit) {
        assert (limit > 1) : "Limit must be >1";
        if (world.getBlockState(pos).getBlock() == of) {
            positions.add(pos);
        }
        if (positions.size() >= limit) {
            return positions;
        }
        for (Direction checkedSide : checkedSides) {
            BlockPos side = pos.relative(checkedSide);
            BlockState next = world.getBlockState(side);
            Block block = next.getBlock();
            if (block != of) continue;
            if (!positions.contains(side)) {
                Functions.getConnectedBlocks(of, (Direction[])ArrayUtils.removeElement((Object[])Direction.values(), (Object)checkedSide.getOpposite()), side, world, positions, limit);
                continue;
            }
            positions.add(side);
            if (positions.size() < limit) continue;
            return positions;
        }
        return positions;
    }

    public static boolean isEmpty(Collection<ItemStack> itemStackCollection) {
        for (ItemStack itemStack : itemStackCollection) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayerInSurvival(Player player) {
        return !player.isCreative() && !player.isSpectator();
    }

    public static boolean isSuperClass(Class<?> subject, Object of) {
        if (of.getClass() == Class.class) {
            return subject.isAssignableFrom((Class)of);
        }
        return subject.isInstance(of);
    }

    @Deprecated
    public static List<BlockPos> boundingBoxToPositions(AABB axisAlignedBB) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (double X = axisAlignedBB.minX; X <= axisAlignedBB.maxX; X += 1.0) {
            for (double Y = axisAlignedBB.minY; Y <= axisAlignedBB.maxY; Y += 1.0) {
                for (double Z = axisAlignedBB.minZ; Z <= axisAlignedBB.maxZ; Z += 1.0) {
                    positions.add(new BlockPos((int)X, (int)Y, (int)Z));
                }
            }
        }
        return positions;
    }

    public static List<BlockPos> bbToPositions(AABB axisAlignedBB) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (double x = axisAlignedBB.minX; x < axisAlignedBB.maxX; x += 1.0) {
            for (double y = axisAlignedBB.minY; y < axisAlignedBB.maxY; y += 1.0) {
                for (double z = axisAlignedBB.minZ; z < axisAlignedBB.maxZ; z += 1.0) {
                    positions.add(new BlockPos((int)x, (int)y, (int)z));
                }
            }
        }
        return positions;
    }

    public static Direction randomHorizontalFacing() {
        return Constants.HORIZONTALS[Methods.RANDOMGENERATOR.nextInt(Constants.HORIZONTALS.length)];
    }

    public static boolean canReplaceBlock(BlockPos blockPos, Level world) {
        BlockState iBlockState = world.getBlockState(blockPos);
        if (iBlockState.hasBlockEntity()) {
            return false;
        }
        return iBlockState.getDestroySpeed((BlockGetter)world, blockPos) != -1.0f;
    }

    public static ItemEntity spawnItemInWorld(ItemStack itemStack, Level world, BlockPos pos) {
        if (world.isClientSide) {
            throw new IllegalArgumentException("Don't spawn items in client world");
        }
        ItemEntity entityItem = new ItemEntity(world, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, itemStack);
        world.addFreshEntity((Entity)entityItem);
        entityItem.setDeltaMovement(0.0, 0.0, 0.0);
        return entityItem;
    }

    public static BlockPos getPosAboveSolidBlock(Level world, BlockPos blockPos) {
        blockPos = blockPos.above(world.getHeight());
        BlockState blockState = world.getBlockState(blockPos);
        while (blockState.canBeReplaced() || blockState.getBlock() instanceof LeavesBlock) {
            blockPos = blockPos.below();
            blockState = world.getBlockState(blockPos);
        }
        blockPos = blockPos.above();
        return blockPos;
    }

    public static ArrayList<Direction> getOtherDirections(Direction of) {
        ArrayList<Direction> sidedirections = new ArrayList<Direction>(5);
        switch (of) {
            case DOWN: {
                Collections.addAll(sidedirections, Direction.UP, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case UP: {
                Collections.addAll(sidedirections, Direction.DOWN, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case EAST: {
                Collections.addAll(sidedirections, Direction.WEST, Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case WEST: {
                Collections.addAll(sidedirections, Direction.EAST, Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case SOUTH: {
                Collections.addAll(sidedirections, Direction.NORTH, Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST);
                break;
            }
            case NORTH: {
                Collections.addAll(sidedirections, Direction.SOUTH, Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST);
            }
        }
        return sidedirections;
    }

    public static boolean areItemTypesEqual(ItemStack one, ItemStack two) {
        if (!one.isEmpty() && !two.isEmpty()) {
            return ItemStack.isSameItemSameComponents((ItemStack)one, (ItemStack)two);
        }
        return false;
    }

    public static boolean areItemsEqualIgnoreNbt(ItemStack one, ItemStack two) {
        if (!one.isEmpty() && !two.isEmpty()) {
            return ItemStack.isSameItem((ItemStack)one, (ItemStack)two) && one.getDamageValue() == two.getDamageValue();
        }
        return false;
    }

    public static int getFuelValue(@NotNull ItemStack stack) {
        return AbstractFurnaceBlockEntity.getFuel().getOrDefault(stack.getItem(), 0);
    }

    public static String getBlockName(BlockState blockState) {
        if (blockState.getBlock() instanceof AirBlock) {
            return "Air";
        }
        ItemStack itemStack = new ItemStack((ItemLike)blockState.getBlock(), 1);
        if (!itemStack.isEmpty()) {
            return itemStack.getDisplayName().getString();
        }
        return blockState.getBlock().getDescriptionId();
    }

    public static boolean removeHeldItem(Player player, Item item) {
        if (!player.getMainHandItem().isEmpty() && player.getMainHandItem().getItem() == item) {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            return true;
        }
        if (!player.getOffhandItem().isEmpty() && player.getOffhandItem().getItem() == item) {
            player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
            return true;
        }
        return false;
    }

    public static ItemStack getStackFromBlockState(BlockState blockState) {
        Item b;
        ItemStack ds = new ItemStack((ItemLike)blockState.getBlock(), 1);
        if (ds.isEmpty() && !((b = Item.byBlock((Block)blockState.getBlock())) instanceof AirItem)) {
            ds = new ItemStack((ItemLike)b);
        }
        return ds;
    }

    public static Field getSecureField(Class<?> owner, int number) {
        Field[] fields = owner.getDeclaredFields();
        if (number < fields.length) {
            Field f = fields[number];
            if (f.getType() != owner.getEnclosingClass()) {
                f.setAccessible(true);
                return f;
            }
            return Functions.getSecureField(owner.getSuperclass(), number);
        }
        Satako.LOG.error("No such field - index exceeds field array size");
        return null;
    }

    public static Field getSecureField(Class<?> owningClass, String field) {
        Field f = null;
        try {
            f = owningClass.getDeclaredField(field);
            f.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            if (owningClass.getSuperclass() != null) {
                return Functions.getSecureField(owningClass.getSuperclass(), field);
            }
            Satako.LOG.error("Searched all super classes - field " + field + " not found");
        }
        return f;
    }

    public static Method getAnyMethod(Class<?> owner, String name, Class<?> ... parameterTypes) {
        Method m = null;
        try {
            m = owner.getDeclaredMethod(name, parameterTypes);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        return m;
    }

    public static Field getPublicField(Class<?> owner, String fieldName) {
        Field f = null;
        try {
            f = owner.getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return f;
    }

    public static int ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static int ticksToMinutes(int ticks) {
        return Functions.ticksToSeconds(ticks) / 60;
    }

    public static int ticksToHours(int ticks) {
        return Functions.ticksToMinutes(ticks) / 60;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int minutesToTicks(int minutes) {
        return Functions.secondsToTicks(minutes) * 60;
    }

    public static int hoursToTicks(int hours) {
        return Functions.minutesToTicks(hours) * 60;
    }

    public static ItemStack getHeldItem(Player playerEntity, Item item) {
        if (playerEntity.getMainHandItem().getItem() == item) {
            return playerEntity.getMainHandItem();
        }
        if (playerEntity.getOffhandItem().getItem() == item) {
            return playerEntity.getOffhandItem();
        }
        return null;
    }

    public static ItemStack getHeldItem(Inventory playerInventory, Item item) {
        return Functions.getHeldItem(playerInventory.player, item);
    }

    public static InteractionHand getHandHoldingItem(Player playerEntity, Item item) {
        if (playerEntity.getMainHandItem().getItem() == item) {
            return InteractionHand.MAIN_HAND;
        }
        if (playerEntity.getOffhandItem().getItem() == item) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    public static Rotation directionToRotation(Direction direction) {
        switch (direction) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static FriendlyByteBuf emptyBuffer() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static boolean removeItems(Item type, int amount, Container container) {
        if (container.countItem(type) < amount) {
            return false;
        }
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack next = container.getItem(i);
            if (next.getItem() != type) continue;
            while (amount > 0) {
                next.shrink(1);
                --amount;
                if (!next.isEmpty()) continue;
            }
            if (amount != 0) continue;
            return true;
        }
        return true;
    }

    public static Direction getLookDirectionOf(LivingEntity livingEntity) {
        if (livingEntity.getXRot() > 45.0f) {
            return Direction.DOWN;
        }
        if (livingEntity.getXRot() < -45.0f) {
            return Direction.UP;
        }
        return livingEntity.getDirection();
    }

    public static boolean contains(Item item, ItemContainer handler) {
        for (int i = 0; i < handler.getSlotCount(); ++i) {
            ItemStack next = handler.getStackInSlot(i);
            if (!next.is(item)) continue;
            return true;
        }
        return false;
    }

    public static IntegerColor getCachedColor(int ofColor) {
        return Constants.COLOR_CACHE.computeIfAbsent(ofColor, IntegerColor::new);
    }

    public static ItemStack getCachedStack(Item item) {
        return Constants.ITEM_CACHE.computeIfAbsent(item, ItemStack::new);
    }

    public static ArrayList<Direction> getSideDirections(Direction of) {
        ArrayList<Direction> sidedirections = new ArrayList<Direction>(5);
        switch (of) {
            case DOWN: 
            case UP: {
                Collections.addAll(sidedirections, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case EAST: 
            case WEST: {
                Collections.addAll(sidedirections, Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case SOUTH: 
            case NORTH: {
                Collections.addAll(sidedirections, Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST);
            }
        }
        return sidedirections;
    }

    public static String getFriendlyDirectionName(Direction direction) {
        switch (direction) {
            case UP: {
                return "Top";
            }
            case DOWN: {
                return "Bottom";
            }
        }
        return StringUtils.capitalize((String)direction.getName());
    }

    public static VoxelShape rotateY(VoxelShape shape, int rotation) {
        ArrayList rotatedShapes = new ArrayList();
        shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            x1 = x1 * 16.0 - 8.0;
            x2 = x2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (rotation) {
                case 90: {
                    rotatedShapes.add(Functions.boxSafe(8.0 - z1, y1 * 16.0, 8.0 + x1, 8.0 - z2, y2 * 16.0, 8.0 + x2));
                    break;
                }
                case 180: {
                    rotatedShapes.add(Functions.boxSafe(8.0 - x1, y1 * 16.0, 8.0 - z1, 8.0 - x2, y2 * 16.0, 8.0 - z2));
                    break;
                }
                case 270: {
                    rotatedShapes.add(Functions.boxSafe(8.0 + z1, y1 * 16.0, 8.0 - x1, 8.0 + z2, y2 * 16.0, 8.0 - x2));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid rotation " + rotation + " (must be 90,180 or 270)");
                }
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> Shapes.joinUnoptimized((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElse(shape).optimize();
    }

    public static VoxelShape rotateX(VoxelShape shape, int rotation) {
        ArrayList rotatedShapes = new ArrayList();
        shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            y1 = y1 * 16.0 - 8.0;
            y2 = y2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (rotation) {
                case 90: {
                    rotatedShapes.add(Functions.boxSafe(x1 * 16.0, 8.0 - z1, 8.0 + y1, x2 * 16.0, 8.0 - z2, 8.0 + y2));
                    break;
                }
                case 180: {
                    rotatedShapes.add(Functions.boxSafe(x1 * 16.0, 8.0 - z1, 8.0 - y1, x2 * 16.0, 8.0 - z2, 8.0 - y2));
                    break;
                }
                case 270: {
                    rotatedShapes.add(Functions.boxSafe(x1 * 16.0, 8.0 + z1, 8.0 - y1, x2 * 16.0, 8.0 + z2, 8.0 - y2));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid rotation " + rotation + " (must be 90,180 or 270)");
                }
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> Shapes.joinUnoptimized((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElse(shape).optimize();
    }

    private static VoxelShape boxSafe(double pMinX, double pMinY, double pMinZ, double pMaxX, double pMaxY, double pMaxZ) {
        double x1 = Math.min(pMinX, pMaxX);
        double x2 = Math.max(pMinX, pMaxX);
        double y1 = Math.min(pMinY, pMaxY);
        double y2 = Math.max(pMinY, pMaxY);
        double z1 = Math.min(pMinZ, pMaxZ);
        double z2 = Math.max(pMinZ, pMaxZ);
        return Block.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static ItemStack findItem(Item item, ItemContainer handler) {
        for (int i = 0; i < handler.getSlotCount(); ++i) {
            ItemStack next = handler.getStackInSlot(i);
            if (!next.is(item)) continue;
            return next;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack insertItemStacked(ItemContainer inventory, ItemStack stack, boolean simulate) {
        ItemStack slot;
        int i;
        if (inventory == null || stack.isEmpty()) {
            return stack;
        }
        if (!stack.isStackable()) {
            return Functions.insertItem(inventory, stack, simulate);
        }
        int sizeInventory = inventory.getSlotCount();
        for (i = 0; !(i >= sizeInventory || ItemStack.isSameItemSameComponents((ItemStack)(slot = inventory.getStackInSlot(i)), (ItemStack)stack) && (stack = inventory.insertItem(i, stack, simulate)).isEmpty()); ++i) {
        }
        if (!stack.isEmpty()) {
            for (i = 0; !(i >= sizeInventory || inventory.getStackInSlot(i).isEmpty() && (stack = inventory.insertItem(i, stack, simulate)).isEmpty()); ++i) {
            }
        }
        return stack;
    }

    public static ItemStack insertItem(ItemContainer dest, ItemStack stack, boolean simulate) {
        if (dest == null || stack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlotCount(); ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public static ItemStack extractItems(ItemContainer itemHandler, ItemStack itemStack, boolean simulate) {
        for (int slot = 0; slot < itemHandler.getSlotCount(); ++slot) {
            ItemStack presentstack = itemHandler.getStackInSlot(slot);
            if (!Functions.areItemTypesEqual(itemStack, presentstack)) continue;
            return itemHandler.extractItem(slot, itemStack.getCount(), simulate);
        }
        return ItemStack.EMPTY;
    }

    public static <E> E cast(Object o) {
        return (E)o;
    }

    @Deprecated
    public static EntityType cast(EntityType<?> e) {
        return e;
    }
}

