/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import dev.buildtool.satako.ItemContainer;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ItemHandler
extends ItemStackHandler
implements ItemContainer {
    private BlockEntity owner;

    public ItemHandler(int size) {
        super(size);
    }

    public ItemHandler(int size, @Nullable BlockEntity tileEntity) {
        this(size);
        this.owner = tileEntity;
        this.stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    public ItemHandler(NonNullList<ItemStack> itemStacks) {
        super(itemStacks);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return super.serializeNBT(provider);
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
    }

    @Override
    public int getSlotCount() {
        return this.getSlots();
    }

    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public BlockEntity getOwner() {
        return this.owner;
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setItem(int i, ItemStack stack) {
        if (this.isItemValid(i, stack)) {
            this.stacks.set(i, (Object)stack);
        }
    }

    protected void onContentsChanged(int slot) {
        if (this.owner != null) {
            this.owner.setChanged();
        }
    }

    @Override
    public void setSize(int size) {
        NonNullList old = this.stacks;
        this.stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < Math.min(this.stacks.size(), old.size()); ++i) {
            this.stacks.set(i, (Object)((ItemStack)old.get(i)));
        }
    }
}

