/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemList
implements ItemContainer,
Container {
    protected ArrayList<ItemStack> itemStacks;

    public ItemList(int size) {
        this.itemStacks = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.itemStacks.add(ItemStack.EMPTY);
        }
    }

    public ItemList(List<ItemStack> itemStacks) {
        this.itemStacks = new ArrayList(itemStacks.size());
        this.itemStacks.addAll(itemStacks);
    }

    public ItemList(int capacity, List<ItemStack> itemStacks) {
        this.itemStacks = new ArrayList(capacity);
        for (int i = 0; i < capacity; ++i) {
            if (i < itemStacks.size()) {
                this.itemStacks.add(itemStacks.get(i));
                continue;
            }
            this.itemStacks.add(ItemStack.EMPTY);
        }
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbtCompound = new CompoundTag();
        for (int i = 0; i < this.itemStacks.size(); ++i) {
            ItemStack itemStack = this.itemStacks.get(i);
            if (itemStack.isEmpty()) continue;
            nbtCompound.put("Stack#" + i, itemStack.save(provider));
        }
        nbtCompound.putInt("Size", this.itemStacks.size());
        return nbtCompound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        int count = nbt.getInt("Size");
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                int finalI = i;
                String key = "Stack#" + i;
                if (!nbt.contains(key)) continue;
                ItemStack.parse((HolderLookup.Provider)provider, (Tag)nbt.getCompound(key)).ifPresent(itemStack -> this.itemStacks.set(finalI, (ItemStack)itemStack));
            }
        }
    }

    @Override
    public int getSlotCount() {
        return this.itemStacks.size();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.itemStacks.get(slot);
    }

    @Override
    public List<ItemStack> getItems() {
        return this.itemStacks;
    }

    @Override
    public void setSize(int size) {
        ArrayList<ItemStack> old = this.itemStacks;
        this.itemStacks = new ArrayList(size);
        for (int i = 0; i < Math.min(size, old.size()); ++i) {
            this.itemStacks.add(i, (ItemStack)old.get(i));
        }
    }

    public int getContainerSize() {
        return this.itemStacks.size();
    }

    @Override
    public boolean isEmpty() {
        return Functions.isEmpty(this.itemStacks);
    }

    public ItemStack getItem(int slot) {
        return this.itemStacks.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemstack = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)amount);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.itemStacks, (int)slot);
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack present = this.itemStacks.get(slot);
        if (this.isItemValid(slot, stack)) {
            if (present.isEmpty()) {
                if (!simulate) {
                    this.setItem(slot, stack);
                }
                return ItemStack.EMPTY;
            }
            if (Functions.areItemTypesEqual(present, stack)) {
                int newCount = present.getCount() + stack.getCount();
                int remaining = present.getCount() + stack.getCount() - present.getMaxStackSize();
                if (!simulate) {
                    present.setCount(Math.min(present.getMaxStackSize(), newCount));
                }
                return new ItemStack((ItemLike)stack.getItem(), remaining);
            }
            return stack;
        }
        return stack;
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack out = this.itemStacks.get(slot);
        int toExtract = Math.min(amount, out.getCount());
        if (!simulate) {
            out.setCount(out.getCount() - toExtract);
        }
        return new ItemStack((ItemLike)out.getItem(), toExtract);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public void setItem(int i, ItemStack stack) {
        if (this.isItemValid(i, stack)) {
            this.itemStacks.set(i, stack);
        }
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.itemStacks.clear();
    }
}

