/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import dev.buildtool.satako.Functions;
import dev.buildtool.satako.SatakoNeoforge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class NeoforgeFunctions {
    public static FluidStack getCachedFluidStack(Fluid fluid) {
        return SatakoNeoforge.FLUID_STACK_CACHE.computeIfAbsent(fluid, fluid1 -> new FluidStack(fluid1, 1));
    }

    public static ItemStack extractItems(IItemHandler itemHandler, ItemStack itemStack, boolean simulate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack presentstack = itemHandler.getStackInSlot(slot);
            if (!Functions.areItemTypesEqual(itemStack, presentstack)) continue;
            return itemHandler.extractItem(slot, itemStack.getCount(), simulate);
        }
        return ItemStack.EMPTY;
    }

    public static boolean insertItem(IItemHandler iItemHandler, ItemStack itemStack) {
        ItemStack out = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)itemStack.copy(), (boolean)false);
        return out.isEmpty();
    }

    public static boolean canInsertItem(IItemHandler into, ItemStack stack) {
        int i;
        if (stack.isEmpty()) {
            return false;
        }
        int slots = into.getSlots();
        for (i = 0; i < slots; ++i) {
            ItemStack result;
            ItemStack pressent = into.getStackInSlot(i);
            if (!into.isItemValid(i, stack) || !Functions.areItemTypesEqual(stack, pressent) || !(result = into.insertItem(i, stack, true)).isEmpty()) continue;
            return true;
        }
        for (i = 0; i < slots; ++i) {
            ItemStack rem;
            ItemStack next = into.getStackInSlot(i);
            if (!next.isEmpty() || !into.isItemValid(i, stack) || !(rem = into.insertItem(i, stack, true)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Item item, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack next = handler.getStackInSlot(i);
            if (!next.is(item)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack findItem(Item item, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack next = handler.getStackInSlot(i);
            if (!next.is(item)) continue;
            return next;
        }
        return ItemStack.EMPTY;
    }

    public static int findItemIn(IItemHandler itemHandler, ItemStack stack) {
        int size = itemHandler.getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack nextstack = itemHandler.getStackInSlot(slot);
            if (!Functions.areItemTypesEqual(nextstack, stack)) continue;
            return slot;
        }
        return -1;
    }
}

