/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dev.buildtool.satako.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.FillCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Satako {
    public static final String MOD_NAME = "Satako";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Satako");
    public static final String ID = "satako";
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.fill.failed"));
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((p_304218_, p_304219_) -> Component.translatableEscape((String)"commands.fill.toobig", (Object[])new Object[]{p_304218_, p_304219_}));

    public static void run() {
        LOG.info("Platform hooks - {}", (Object)Services.PLATFORM.getClass().getSimpleName());
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        RootCommandNode rootCommandNode = dispatcher.getRoot();
        LiteralArgumentBuilder summon2 = (LiteralArgumentBuilder)Commands.literal((String)"summon2").requires(commandSource -> commandSource.hasPermission(2));
        SuggestionProvider namespaces = (context, builder) -> SharedSuggestionProvider.suggest(BuiltInRegistries.ENTITY_TYPE.stream().map(entityType -> BuiltInRegistries.ENTITY_TYPE.getKey(entityType).getNamespace()), (SuggestionsBuilder)builder);
        SuggestionProvider entities = (context, builder) -> SharedSuggestionProvider.suggest(BuiltInRegistries.ENTITY_TYPE.stream().filter(entityType -> ((String)context.getArgument("namespace", String.class)).equals(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).getNamespace())).map(entityType -> BuiltInRegistries.ENTITY_TYPE.getKey(entityType).getPath()), (SuggestionsBuilder)builder);
        RequiredArgumentBuilder namespace = Commands.argument((String)"namespace", (ArgumentType)StringArgumentType.string()).suggests(namespaces);
        RequiredArgumentBuilder entityName = Commands.argument((String)"entity", (ArgumentType)StringArgumentType.string()).suggests(entities);
        entityName.executes(context -> {
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)((String)context.getArgument("namespace", String.class)), (String)((String)context.getArgument("entity", String.class)));
            CommandSourceStack commandSource = (CommandSourceStack)context.getSource();
            return Satako.summonEntity(commandSource, commandSource.getPosition().add(0.5, 0.0, 0.5), resourceLocation);
        });
        RequiredArgumentBuilder position = Commands.argument((String)"position", (ArgumentType)Vec3Argument.vec3((boolean)true));
        position.executes(context -> {
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)((String)context.getArgument("namespace", String.class)), (String)((String)context.getArgument("entity", String.class)));
            CommandSourceStack commandSource = (CommandSourceStack)context.getSource();
            Vec3 vector3d = Vec3Argument.getVec3((CommandContext)context, (String)"position");
            return Satako.summonEntity(commandSource, vector3d, resourceLocation);
        });
        LiteralCommandNode built = summon2.build();
        ArgumentCommandNode domain = namespace.build();
        ArgumentCommandNode name = entityName.build();
        built.addChild((CommandNode)domain);
        domain.addChild((CommandNode)name);
        name.addChild((CommandNode)position.build());
        rootCommandNode.addChild((CommandNode)built);
        SuggestionProvider mods = (context, builder) -> SharedSuggestionProvider.suggest(() -> BuiltInRegistries.ITEM.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet()).iterator(), (SuggestionsBuilder)builder);
        SuggestionProvider items = (context, builder) -> SharedSuggestionProvider.suggest(() -> BuiltInRegistries.ITEM.keySet().stream().filter(resourceLocation -> resourceLocation.getNamespace().equals(context.getArgument("mod", String.class))).map(ResourceLocation::getPath).collect(Collectors.toSet()).iterator(), (SuggestionsBuilder)builder);
        LiteralArgumentBuilder give2 = (LiteralArgumentBuilder)Commands.literal((String)"give2").requires(commandSource -> commandSource.hasPermission(2));
        RequiredArgumentBuilder targets = Commands.argument((String)"targets", (ArgumentType)EntityArgument.players());
        RequiredArgumentBuilder itemmod = Commands.argument((String)"mod", (ArgumentType)StringArgumentType.string()).suggests(mods);
        RequiredArgumentBuilder itemPath = Commands.argument((String)"item", (ArgumentType)StringArgumentType.string()).suggests(items);
        itemPath.executes(context -> Satako.giveItems((CommandContext<CommandSourceStack>)context, 1));
        RequiredArgumentBuilder count = Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1));
        count.executes(context -> Satako.giveItems((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"count")));
        LiteralCommandNode giveNode = give2.build();
        ArgumentCommandNode players = targets.build();
        ArgumentCommandNode itemDomain = itemmod.build();
        ArgumentCommandNode item = itemPath.build();
        ArgumentCommandNode countNode = count.build();
        giveNode.addChild((CommandNode)players);
        players.addChild((CommandNode)itemDomain);
        itemDomain.addChild((CommandNode)item);
        item.addChild((CommandNode)countNode);
        rootCommandNode.addChild((CommandNode)giveNode);
        SuggestionProvider mods2 = (context, builder) -> SharedSuggestionProvider.suggest((Iterable)BuiltInRegistries.ENTITY_TYPE.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        SuggestionProvider entities2 = (context, builder) -> SharedSuggestionProvider.suggest((Iterable)BuiltInRegistries.ENTITY_TYPE.keySet().stream().filter(resourceLocation -> resourceLocation.getNamespace().equals(context.getArgument("mod", String.class))).map(ResourceLocation::getPath).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        LiteralArgumentBuilder kill2 = (LiteralArgumentBuilder)Commands.literal((String)"killall").requires(commandSourceStack -> commandSourceStack.hasPermission(2));
        RequiredArgumentBuilder entityMod = Commands.argument((String)"mod", (ArgumentType)StringArgumentType.string()).suggests(mods2);
        RequiredArgumentBuilder entityPath = Commands.argument((String)"entity", (ArgumentType)StringArgumentType.string()).suggests(entities2);
        kill2.executes(commandContext -> {
            ServerLevel serverLevel = ((CommandSourceStack)commandContext.getSource()).getLevel();
            double d0 = 150.0;
            AABB aabb = new AABB(-d0, -d0, -d0, d0 + 1.0, d0 + 1.0, d0 + 1.0);
            List entityList = serverLevel.getEntitiesOfClass(LivingEntity.class, aabb, living -> !(living instanceof Player));
            entityList.forEach(Entity::kill);
            return entityList.size();
        });
        entityPath.executes(context -> {
            ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).getLevel();
            double d0 = 150.0;
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)((String)context.getArgument("mod", String.class)), (String)((String)context.getArgument("entity", String.class))));
            AABB aabb = new AABB(-d0, -d0, -d0, d0 + 1.0, d0 + 1.0, d0 + 1.0);
            List entityList = serverLevel.getEntities((EntityTypeTest)entityType, aabb, entity -> true);
            entityList.forEach(Entity::kill);
            if (entityList.size() == 1) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.kill.success.single", (Object[])new Object[]{((Entity)entityList.iterator().next()).getDisplayName()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.kill.success.multiple", (Object[])new Object[]{entityList.size()}), true);
            }
            return entityList.size();
        });
        LiteralCommandNode killNode = kill2.build();
        ArgumentCommandNode modsNode = entityMod.build();
        ArgumentCommandNode entitiesNode = entityPath.build();
        killNode.addChild((CommandNode)modsNode);
        modsNode.addChild((CommandNode)entitiesNode);
        rootCommandNode.addChild((CommandNode)killNode);
        SuggestionProvider mods3 = (context, builder) -> SharedSuggestionProvider.suggest((Iterable)BuiltInRegistries.ENTITY_TYPE.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        SuggestionProvider entities3 = (context, builder) -> SharedSuggestionProvider.suggest((Iterable)BuiltInRegistries.ENTITY_TYPE.keySet().stream().filter(resourceLocation -> resourceLocation.getNamespace().equals(context.getArgument("mod", String.class))).map(ResourceLocation::getPath).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        LiteralArgumentBuilder discard = (LiteralArgumentBuilder)Commands.literal((String)"removeall").requires(commandSourceStack -> commandSourceStack.hasPermission(2));
        RequiredArgumentBuilder entityMod2 = Commands.argument((String)"mod", (ArgumentType)StringArgumentType.string()).suggests(mods3);
        RequiredArgumentBuilder entityPath2 = Commands.argument((String)"entity", (ArgumentType)StringArgumentType.string()).suggests(entities3);
        discard.executes(commandContext -> {
            ServerLevel serverLevel = ((CommandSourceStack)commandContext.getSource()).getLevel();
            double d0 = 150.0;
            AABB aabb = new AABB(-d0, -d0, -d0, d0 + 1.0, d0 + 1.0, d0 + 1.0);
            List entityList = serverLevel.getEntitiesOfClass(LivingEntity.class, aabb, living -> !(living instanceof Player));
            entityList.forEach(Entity::discard);
            return entityList.size();
        });
        entityPath2.executes(context -> {
            ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).getLevel();
            double d0 = 150.0;
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)((String)context.getArgument("mod", String.class)), (String)((String)context.getArgument("entity", String.class))));
            AABB aabb = new AABB(-d0, -d0, -d0, d0 + 1.0, d0 + 1.0, d0 + 1.0);
            List entityList = serverLevel.getEntities((EntityTypeTest)entityType, aabb, entity -> true);
            entityList.forEach(Entity::discard);
            if (entityList.size() == 1) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"satako.discard.success.single", (Object[])new Object[]{((Entity)entityList.iterator().next()).getDisplayName()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"satako.discard.success.multiple", (Object[])new Object[]{entityList.size()}), true);
            }
            return entityList.size();
        });
        LiteralCommandNode discardNode = discard.build();
        ArgumentCommandNode modsNode2 = entityMod2.build();
        ArgumentCommandNode entitiesNode2 = entityPath2.build();
        discardNode.addChild((CommandNode)modsNode2);
        modsNode2.addChild((CommandNode)entitiesNode2);
        rootCommandNode.addChild((CommandNode)discardNode);
        SuggestionProvider mods4 = (context, builder) -> SharedSuggestionProvider.suggest((Iterable)BuiltInRegistries.BLOCK.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        SuggestionProvider blocks = (context, builder) -> SharedSuggestionProvider.suggest((Iterable)BuiltInRegistries.BLOCK.keySet().stream().filter(resourceLocation -> resourceLocation.getNamespace().equals(context.getArgument("mod", String.class))).map(ResourceLocation::getPath).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"fill2").requires(commandSourceStack -> commandSourceStack.hasPermission(2));
        RequiredArgumentBuilder from = Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos());
        RequiredArgumentBuilder to = Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos());
        RequiredArgumentBuilder argMod = Commands.argument((String)"mod", (ArgumentType)StringArgumentType.string()).suggests(mods4);
        RequiredArgumentBuilder argBlock = Commands.argument((String)"block", (ArgumentType)StringArgumentType.string()).suggests(blocks);
        argBlock.executes(context -> Satako.fillBlocks((CommandSourceStack)context.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"to")), new BlockInput(((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)((String)context.getArgument("block", String.class))))).defaultBlockState(), Collections.emptySet(), null), FillCommand.Mode.REPLACE, null));
        LiteralCommandNode fillNode = command.build();
        ArgumentCommandNode fromNode = from.build();
        ArgumentCommandNode toNode = to.build();
        ArgumentCommandNode modsNode3 = argMod.build();
        ArgumentCommandNode blockNode = argBlock.build();
        fillNode.addChild((CommandNode)fromNode);
        fromNode.addChild((CommandNode)toNode);
        toNode.addChild((CommandNode)modsNode3);
        modsNode3.addChild((CommandNode)blockNode);
        rootCommandNode.addChild((CommandNode)fillNode);
    }

    private static int giveItems(CommandContext<CommandSourceStack> context, int amount) throws CommandSyntaxException {
        String modName = (String)context.getArgument("mod", String.class);
        String itemName = (String)context.getArgument("item", String.class);
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)modName, (String)itemName);
        Item item = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
        Collection serverPlayerEntities = EntityArgument.getPlayers(context, (String)"targets");
        for (ServerPlayer serverplayerentity : serverPlayerEntities) {
            int i = amount;
            while (i > 0) {
                int j = Math.min(item.getDefaultMaxStackSize(), i);
                i -= j;
                ItemStack itemstack = new ItemStack((ItemLike)item, j);
                boolean flag = serverplayerentity.getInventory().add(itemstack);
                if (flag && itemstack.isEmpty()) {
                    itemstack.setCount(1);
                    ItemEntity itementity1 = serverplayerentity.drop(itemstack, false);
                    if (itementity1 != null) {
                        itementity1.makeFakeItem();
                    }
                    serverplayerentity.serverLevel().playSound(null, serverplayerentity.getX(), serverplayerentity.getY(), serverplayerentity.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverplayerentity.getRandom().nextFloat() - serverplayerentity.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    serverplayerentity.inventoryMenu.broadcastChanges();
                    continue;
                }
                ItemEntity itementity = serverplayerentity.drop(itemstack, false);
                if (itementity == null) continue;
                itementity.setNoPickUpDelay();
                itementity.setThrower((Entity)serverplayerentity);
            }
        }
        return 1;
    }

    private static int summonEntity(CommandSourceStack commandSource, Vec3 position, ResourceLocation resourceLocation) {
        ServerLevel serverWorld = commandSource.getLevel();
        Entity entity = ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation)).create((Level)serverWorld);
        if (entity == null) {
            commandSource.sendSuccess(() -> Component.literal((String)("No entity " + resourceLocation.toString())), false);
            return -1;
        }
        entity.setPos(position.x, position.y, position.z);
        if (entity instanceof Mob) {
            ((Mob)entity).finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.COMMAND, null);
        }
        serverWorld.addFreshEntity(entity);
        commandSource.sendSuccess(() -> Component.literal((String)("Summoned " + entity.getName().getString() + " at " + (int)position.x + " " + (int)position.y + " " + (int)position.z)), true);
        return 1;
    }

    private static int fillBlocks(CommandSourceStack source, BoundingBox area, BlockInput newBlock, FillCommand.Mode mode, @Nullable Predicate<BlockInWorld> replacingPredicate) throws CommandSyntaxException {
        int j;
        int i = area.getXSpan() * area.getYSpan() * area.getZSpan();
        if (i > (j = source.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)j, (Object)i);
        }
        ArrayList list = Lists.newArrayList();
        ServerLevel serverlevel = source.getLevel();
        int k = 0;
        for (BlockPos blockpos : BlockPos.betweenClosed((int)area.minX(), (int)area.minY(), (int)area.minZ(), (int)area.maxX(), (int)area.maxY(), (int)area.maxZ())) {
            BlockInput blockinput;
            if (replacingPredicate != null && !replacingPredicate.test(new BlockInWorld((LevelReader)serverlevel, blockpos, true)) || (blockinput = mode.filter.filter(area, blockpos, newBlock, serverlevel)) == null) continue;
            BlockEntity blockentity = serverlevel.getBlockEntity(blockpos);
            Clearable.tryClear((Object)blockentity);
            if (!blockinput.place(serverlevel, blockpos, 2)) continue;
            list.add(blockpos.immutable());
            ++k;
        }
        for (BlockPos blockpos1 : list) {
            Block block = serverlevel.getBlockState(blockpos1).getBlock();
            serverlevel.blockUpdated(blockpos1, block);
        }
        if (k == 0) {
            throw ERROR_FAILED.create();
        }
        int l = k;
        source.sendSuccess(() -> Component.translatable((String)"commands.fill.success", (Object[])new Object[]{l}), true);
        return k;
    }
}

