/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import dev.buildtool.satako.Functions;
import dev.buildtool.satako.integrations.integration.JEI;
import dev.buildtool.satako.platform.Services;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class SatakoClient {
    static List<Component> originalTooltip;
    static List<MutableComponent> properties;
    public static ItemStack targetStack;
    public static boolean jei;

    public static void run() {
        if (Services.PLATFORM.isModLoaded("jei")) {
            jei = true;
        }
    }

    public static void handle(ItemStack itemStack, GuiGraphics graphics) {
        if (Screen.hasAltDown()) {
            Item item = itemStack.getItem();
            Minecraft minecraft = Minecraft.getInstance();
            Screen currentScreen = minecraft.screen;
            if (currentScreen != null) {
                int burnTime;
                int enchantability;
                int stacksize;
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(0, BuiltInRegistries.ITEM.getKey((Object)item).toString());
                ClientLevel world = minecraft.level;
                if (item instanceof MapItem) {
                    assert (world != null);
                    MapItemSavedData mapData = MapItem.getSavedData((ItemStack)itemStack, (Level)world);
                    if (mapData != null) {
                        byte scale = mapData.scale;
                        info.add("Scale: " + scale + "/4");
                        info.add("Dimension: " + String.valueOf(mapData.dimension.location()));
                    }
                } else if (item instanceof BlockItem) {
                    int lightEmission;
                    BlockItem blockItem = (BlockItem)item;
                    Block block = blockItem.getBlock();
                    BlockState defstate = block.defaultBlockState();
                    float friction = block.getFriction();
                    if (friction != 0.6f) {
                        info.add("Slipperiness: " + friction);
                    }
                    if (((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(BlockTags.MINEABLE_WITH_PICKAXE).get()).contains(BuiltInRegistries.BLOCK.wrapAsHolder((Object)block))) {
                        info.add("Harvestable by " + String.valueOf(ChatFormatting.YELLOW) + "pickaxe");
                    }
                    if (((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(BlockTags.MINEABLE_WITH_AXE).get()).contains(BuiltInRegistries.BLOCK.wrapAsHolder((Object)block))) {
                        info.add("Harvestable by " + String.valueOf(ChatFormatting.YELLOW) + "axe");
                    }
                    if (((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(BlockTags.MINEABLE_WITH_SHOVEL).get()).contains(BuiltInRegistries.BLOCK.wrapAsHolder((Object)block))) {
                        info.add("Harvestable by " + String.valueOf(ChatFormatting.YELLOW) + "shovel");
                    }
                    if (((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(BlockTags.MINEABLE_WITH_HOE).get()).contains(BuiltInRegistries.BLOCK.wrapAsHolder((Object)block))) {
                        info.add("Harvestable by " + String.valueOf(ChatFormatting.YELLOW) + "hoe");
                    }
                    assert (world != null);
                    float hardness = defstate.getDestroySpeed((BlockGetter)world, BlockPos.ZERO);
                    if (hardness > 0.0f) {
                        info.add("Hardness: " + hardness);
                    } else if (hardness == -1.0f) {
                        info.add("Unbreakable");
                    }
                    float resistance = block.getExplosionResistance();
                    if (resistance > 0.0f) {
                        float compRes = (resistance + 0.3f) * 0.3f;
                        if (compRes > 5.2f) {
                            info.add("Blast resistance: " + String.format("%.1f", Float.valueOf(resistance)) + " (TNT)");
                        } else if (compRes > 3.9f) {
                            info.add("Blast resistance: " + String.format("%.1f", Float.valueOf(resistance)) + " (Creeper)");
                        } else {
                            info.add("Blast resistance: " + String.format("%.1f", Float.valueOf(resistance)));
                        }
                    }
                    if (((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(BlockTags.BEACON_BASE_BLOCKS).get()).contains(BuiltInRegistries.BLOCK.wrapAsHolder((Object)defstate.getBlock()))) {
                        info.add("Can be used for Beacon");
                    }
                    FireBlock fireBlock = (FireBlock)Blocks.FIRE;
                    if (fireBlock.burnOdds.getInt((Object)defstate.getBlock()) > 0) {
                        info.add("Flammable");
                    }
                    PushReaction pushReaction = defstate.getPistonPushReaction();
                    info.add("Push behavior: " + String.valueOf(pushReaction));
                    if (defstate.hasBlockEntity()) {
                        info.add("Has block entity");
                    }
                    if ((lightEmission = defstate.getLightEmission()) > 0) {
                        info.add("Light: " + lightEmission);
                    }
                    if (defstate.isSignalSource()) {
                        info.add("Redstone component");
                    }
                } else if (item instanceof DiggerItem) {
                    DiggerItem toolItem = (DiggerItem)item;
                    Tier itemTier = toolItem.getTier();
                    float efficiency = itemTier.getSpeed();
                    info.add("Speed: " + efficiency);
                }
                int durability = itemStack.getMaxDamage();
                if (durability > 0) {
                    info.add("Max. durability: " + durability);
                    int durabRemain = durability - itemStack.getDamageValue();
                    if ((float)durabRemain / (float)durability <= 0.1f) {
                        info.add("Durability left: " + durabRemain);
                    }
                }
                if ((stacksize = itemStack.getMaxStackSize()) == 1) {
                    info.add("Non-stackable");
                } else if (stacksize != 64) {
                    info.add("Max. stack size: " + stacksize);
                }
                if (itemStack.get(DataComponents.FOOD) != null) {
                    FoodProperties foodStats = (FoodProperties)itemStack.get(DataComponents.FOOD);
                    assert (foodStats != null);
                    if (foodStats.canAlwaysEat()) {
                        info.add("Always edible");
                    }
                    float nutrition = (float)foodStats.nutrition() / 2.0f;
                    info.add("Restores " + nutrition + " hunger");
                    float saturation = foodStats.saturation();
                    info.add("Saturation: " + saturation);
                    List effects = foodStats.effects();
                    if (!effects.isEmpty()) {
                        info.add(String.valueOf(ChatFormatting.YELLOW) + "Effects:");
                        for (FoodProperties.PossibleEffect pair : effects) {
                            MobEffectInstance effectInstance = pair.effect();
                            info.add("   " + I18n.get((String)effectInstance.getDescriptionId(), (Object[])new Object[0]) + ":");
                            info.add("      Strength: " + effectInstance.getAmplifier());
                            info.add("      Duration: " + effectInstance.getDuration() / 20 + " s.");
                        }
                    }
                }
                if ((enchantability = item.getEnchantmentValue()) > 0) {
                    info.add("Enchantability: " + enchantability);
                }
                if ((burnTime = Functions.getFuelValue(itemStack)) > 0) {
                    info.add("Burn time: " + burnTime + " (" + (float)burnTime / 200.0f + " items)");
                }
                ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
                if (itemStack.is(Items.ENCHANTED_BOOK) && enchantments.size() == 1) {
                    Holder ench = (Holder)enchantments.keySet().iterator().next();
                    info.add("Enchantment id: " + ench.getRegisteredName());
                }
                for (Holder enchantmentHolder : enchantments.keySet()) {
                    int level = enchantments.getLevel(enchantmentHolder);
                    if (level != ((Enchantment)enchantmentHolder.value()).getMaxLevel()) continue;
                }
                HashSet tags = new HashSet();
                BuiltInRegistries.ITEM.getTags().forEach(items -> {
                    if (((HolderSet.Named)items.getSecond()).contains(BuiltInRegistries.ITEM.wrapAsHolder((Object)item))) {
                        tags.add(((TagKey)items.getFirst()).location());
                    }
                });
                if (!tags.isEmpty()) {
                    info.add(String.valueOf(ChatFormatting.AQUA) + "Tags:");
                    tags.forEach(resourceLocation -> info.add("   " + String.valueOf(resourceLocation)));
                }
                if (item instanceof SpawnEggItem) {
                    SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                    EntityType entityType = spawnEggItem.getType(itemStack);
                    if (entityType.fireImmune()) {
                        info.add("Fire-immune");
                    }
                    MobCategory category = entityType.getCategory();
                    info.add("Category: " + category.getName());
                    if (category.isFriendly()) {
                        info.add("Friendly");
                    }
                    if (category.isPersistent()) {
                        info.add("Persistent");
                    }
                    info.add("Size: " + entityType.getWidth() + "x" + entityType.getHeight());
                    info.add("Id: " + BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType).toString());
                    if (entityType.builtInRegistryHolder().tags().count() > 0L) {
                        info.add(String.valueOf(ChatFormatting.AQUA) + "Tags:");
                        entityType.builtInRegistryHolder().tags().forEach(entityTypeTagKey -> info.add("  " + String.valueOf(entityTypeTagKey.location())));
                    }
                }
                properties = info.stream().map(Component::literal).toList();
                if (jei && JEI.ingredientListOverlay != null) {
                    JEI.ingredientListOverlay.getIngredientUnderMouse().flatMap(ITypedIngredient::getItemStack).ifPresent(itemStack1 -> {
                        targetStack = itemStack1;
                    });
                }
            }
        }
        SatakoClient.renderHoveringTooltip(graphics);
    }

    public static void renderHoveringTooltip(GuiGraphics graphics) {
        if (targetStack != null && Screen.hasAltDown()) {
            Minecraft minecraft = Minecraft.getInstance();
            Screen currentScreen = minecraft.screen;
            if (!properties.isEmpty()) {
                int screenHeight;
                int tooltipY;
                int titleLinesCount;
                int theirLongestStringWidth = 0;
                for (Component iTextComponent : originalTooltip) {
                    String string = iTextComponent.getString();
                    int n = minecraft.font.width(string);
                    if (n <= theirLongestStringWidth) continue;
                    theirLongestStringWidth = n;
                }
                int ourLongestStringWidth = 0;
                for (Component component : properties) {
                    int xOffset = minecraft.font.width((FormattedText)component);
                    if (xOffset <= ourLongestStringWidth) continue;
                    ourLongestStringWidth = xOffset;
                }
                double mouseX = minecraft.mouseHandler.xpos() * (double)minecraft.getWindow().getGuiScaledWidth() / (double)minecraft.getWindow().getScreenWidth();
                int xOffset = (int)(mouseX - (double)ourLongestStringWidth) - 40;
                if (xOffset < 0) {
                    xOffset = 0;
                }
                double mouseY = minecraft.mouseHandler.ypos() * (double)minecraft.getWindow().getGuiScaledHeight() / (double)minecraft.getWindow().getScreenHeight();
                int tooltipTextWidth = 0;
                Font font = minecraft.font;
                for (Component component : properties) {
                    titleLinesCount = font.width((FormattedText)component);
                    if (titleLinesCount <= tooltipTextWidth) continue;
                    tooltipTextWidth = titleLinesCount;
                }
                boolean needsWrap = false;
                assert (currentScreen != null);
                int n = currentScreen.width;
                titleLinesCount = 1;
                int tooltipX = xOffset;
                if (tooltipX + tooltipTextWidth + 4 > n && (tooltipX = xOffset - 16 - tooltipTextWidth) < 4) {
                    tooltipTextWidth = xOffset > n / 2 ? xOffset - 12 - 8 : n - 16 - xOffset;
                    needsWrap = true;
                }
                if (needsWrap) {
                    tooltipY = 0;
                    ArrayList<FormattedText> wrappedTextLines = new ArrayList<FormattedText>();
                    for (screenHeight = 0; screenHeight < properties.size(); ++screenHeight) {
                        Component textLine = (Component)properties.get(screenHeight);
                        List wrappedLine = font.getSplitter().splitLines((FormattedText)textLine, tooltipTextWidth, Style.EMPTY);
                        if (screenHeight == 0) {
                            titleLinesCount = wrappedLine.size();
                        }
                        for (FormattedText formattedText : wrappedLine) {
                            FormattedText line = formattedText;
                            int lineWidth = font.width(line);
                            if (lineWidth > tooltipY) {
                                tooltipY = lineWidth;
                            }
                            wrappedTextLines.add(line);
                        }
                    }
                    properties = wrappedTextLines.stream().map(iTextProperties -> Component.literal((String)iTextProperties.getString())).collect(Collectors.toList());
                    tooltipX = xOffset > n / 2 ? xOffset - 16 - tooltipY : xOffset + 12;
                }
                tooltipY = (int)(mouseY - 12.0);
                int tooltipHeight = 8;
                if (properties.size() > 1) {
                    tooltipHeight += (properties.size() - 1) * 10;
                    if (properties.size() > titleLinesCount) {
                        tooltipHeight += 2;
                    }
                }
                screenHeight = currentScreen.height;
                if (tooltipY < 4) {
                    tooltipY = 4;
                } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                    tooltipY = screenHeight - tooltipHeight - 4;
                }
                if (mouseX + (double)theirLongestStringWidth + 12.0 > (double)n) {
                    tooltipX -= theirLongestStringWidth + 10;
                }
                if (tooltipX < 0) {
                    tooltipX = 0;
                }
                graphics.pose().translate(0.0f, 0.0f, 399.0f);
                graphics.renderTooltip(minecraft.font, properties.stream().map(mutableComponent -> Component.literal((String)mutableComponent.getString())).collect(Collectors.toList()), targetStack.getTooltipImage(), tooltipX, tooltipY);
            }
        }
    }
}

