/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.blocks;

import dev.buildtool.satako.platform.Services;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BlockConnectable
extends PipeBlock {
    private boolean dropItems = true;

    public BlockConnectable(float apothem, BlockBehaviour.Properties properties, boolean dropItems) {
        super(apothem, properties);
        this.dropItems = dropItems;
    }

    public BlockConnectable(float apothem, BlockBehaviour.Properties properties) {
        super(apothem, properties);
        if ((double)apothem > 0.5) {
            throw new IllegalArgumentException("Block is too thick");
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        super.createBlockStateDefinition(blockStateBuilder);
        blockStateBuilder.add(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext useContext) {
        return this.makeConnections(useContext.getLevel(), useContext.getClickedPos());
    }

    protected abstract BlockState makeConnections(Level var1, BlockPos var2);

    protected boolean doConnectTo(LevelAccessor world, BlockState blockState, BlockState to, BlockPos pos, BlockPos toPos, Direction direction) {
        return to.is((Block)this);
    }

    public BlockState updateShape(BlockState blockState, Direction on, BlockState state, LevelAccessor world, BlockPos blockPos, BlockPos pos) {
        return (BlockState)blockState.setValue((Property)PROPERTY_BY_DIRECTION.get(on), (Comparable)Boolean.valueOf(this.doConnectTo(world, blockState, state, blockPos, pos, on)));
    }

    public List<Direction> getConnections(BlockState blockState) {
        ArrayList<Direction> directions = new ArrayList<Direction>(6);
        if (((Boolean)blockState.getValue((Property)UP)).booleanValue()) {
            directions.add(Direction.UP);
        }
        if (((Boolean)blockState.getValue((Property)DOWN)).booleanValue()) {
            directions.add(Direction.DOWN);
        }
        if (((Boolean)blockState.getValue((Property)SOUTH)).booleanValue()) {
            directions.add(Direction.SOUTH);
        }
        if (((Boolean)blockState.getValue((Property)NORTH)).booleanValue()) {
            directions.add(Direction.NORTH);
        }
        if (((Boolean)blockState.getValue((Property)WEST)).booleanValue()) {
            directions.add(Direction.WEST);
        }
        if (((Boolean)blockState.getValue((Property)EAST)).booleanValue()) {
            directions.add(Direction.EAST);
        }
        return directions;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (this.dropItems && !state.is(newState.getBlock()) && state.hasBlockEntity()) {
            Services.PLATFORM.dropItemsIfAny(worldIn, pos, state);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }
}

