/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.blocks;

import dev.buildtool.satako.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BlockHorizontal
extends HorizontalDirectionalBlock {
    private boolean dropItems = true;

    public BlockHorizontal(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockHorizontal(BlockBehaviour.Properties p_54120_, boolean dropItems) {
        super(p_54120_);
        this.dropItems = dropItems;
    }

    public BlockState getStateForPlacement(BlockPlaceContext itemUseContext) {
        Direction direction = itemUseContext.getHorizontalDirection();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{FACING});
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (this.dropItems && !state.is(newState.getBlock()) && state.hasBlockEntity()) {
            Services.PLATFORM.dropItemsIfAny(worldIn, pos, state);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public boolean triggerEvent(BlockState state, Level worldIn, BlockPos pos, int id, int param) {
        return state.hasBlockEntity() && worldIn.getBlockEntity(pos).triggerEvent(id, param);
    }
}

