/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.buildtool.satako.Constants;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.client.ClientFunctions;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class ClientMethods {
    @Deprecated
    public static void addCube(VertexConsumer vertexConsumer, Matrix4f matrix4f, int x, int y, int z, float red, float green, float blue, float alpha, boolean addBackFaces, float extruder) {
        vertexConsumer.addVertex(matrix4f, 0.0f, (float)(y + 1) + extruder, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, 0.0f, (float)(y + 1) + extruder, (float)(z + 1)).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, (float)(x + 1), (float)(y + 1) + extruder, (float)(z + 1)).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, (float)(x + 1), (float)(y + 1) + extruder, 0.0f).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, (float)(1 + x), (float)(y + 1) + extruder, 0.0f).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, (float)(1 + x), (float)(y + 1) + extruder, (float)(1 + z)).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, 0.0f, (float)(y + 1) + extruder, (float)(1 + z)).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, 0.0f, (float)(y + 1) + extruder, 0.0f).setColor(red, green, blue, alpha);
        }
        vertexConsumer.addVertex(matrix4f, (float)(1 + x), -extruder, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, (float)(1 + x), -extruder, (float)(1 + z)).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, 0.0f, -extruder, (float)(1 + z)).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, 0.0f, -extruder, 0.0f).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, 0.0f, -extruder, 0.0f).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, 0.0f, -extruder, (float)(1 + z)).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, (float)(1 + x), -extruder, (float)(1 + z)).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, (float)(1 + x), -extruder, 0.0f).setColor(red, green, blue, alpha);
        }
        vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, -extruder).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, 0.0f, (float)(y + 1), -extruder).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, (float)(x + 1), (float)(y + 1), -extruder).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, (float)(x + 1), 0.0f, -extruder).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, (float)(x + 1), 0.0f, -extruder).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, (float)(x + 1), (float)(y + 1), -extruder).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, 0.0f, (float)(y + 1), -extruder).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, -extruder).setColor(red, green, blue, alpha);
        }
        vertexConsumer.addVertex(matrix4f, (float)(x + 1), 0.0f, (float)(z + 1) + extruder).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, (float)(x + 1), (float)(y + 1), (float)(z + 1) + extruder).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, 0.0f, (float)(y + 1), (float)(z + 1) + extruder).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, (float)(z + 1) + extruder).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, (float)(z + 1) + extruder).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, 0.0f, (float)(y + 1), (float)(z + 1) + extruder).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, (float)(x + 1), (float)(y + 1), (float)(z + 1) + extruder).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, (float)(x + 1), 0.0f, (float)(z + 1) + extruder).setColor(red, green, blue, alpha);
        }
        vertexConsumer.addVertex(matrix4f, -extruder, 0.0f, 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, -extruder, 0.0f, (float)(z + 1)).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, -extruder, (float)(y + 1), (float)(z + 1)).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, -extruder, (float)(y + 1), 0.0f).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, -extruder, (float)(y + 1), 0.0f).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, -extruder, (float)(y + 1), (float)(z + 1)).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, -extruder, 0.0f, (float)(z + 1)).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, -extruder, 0.0f, 0.0f).setColor(red, green, blue, alpha);
        }
        vertexConsumer.addVertex(matrix4f, (float)(x + 1) + extruder, (float)(y + 1), 0.0f).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, (float)(x + 1) + extruder, (float)(y + 1), (float)(z + 1)).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, (float)(x + 1) + extruder, 0.0f, (float)(z + 1)).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, (float)(x + 1) + extruder, 0.0f, 0.0f).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, (float)(x + 1) + extruder, 0.0f, 0.0f).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, (float)(x + 1) + extruder, 0.0f, (float)(z + 1)).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, (float)(x + 1) + extruder, (float)(y + 1), (float)(z + 1)).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, (float)(x + 1) + extruder, (float)(y + 1), 0.0f).setColor(red, green, blue, alpha);
        }
    }

    public static void drawCircle(GuiGraphics graphics) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.lineWidth((float)3.0f);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR);
        int num_segments = 16;
        float radius = 200.0f;
        for (int ii = 0; ii < num_segments; ++ii) {
            float theta = 6.283185f * (float)ii / (float)num_segments;
            float xx = radius * Mth.cos((float)theta);
            float yy = radius * Mth.sin((float)theta);
            IntegerColor white = Constants.WHITE;
            bufferbuilder.addVertex(graphics.pose().last().pose(), xx, yy, 0.0f).setColor(white.getRed(), white.getGreen(), white.getBlue(), white.getAlpha());
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
    }

    public static void drawFilledCircle(Tesselator tessellator, float radius, IntegerColor color) {
        int circle_points = 50;
        float angle = 6.2832f / (float)circle_points;
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float angle1 = 0.0f;
        float xx = radius * Mth.cos((float)0.0f);
        float yy = radius * Mth.sin((float)0.0f);
        bufferBuilder.addVertex(xx, yy, 0.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), 255.0f);
        for (int i = 0; i < circle_points; ++i) {
            bufferBuilder.addVertex(radius * Mth.cos((float)angle1), radius * Mth.sin((float)angle1), 0.0f).setColor(0, 0, 0, 255);
            angle1 += angle;
        }
        BufferUploader.draw((MeshData)bufferBuilder.build());
    }

    public static void drawStringWithBackground(GuiGraphics matrixStack, Object obj, int x, int y, IntegerColor background) {
        String string = obj.toString();
        matrixStack.drawString(Minecraft.getInstance().font, string, x + 2, y + 4, background.getIntColor());
    }

    public static void openClientGui(Level world, Screen screen) {
        if (world.isClientSide) {
            Minecraft.getInstance().setScreen(screen);
        }
    }

    public static void drawCenteredString(GuiGraphics matrixStack, Component o, int X, int Y, IntegerColor color) {
        ClientMethods.drawString(matrixStack, o, X - ClientFunctions.calculateStringWidth(o) / 2, Y, color);
    }

    public static void drawCenteredStringWithShadow(GuiGraphics matrixStack, Component o, int X, int Y, IntegerColor color) {
        ClientMethods.drawStringWithShadow(matrixStack, o, X - ClientFunctions.calculateStringWidth(o) / 2, Y, color);
    }

    public static void drawString(GuiGraphics matrixStack, Object o, int X, int Y, IntegerColor color) {
        matrixStack.drawString(Minecraft.getInstance().font, o.toString(), X, Y, color.getIntColor());
    }

    public static void drawStringWithShadow(GuiGraphics matrixStack, Object o, int X, int Y, IntegerColor color) {
        matrixStack.drawString(Minecraft.getInstance().font, o.toString(), X, Y, color.getIntColor());
    }

    public static void drawTooltipLine(GuiGraphics guiGraphics, Component component, int popupX, int popupY, IntegerColor stringColor, IntegerColor backgroundColor, IntegerColor borderColor) {
        guiGraphics.pose().pushPose();
        Font font = Minecraft.getInstance().font;
        int stringWidth = font.width((FormattedText)component);
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(popupX - stringWidth / 2), (int)(popupY - 4), (int)stringWidth, (int)14, (int)0);
        guiGraphics.drawCenteredString(font, component, popupX, popupY - 1, stringColor.getIntColor());
        guiGraphics.pose().popPose();
    }

    public static void drawTooltipLine(GuiGraphics guiGraphics, Component component, int x, int y) {
        ClientMethods.drawTooltipLine(guiGraphics, component, x, y, Constants.WHITE, Constants.GRAY, Constants.YELLOW);
    }

    public static void drawTooltipLines(GuiGraphics guiGraphics, List<MutableComponent> components, int x, int y) {
        List clientTooltipComponents = components.stream().map(component -> new ClientTextTooltip(component.getVisualOrderText())).collect(Collectors.toList());
        int tooltipWidth = 0;
        int tooltipHeight = 0;
        Font font = Minecraft.getInstance().font;
        for (ClientTooltipComponent clientTooltipComponent : clientTooltipComponents) {
            int n = clientTooltipComponent.getWidth(font);
            if (n > tooltipWidth) {
                tooltipWidth = n;
            }
            tooltipHeight += clientTooltipComponent.getHeight();
        }
        guiGraphics.pose().translate(0.0f, 0.0f, 401.0f);
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)tooltipWidth, (int)tooltipHeight, (int)0);
        int stringY = y;
        for (Component component2 : components) {
            guiGraphics.drawString(font, component2, x, stringY, Constants.WHITE.getIntColor());
            stringY += 10;
        }
    }

    public static void addBox(VertexConsumer vertexConsumer, Matrix4f matrix4f, float xOffset, float yOffset, float zOffset, float width, float height, float depth, float red, float green, float blue, float alpha, boolean addBackFaces, float extrusion) {
        float x2 = 0.5f - width / 2.0f;
        float x3 = x2 + width;
        float y2 = 0.5f - height / 2.0f;
        float y3 = y2 + height;
        float z2 = 0.5f - depth / 2.0f;
        float z3 = z2 + depth;
        vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y3 + extrusion, zOffset + z2).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y3 + extrusion, zOffset + z3).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y3 + extrusion, zOffset + z3).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y3 + extrusion, zOffset + z2).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y3 + extrusion, zOffset + z2).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y3 + extrusion, zOffset + z3).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y3 + extrusion, zOffset + z3).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y3 + extrusion, zOffset + z2).setColor(red, green, blue, alpha);
        }
        vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y2 - extrusion, zOffset + z2).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y2 - extrusion, zOffset + z3).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y2 - extrusion, zOffset + z3).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y2 - extrusion, zOffset + z2).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y2 - extrusion, zOffset + z2).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y2 - extrusion, zOffset + z3).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y2 - extrusion, zOffset + z3).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y2 - extrusion, zOffset + z2).setColor(red, green, blue, alpha);
        }
        vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y2, zOffset + z2 - extrusion).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y3, zOffset + z2 - extrusion).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y3, zOffset + z2 - extrusion).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y2, zOffset + z2 - extrusion).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y2, zOffset + z2 - extrusion).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y3, zOffset + z2 - extrusion).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y3, zOffset + z2 - extrusion).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y2, zOffset + z2 - extrusion).setColor(red, green, blue, alpha);
        }
        vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y2, zOffset + z3 + extrusion).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y3, zOffset + z3 + extrusion).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y3, zOffset + z3 + extrusion).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y2, zOffset + z3 + extrusion).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y2, zOffset + z3 + extrusion).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x2, yOffset + y3, zOffset + z3 + extrusion).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y3, zOffset + z3 + extrusion).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x3, yOffset + y2, zOffset + z3 + extrusion).setColor(red, green, blue, alpha);
        }
        vertexConsumer.addVertex(matrix4f, xOffset + x2 - extrusion, yOffset + y2, zOffset + z2).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x2 - extrusion, yOffset + y2, zOffset + z3).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x2 - extrusion, yOffset + height + y2, zOffset + z3).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x2 - extrusion, yOffset + height + y2, zOffset + z2).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, xOffset + x2 - extrusion, yOffset + height + y2, zOffset + z2).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x2 - extrusion, yOffset + height + y2, zOffset + z3).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x2 - extrusion, yOffset + y2, zOffset + z3).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x2 - extrusion, yOffset + y2, zOffset + z2).setColor(red, green, blue, alpha);
        }
        vertexConsumer.addVertex(matrix4f, xOffset + x3 + extrusion, yOffset + y3, zOffset + z2).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x3 + extrusion, yOffset + y3, zOffset + z3).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x3 + extrusion, yOffset + y2, zOffset + z3).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, xOffset + x3 + extrusion, yOffset + y2, zOffset + z2).setColor(red, green, blue, alpha);
        if (addBackFaces) {
            vertexConsumer.addVertex(matrix4f, xOffset + x3 + extrusion, yOffset + y2, zOffset + z2).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x3 + extrusion, yOffset + y2, zOffset + z3).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x3 + extrusion, yOffset + y3, zOffset + z3).setColor(red, green, blue, alpha);
            vertexConsumer.addVertex(matrix4f, xOffset + x3 + extrusion, yOffset + y3, zOffset + z2).setColor(red, green, blue, alpha);
        }
    }

    public static void drawBackground(GuiGraphics graphics, int x, int y, int z, int width, int height, IntegerColor color) {
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)x, (int)y, (int)width, (int)height, (int)z);
    }

    public static void drawTiledSprite(ResourceLocation texture, GuiGraphics graphics, int x, int y, int width, int height) {
        TextureAtlasSprite atlasSprite = Minecraft.getInstance().getGuiSprites().getSprite(texture);
        SpriteContents contents = atlasSprite.contents();
        for (int j = 0; j < width; j += contents.width()) {
            for (int i = 0; i < height; i += contents.height()) {
                graphics.blitSprite(texture, x + j, y + i, contents.width(), contents.height());
            }
        }
    }
}

