/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.client.gui;

import dev.buildtool.satako.client.gui.ExtendedButton;
import dev.buildtool.satako.client.gui.Switchable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class BetterButton
extends ExtendedButton
implements Switchable {
    public boolean verticalScroll;
    public boolean horizontalScroll;
    protected Font fontRenderer;

    public BetterButton(int x, int y, int width, int height, Component text, Button.OnPress pressable) {
        super(x, y, width, height, text, pressable);
        this.fontRenderer = Minecraft.getInstance().font;
    }

    public BetterButton(int x, int y, Component text) {
        this(x, y, Minecraft.getInstance().font.width(text.getString()) + 8, 20, text, null);
    }

    public BetterButton(int x, int y, Component text, Button.OnPress onPress) {
        this(x, y, Minecraft.getInstance().font.width(text.getString()) + 8, 20, text, onPress);
    }

    public static BetterButton centered(int x, int y, Component text, Button.OnPress press) {
        return new BetterButton(x - Minecraft.getInstance().font.width((FormattedText)text) / 2 - 4, y, text, press);
    }

    @Override
    public void setEnabled() {
        this.active = true;
    }

    @Override
    public void setDisabled() {
        this.active = false;
    }

    public void updateWidth() {
        this.setX(this.getX() + this.width / 2 - this.fontRenderer.width((FormattedText)this.getMessage()) / 2);
        this.width = this.fontRenderer.width((FormattedText)this.getMessage()) + 8;
    }

    public void onPress() {
        if (this.onPress != null) {
            this.onPress.onPress((Button)this);
        }
    }

    public void setPressHandler(Button.OnPress pressHandler) {
        this.onPress = pressHandler;
    }
}

