/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.client.gui;

import dev.buildtool.satako.client.gui.RadioButton;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class ButtonGroup {
    private final ArrayList<RadioButton> buttons = new ArrayList();

    public ButtonGroup(RadioButton ... radioButtons) {
        this.buttons.addAll(Arrays.asList(radioButtons));
        this.connect();
    }

    public void add(RadioButton rb) {
        this.buttons.add(rb);
    }

    public void connect() {
        for (RadioButton rb : this.buttons) {
            ArrayList others = (ArrayList)this.buttons.clone();
            others.remove(rb);
            for (RadioButton rb2 : others) {
                rb.addNeighbour(rb2);
            }
        }
    }

    @Nullable
    public RadioButton getSelected() {
        for (RadioButton r : this.buttons) {
            if (!r.selected) continue;
            return r;
        }
        return null;
    }

    public void setSelected(int button) {
        if (button >= 0 && button < this.buttons.size()) {
            this.setSelected(this.buttons.get(button));
        }
    }

    public void setSelected(RadioButton button) {
        this.buttons.forEach(radioButton -> {
            radioButton.selected = radioButton == button;
        });
    }

    public ArrayList<RadioButton> getButtons() {
        return this.buttons;
    }
}

