/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.client.gui;

import dev.buildtool.satako.Constants;
import dev.buildtool.satako.client.gui.BetterButton;
import dev.buildtool.satako.client.gui.ButtonGroup;
import dev.buildtool.satako.client.gui.RadioButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;

public class DropDownButton
extends BetterButton {
    public HashMap<Component, RadioButton> choices;
    protected final Screen parent;
    protected boolean open;
    protected final List<GuiEventListener> overlappingElements = new ArrayList<GuiEventListener>();

    public DropDownButton(int x, int y, Screen parent) {
        super(x, y, (Component)Component.empty());
        this.parent = parent;
    }

    @Override
    public void onPress() {
        boolean bl = this.open = !this.open;
        if (this.open) {
            if (this.overlappingElements.isEmpty()) {
                this.choices.values().forEach(radioButton -> {
                    radioButton.visible = true;
                    this.parent.renderables.forEach(guiEventListener -> {
                        if (!this.choices.containsValue(guiEventListener) && guiEventListener != this && guiEventListener instanceof AbstractWidget) {
                            AbstractWidget abstractWidget = (AbstractWidget)guiEventListener;
                            block0: for (int i = 0; i < abstractWidget.getWidth(); ++i) {
                                for (int j = 0; j < abstractWidget.getHeight(); ++j) {
                                    if (!this.isInsideArea(abstractWidget.getX() + i, abstractWidget.getY() + j, radioButton.getX(), radioButton.getX() + radioButton.getWidth(), radioButton.getY(), radioButton.getY() + radioButton.getHeight())) continue;
                                    abstractWidget.visible = false;
                                    this.overlappingElements.add((GuiEventListener)abstractWidget);
                                    continue block0;
                                }
                            }
                        }
                    });
                });
            } else {
                this.choices.values().forEach(radioButton -> {
                    radioButton.visible = true;
                });
                this.overlappingElements.forEach(guiEventListener -> {
                    if (guiEventListener instanceof AbstractWidget) {
                        AbstractWidget abstractWidget = (AbstractWidget)guiEventListener;
                        abstractWidget.visible = false;
                    }
                });
            }
        } else {
            this.choices.values().forEach(radioButton -> {
                radioButton.visible = false;
            });
            this.overlappingElements.forEach(guiEventListener -> {
                if (guiEventListener instanceof AbstractWidget) {
                    AbstractWidget a = (AbstractWidget)guiEventListener;
                    a.visible = true;
                }
            });
        }
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mx, int my, float p_93660_) {
        super.renderWidget(guiGraphics, mx, my, p_93660_);
        if (this.open) {
            int widest = this.choices.values().stream().reduce((radioButton, radioButton2) -> radioButton.getWidth() > radioButton2.getWidth() ? radioButton : radioButton2).get().getWidth();
            this.choices.values().forEach(radioButton -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)radioButton.getX(), (int)radioButton.getY(), (int)(radioButton.getX() + widest), (int)(radioButton.getY() + radioButton.getHeight()), (int)Constants.GRAY.getIntColor()));
            guiGraphics.drawString(this.fontRenderer, " :", this.getX() + this.width, this.getY() + this.height / 2 - 4, -1);
        } else {
            guiGraphics.drawString(this.fontRenderer, " V", this.getX() + this.width, this.getY() + this.height / 2 - 4, -1);
        }
    }

    private boolean isInsideArea(int x, int y, int x1, int x2, int y1, int y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public void setChoices(LinkedHashMap<Component, Button.OnPress> map, int selectedButton) {
        int offset = 1;
        ButtonGroup buttonGroup = new ButtonGroup(new RadioButton[0]);
        this.choices = new HashMap(map.size());
        for (Map.Entry<Component, Button.OnPress> entry : map.entrySet()) {
            Component component = entry.getKey();
            Button.OnPress onPress1 = entry.getValue();
            RadioButton radioButton = new RadioButton(this.getX(), this.getY() + 20 * offset++, component, onPress1){

                @Override
                public void onPress() {
                    super.onPress();
                    DropDownButton.this.setMessage(this.getMessage());
                    DropDownButton.this.onPress();
                }
            };
            radioButton.visible = false;
            boolean bl = radioButton.selected = selectedButton + 1 - offset == -1;
            if (radioButton.selected) {
                this.setMessage(radioButton.getMessage());
            }
            this.parent.addRenderableWidget((GuiEventListener)radioButton);
            this.choices.put(component, radioButton);
            buttonGroup.add(radioButton);
            if (radioButton.getWidth() <= this.getWidth()) continue;
            this.width = radioButton.getWidth();
        }
        buttonGroup.connect();
    }

    public void setSelectedButton(int index) {
        int number = 0;
        for (RadioButton radioButton : this.choices.values()) {
            if (index == number) {
                radioButton.selected = true;
                this.setMessage(radioButton.getMessage());
                break;
            }
            ++number;
        }
    }
}

