/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.client.gui;

import dev.buildtool.satako.Constants;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.client.ClientMethods;
import dev.buildtool.satako.client.gui.BetterButton;
import dev.buildtool.satako.client.gui.Switchable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class Label
extends BetterButton
implements Switchable {
    protected boolean enabled;
    protected boolean verticalScroll;
    protected boolean horizontalScroll;
    protected boolean hidden;
    protected int scrollAmount;
    protected Screen parent;
    protected IntegerColor backgroundColor;

    public Label(int x, int y, Component text, IntegerColor backgroundColor) {
        this(x, y, text, backgroundColor, null);
        this.backgroundColor = backgroundColor;
    }

    public Label(int x, int y, Component text, IntegerColor backgroundColor, Button.OnPress pressHandler) {
        super(x, y, Minecraft.getInstance().font.width(text.getString()) + 8, 10, text, pressHandler);
        this.backgroundColor = backgroundColor;
    }

    public static Label centered(int x, int y, Component text, IntegerColor backgroundColor) {
        return new Label(x - Minecraft.getInstance().font.width((FormattedText)text) / 2 - 10, y, text, backgroundColor);
    }

    @Deprecated
    public Label(int x, int y, Component text, @Nullable Screen parent, @Nullable Button.OnPress pressHandler, IntegerColor backgroundColor) {
        super(x, y, Minecraft.getInstance().font.width(text.getString()) + 8, 10, text, pressHandler);
        this.scrollAmount = 20;
        this.parent = parent;
        this.backgroundColor = backgroundColor;
    }

    public Label(int x, int y, Component text, int labelWidth, @Nullable Button.OnPress onPress, IntegerColor color) {
        super(x, y, labelWidth, 10, text, onPress);
        this.backgroundColor = color;
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        if (!this.hidden) {
            ClientMethods.drawBackground(guiGraphics, this.getX() + 4, this.getY() + 4, 399, this.width + 4, this.height + 2, this.backgroundColor);
            guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
            Label.renderScrollingString((GuiGraphics)guiGraphics, (Font)this.fontRenderer, (Component)this.getMessage(), (int)(this.getX() + 4), (int)(this.getY() + 3), (int)(this.getX() + this.getWidth() - 4), (int)(this.getY() + this.getHeight() / 2 + 6), (int)Constants.WHITE.getIntColor());
        }
    }

    @Override
    public void setEnabled() {
        this.enabled = true;
    }

    @Override
    public void setDisabled() {
        this.enabled = false;
    }

    public int getHeight() {
        return super.getHeight() + 10;
    }

    public int getWidth() {
        return super.getWidth() + 12;
    }
}

