/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.buildtool.satako.Constants;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.client.ClientMethods;
import dev.buildtool.satako.client.gui.DynamicTooltip;
import dev.buildtool.satako.platform.Services;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public abstract class MenuScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public static final int POPUP_SPACING = 22;
    protected int centerX;
    protected int centerY;
    protected boolean drawBorders;
    public static final int defaultShowTime = 200;
    protected int popupPositionX;
    protected int popupPositionY;
    protected LinkedHashMap<Component, Integer> showTimes = new LinkedHashMap();
    protected HashMap<AbstractWidget, DynamicTooltip> tooltips = new HashMap();

    public MenuScreen(T container, Inventory playerInventory, Component name, boolean drawBorders_) {
        super(container, playerInventory, name);
        if (Minecraft.getInstance().screen != null) {
            Minecraft.getInstance().screen = null;
        }
        this.drawBorders = drawBorders_;
    }

    public MenuScreen(T menu, Inventory playerInventory, Component name) {
        this(menu, playerInventory, name, true);
    }

    public void init() {
        int maxX = 0;
        int minX = this.imageWidth;
        int maxY = 0;
        for (Slot slot : this.getSlots()) {
            int y;
            int x = slot.x;
            if (x > maxX) {
                maxX = x;
            }
            if (minX > x) {
                minX = x;
            }
            if ((y = slot.y) <= maxY) continue;
            maxY = y;
        }
        this.imageWidth = maxX + 18;
        this.imageHeight = maxY + 18;
        super.init();
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.popupPositionX = this.centerX;
        this.popupPositionY = this.height - 18;
        this.titleLabelY = -14;
        this.titleLabelX = this.imageWidth / 2 - this.font.width((FormattedText)this.getTitle()) / 2;
    }

    protected List<Slot> getSlots() {
        return this.menu.slots;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float p_render_3_) {
        this.renderBackground(guiGraphics, mouseX, mouseY, p_render_3_);
        super.render(guiGraphics, mouseX, mouseY, p_render_3_);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        List<Slot> slots = this.getSlots();
        slots.stream().filter(Slot::isActive).forEach(slot -> Services.PLATFORM.drawSlot((Slot)slot, mouseX, mouseY, guiGraphics, this));
        this.tooltips.forEach((widget, tooltip) -> {
            if (widget.getX() < mouseX && widget.getX() + widget.getWidth() > mouseX && mouseY > widget.getY() && mouseY < widget.getY() + widget.getHeight()) {
                guiGraphics.renderTooltip(this.font, tooltip.getTooltip(), mouseX, mouseY);
            }
        });
        int popupY = this.popupPositionY - (this.showTimes.keySet().size() - 1) * 22;
        for (Map.Entry<Component, Integer> entry : this.showTimes.entrySet()) {
            Component component = entry.getKey();
            Integer integer = entry.getValue();
            if (integer <= 0) continue;
            ClientMethods.drawTooltipLine(guiGraphics, component, this.popupPositionX, popupY);
            popupY += 22;
            Integer n = integer;
            integer = integer - 1;
            entry.setValue(integer);
        }
        this.showTimes.entrySet().removeIf(componentIntegerEntry -> (Integer)componentIntegerEntry.getValue() == 0);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        List<Slot> slots = this.getSlots();
        GlStateManager._clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        slots.stream().filter(Slot::isActive).forEach(s -> Services.PLATFORM.drawSlotBackground((Slot)s, guiGraphics, this));
        IntegerColor color = Constants.BLUE;
        if (this.drawBorders) {
            int intColor = color.getIntColor();
            guiGraphics.hLine(this.leftPos - 1, this.imageWidth + this.leftPos - 2, this.topPos - 1, intColor);
            guiGraphics.hLine(this.leftPos, this.imageWidth + this.leftPos - 2, this.imageHeight + this.topPos - 2, intColor);
            guiGraphics.vLine(this.leftPos - 1, this.topPos - 1, this.imageHeight + this.topPos - 1, intColor);
            guiGraphics.vLine(this.imageWidth + this.leftPos - 2, this.topPos - 1, this.imageHeight + this.topPos - 2, intColor);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int p1, int p2) {
        if (this.menu.slots.isEmpty()) {
            guiGraphics.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width(this.title.getString()) / 2, this.titleLabelY + 19 - this.topPos, Constants.ORANGE.getIntColor());
        } else {
            guiGraphics.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width(this.title.getString()) / 2, this.titleLabelY, Constants.ORANGE.getIntColor());
        }
    }

    public boolean mouseDragged(double p_97752_, double p_97753_, int button, double p_97755_, double p_97756_) {
        if (this.getFocused() != null && button == 0 && this.isDragging()) {
            return this.getFocused().mouseDragged(p_97752_, p_97753_, button, p_97755_, p_97756_);
        }
        return super.mouseDragged(p_97752_, p_97753_, button, p_97755_, p_97756_);
    }

    public void addPopup(Component message, int duration) {
        this.showTimes.put(message, duration);
    }

    public void addPopup(Component message) {
        this.addPopup(message, 200);
    }

    public void addTooltip(AbstractWidget target, DynamicTooltip tooltip) {
        this.tooltips.put(target, tooltip);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        if (this.getFocused() != null && keyCode == 69) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children()) {
            if (!child.mouseClicked(mouseX, mouseY, button)) continue;
            if (button == 0) {
                this.setDragging(true);
            }
            this.setFocused(child);
            return true;
        }
        this.setFocused(null);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDragging()) {
            this.setDragging(false);
            if (this.getFocused() != null) {
                return this.getFocused().mouseReleased(mouseX, mouseY, button);
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

