/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.client.gui;

import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.client.ClientMethods;
import dev.buildtool.satako.client.gui.DynamicColor;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class Rectangle
extends AbstractWidget {
    private Color color;
    protected final FillPercent fillPercent;
    protected TextureAtlasSprite sprite;
    protected ResourceLocation texture;
    protected boolean vertical = true;
    protected DynamicColor dynamicColor;

    @Deprecated
    public Rectangle(int x, int y, int width, int height, @Nullable IntegerColor color, @Nullable TextureAtlasSprite atlasSprite, @Nullable FillPercent fillPercent, boolean vertical) {
        this(x, y, width, height, atlasSprite, fillPercent);
        this.color = () -> Optional.ofNullable(color);
        this.vertical = vertical;
    }

    @Deprecated
    public Rectangle(int x, int y, int width, int height, @Nullable IntegerColor integerColor, @Nullable FillPercent fillPercent) {
        super(x, y, width, height, (Component)Component.empty());
        this.color = () -> Optional.ofNullable(integerColor);
        this.fillPercent = fillPercent;
    }

    public Rectangle(int x, int y, int width, int height, DynamicColor dynamicColor, FillPercent fillPercent) {
        this(x, y, width, height, dynamicColor, fillPercent, true);
    }

    public Rectangle(int x, int y, int width, int height, DynamicColor color, @Nullable FillPercent fillPercent, boolean vertical) {
        super(x, y, width, height, (Component)Component.empty());
        this.dynamicColor = color;
        this.fillPercent = fillPercent;
        this.vertical = vertical;
    }

    private Rectangle(int x, int y, int width, int height, TextureAtlasSprite atlasSprite, @Nullable FillPercent fillPercent) {
        this(x, y, width, height, (IntegerColor)null, fillPercent);
        this.sprite = atlasSprite;
    }

    public Rectangle(int x, int y, int width, int height, TextureAtlasSprite atlasSprite) {
        this(x, y, width, height, atlasSprite, null);
    }

    @Deprecated
    private Rectangle(int x, int y, int width, int height, @Nullable IntegerColor color, TextureAtlasSprite sprite, FillPercent fillPercent) {
        super(x, y, width, height, (Component)Component.empty());
        this.color = () -> Optional.ofNullable(color);
        this.fillPercent = fillPercent;
        this.sprite = sprite;
    }

    public Rectangle(int x, int y, int width, int height, FillPercent fillPercent, TextureAtlasSprite sprite, DynamicColor dynamicColor) {
        this(x, y, width, height, dynamicColor, sprite, fillPercent, true);
    }

    public Rectangle(int x, int y, int width, int height, @Nullable DynamicColor color, TextureAtlasSprite sprite, FillPercent fillPercent, boolean vertical) {
        super(x, y, width, height, (Component)Component.empty());
        this.dynamicColor = color;
        this.fillPercent = fillPercent;
        this.sprite = sprite;
        this.vertical = vertical;
    }

    @Deprecated
    public Rectangle(int x, int y, int width, int height, @Nullable IntegerColor color, TextureAtlasSprite atlasSprite) {
        this(x, y, width, height, color, atlasSprite, null);
        this.sprite = atlasSprite;
    }

    @Deprecated
    public static Rectangle horizontal(int x, int y, int width, int height, @Nullable IntegerColor color, @Nullable TextureAtlasSprite atlasSprite, FillPercent fillPercent) {
        Rectangle rectangle = new Rectangle(x, y, width, height, color, atlasSprite, fillPercent);
        rectangle.vertical = false;
        return rectangle;
    }

    public Rectangle(int x, int y, int width, int height, FillPercent fillPercent, ResourceLocation texture, boolean vertical) {
        super(x, y, width, height, (Component)Component.empty());
        this.fillPercent = fillPercent;
        this.texture = texture;
        this.vertical = vertical;
    }

    public static Rectangle withSprite(int x, int y, int width, int height, TextureAtlasSprite atlasSprite, FillPercent fillPercent) {
        return new Rectangle(x, y, width, height, atlasSprite, fillPercent);
    }

    @Deprecated
    public static Rectangle colored(int x, int y, int width, int height, IntegerColor color, FillPercent fillPercent) {
        return new Rectangle(x, y, width, height, color, fillPercent);
    }

    @Deprecated
    public static Rectangle withColoredSprite(int x, int y, int width, int height, IntegerColor color, TextureAtlasSprite atlasSprite, FillPercent fillPercent) {
        return new Rectangle(x, y, width, height, color, atlasSprite, fillPercent);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().translate(0.0f, 0.0f, 399.0f);
        if (this.sprite != null) {
            int min = Math.min(this.width, this.height);
            if (this.dynamicColor != null) {
                IntegerColor integerColor = this.dynamicColor.getColor();
                guiGraphics.setColor(integerColor.getRed(), integerColor.getGreen(), integerColor.getBlue(), integerColor.getAlpha());
            }
            GuiSpriteScaling.NineSlice nineSlice = new GuiSpriteScaling.NineSlice(min, min, new GuiSpriteScaling.NineSlice.Border(0, 0, 0, 0));
            if (this.fillPercent != null) {
                if (this.vertical) {
                    guiGraphics.blitNineSlicedSprite(this.sprite, nineSlice, this.getX(), (int)((float)(this.getY() + this.height) - (float)this.height * this.fillPercent.getFillPercent()), -90, this.width, (int)((float)this.height * this.fillPercent.getFillPercent()));
                } else {
                    guiGraphics.blitNineSlicedSprite(this.sprite, nineSlice, this.getX(), this.getY(), -90, (int)((float)this.width * this.fillPercent.getFillPercent()), this.height);
                }
            } else {
                guiGraphics.blitNineSlicedSprite(this.sprite, nineSlice, this.getX(), this.getY(), -90, this.width, this.height);
            }
            if (this.dynamicColor != null) {
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (this.texture != null) {
            if (this.fillPercent != null) {
                if (this.vertical) {
                    ClientMethods.drawTiledSprite(this.texture, guiGraphics, this.getX(), (int)((float)(this.getY() + this.height) - (float)this.height * this.fillPercent.getFillPercent()), this.width, (int)((float)this.height * this.fillPercent.getFillPercent()));
                } else {
                    ClientMethods.drawTiledSprite(this.texture, guiGraphics, this.getX(), this.getY(), (int)((float)this.width * this.fillPercent.getFillPercent()), this.height);
                }
            } else {
                ClientMethods.drawTiledSprite(this.texture, guiGraphics, this.getX(), this.getY(), this.width, this.height);
            }
        } else if (this.color != null) {
            this.color.getColor().ifPresent(color1 -> {
                if (this.fillPercent != null) {
                    if (this.vertical) {
                        guiGraphics.fill(this.getX(), (int)((float)(this.getY() + this.height) - (float)this.height * this.fillPercent.getFillPercent()), this.getX() + this.width, this.getY() + this.height, color1.getIntColor());
                    } else {
                        guiGraphics.fill(this.getX(), this.getY(), (int)((float)this.getX() + (float)this.width * this.fillPercent.getFillPercent()), this.getY() + this.height, this.color.getColor().get().getIntColor());
                    }
                } else {
                    guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, color1.getIntColor());
                }
            });
        } else if (this.dynamicColor != null) {
            if (this.fillPercent != null) {
                if (this.vertical) {
                    guiGraphics.fill(this.getX(), (int)((float)(this.getY() + this.height) - (float)this.height * this.fillPercent.getFillPercent()), this.getX() + this.width, this.getY() + this.height, this.dynamicColor.getColor().getIntColor());
                } else {
                    guiGraphics.fill(this.getX(), this.getY(), (int)((float)this.getX() + (float)this.width * this.fillPercent.getFillPercent()), this.getY() + this.height, this.dynamicColor.getColor().getIntColor());
                }
            } else {
                guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, this.dynamicColor.getColor().getIntColor());
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected boolean isValidClickButton(int button) {
        return false;
    }

    @FunctionalInterface
    public static interface FillPercent {
        public float getFillPercent();
    }

    @FunctionalInterface
    public static interface Color {
        public Optional<IntegerColor> getColor();
    }
}

