/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.client.gui;

import dev.buildtool.satako.Constants;
import dev.buildtool.satako.client.ClientMethods;
import dev.buildtool.satako.client.gui.DynamicTooltip;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class Screen2
extends Screen {
    protected int popupPositionX;
    protected int popupPositionY;
    protected LinkedHashMap<Component, Integer> showTimes = new LinkedHashMap();
    protected HashMap<AbstractWidget, DynamicTooltip> tooltips = new HashMap();
    protected int centerX;
    protected int centerY;

    public Screen2(Component title) {
        super(title);
    }

    public void init() {
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.popupPositionX = this.centerX;
        this.popupPositionY = this.height - 18;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float tick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, tick);
        super.render(guiGraphics, mouseX, mouseY, tick);
        guiGraphics.drawCenteredString(this.font, this.getTitle(), this.centerX, 3, Constants.WHITE.getIntColor());
        this.tooltips.forEach((widget, tooltip) -> {
            if (widget.getX() < mouseX && widget.getX() + widget.getWidth() > mouseX && mouseY > widget.getY() && mouseY < widget.getY() + widget.getHeight()) {
                guiGraphics.renderTooltip(this.font, tooltip.getTooltip(), mouseX, mouseY);
            }
        });
        int popupY = this.popupPositionY - (this.showTimes.keySet().size() - 1) * 22;
        for (Map.Entry<Component, Integer> entry : this.showTimes.entrySet()) {
            Component component = entry.getKey();
            Integer integer = entry.getValue();
            if (integer <= 0) continue;
            ClientMethods.drawTooltipLine(guiGraphics, component, this.popupPositionX, popupY);
            popupY += 22;
            Integer n = integer;
            integer = integer - 1;
            entry.setValue(integer);
        }
        this.showTimes.entrySet().removeIf(componentIntegerEntry -> (Integer)componentIntegerEntry.getValue() == 0);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        try {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean charTyped(char typedChar, int keyCode) {
        try {
            return super.charTyped(typedChar, keyCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isPauseScreen() {
        return Minecraft.getInstance().player.getHealth() < 10.0f;
    }

    public void addPopup(Component message, int duration) {
        this.showTimes.put(message, duration);
    }

    public void addPopup(Component message) {
        this.addPopup(message, 200);
    }

    public void addTooltip(AbstractWidget target, DynamicTooltip tooltip) {
        this.tooltips.put(target, tooltip);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isDown() && this.getFocused() == null) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

