/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.client.gui;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import dev.buildtool.satako.Constants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScrollArea
extends AbstractWidget {
    public static final int SCROLLBAR_HEIGHT = 15;
    public static final int SCROLLBAR_WIDTH = 12;
    protected List<AbstractWidget> widgets;
    protected static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/creative_inventory/scroller");
    protected static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/creative_inventory/scroller_disabled");
    protected int totalContentHeight;
    private boolean dragging;
    protected float scrollForScrollBar;
    protected HashMap<AbstractWidget, Integer> widgetYOffsets = new HashMap();
    protected Screen parentScreen;
    protected TreeBasedTable<Integer, Integer, AbstractWidget> widgetTable = TreeBasedTable.create();
    protected List<AbstractWidget> widgetsThatSpanColumns = new ArrayList<AbstractWidget>();
    private float relativeScroll;

    public ScrollArea(int x, int y, int width, int height, Component message, Screen parentScreen) {
        super(x, y, width, height, message);
        this.widgets = new ArrayList<AbstractWidget>();
        this.parentScreen = parentScreen;
        this.scrollForScrollBar = this.getY();
    }

    public void addWidget(AbstractWidget widget, int row, int column) {
        this.widgetTable.put((Object)row, (Object)column, (Object)widget);
        this.widgets.add(widget);
        this.parentScreen.addRenderableWidget((GuiEventListener)widget);
    }

    public void addSpanningWidget(AbstractWidget widget, int row, int column) {
        this.addWidget(widget, row, column);
        this.widgetsThatSpanColumns.add(widget);
    }

    public void alignWidgets() {
        AbstractWidget abstractWidget;
        int elementY = 0;
        for (Integer row : this.widgetTable.rowKeySet()) {
            SortedMap map = this.widgetTable.row((Object)row);
            int highest = 0;
            for (Map.Entry columnEntry : map.entrySet()) {
                abstractWidget = (AbstractWidget)columnEntry.getValue();
                abstractWidget.setY(this.getY() + elementY);
                if (abstractWidget.getHeight() > highest) {
                    highest = abstractWidget.getHeight();
                }
                this.widgetYOffsets.put(abstractWidget, abstractWidget.getY());
                if (abstractWidget.getY() + abstractWidget.getHeight() <= this.getY() + this.height && abstractWidget.getY() >= this.getY()) continue;
                abstractWidget.visible = false;
            }
            elementY += highest;
            this.totalContentHeight += highest;
        }
        HashMap<Integer, Integer> columnToWidest = new HashMap<Integer, Integer>();
        for (Integer column : this.widgetTable.columnKeySet()) {
            Map map = this.widgetTable.column((Object)column);
            for (Map.Entry rowEntry : map.entrySet()) {
                abstractWidget = (AbstractWidget)rowEntry.getValue();
                if (this.widgetsThatSpanColumns.contains(abstractWidget)) continue;
                int widgetWidth = abstractWidget.getWidth();
                if (columnToWidest.containsKey(column)) {
                    int widest = (Integer)columnToWidest.get(column);
                    if (widest >= widgetWidth) continue;
                    columnToWidest.put(column, widgetWidth);
                    continue;
                }
                columnToWidest.put(column, widgetWidth);
            }
        }
        for (Table.Cell cell : this.widgetTable.cellSet()) {
            Integer column = (Integer)cell.getColumnKey();
            AbstractWidget next = (AbstractWidget)cell.getValue();
            if (column > 0) {
                int widest = 0;
                for (int col = 0; col < column; ++col) {
                    widest += ((Integer)columnToWidest.get(col)).intValue();
                }
                next.setX(this.getX() + widest);
                continue;
            }
            next.setX(this.getX());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean withinScrollBar;
        boolean bl = withinScrollBar = mouseX < (double)(this.getX() + this.width + 12) && mouseX > (double)(this.getX() + this.width - 4) && mouseY > (double)this.scrollForScrollBar && mouseY < (double)(this.scrollForScrollBar + 15.0f);
        if (button == 0 && this.totalContentHeight > this.height && withinScrollBar) {
            this.dragging = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            this.scrollForScrollBar = (int)Math.clamp(mouseY - (double)this.getY() / (double)(this.getY() + this.height), (double)this.getY(), (double)(this.getY() + this.height));
            this.relativeScroll = (float)Math.clamp(mouseY - (double)this.getY() / (double)(this.getY() + this.height) - (double)this.getY(), 0.0, (double)this.height);
            float div = (float)this.totalContentHeight / (float)this.widgets.size();
            float relative = this.relativeScroll * (float)(this.totalContentHeight - this.height) / (float)this.height;
            this.widgetTable.rowKeySet().forEach(integer -> {
                SortedMap row = this.widgetTable.row(integer);
                row.forEach((integer1, widget) -> {
                    int offsetY = this.widgetYOffsets.get(widget);
                    widget.setY((int)((float)offsetY - relative));
                    widget.visible = widget.getY() >= this.getY() && (float)(widget.getY() + widget.getHeight()) <= (float)(this.getY() + this.height) + div / 2.0f;
                });
            });
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.scrollForScrollBar = (int)Math.clamp((double)this.scrollForScrollBar - scrollY * 5.0, (double)this.getY(), (double)(this.getY() + this.height));
        this.relativeScroll = (float)Math.clamp((double)this.relativeScroll - scrollY * 5.0, 0.0, (double)this.height);
        float div = (float)this.totalContentHeight / (float)this.widgets.size();
        float relative = this.relativeScroll * (float)(this.totalContentHeight - this.height) / (float)this.height;
        this.widgetTable.rowKeySet().forEach(integer -> {
            SortedMap row = this.widgetTable.row(integer);
            row.forEach((integer1, widget) -> {
                int offsetY = this.widgetYOffsets.get(widget);
                widget.setY((int)((float)offsetY - relative));
                widget.visible = widget.getY() >= this.getY() && (float)(widget.getY() + widget.getHeight()) <= (float)(this.getY() + this.height) + div / 2.0f;
            });
        });
        return true;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, Constants.DARK.getIntColor());
        for (AbstractWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.totalContentHeight > this.height) {
            guiGraphics.blitSprite(SCROLLER_SPRITE, this.width - 2, (int)this.scrollForScrollBar, 12, 3);
        } else {
            guiGraphics.blitSprite(SCROLLER_DISABLED_SPRITE, this.width - 2, (int)this.scrollForScrollBar, 12, 15);
        }
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.width / 2, this.getY() - 10, Constants.WHITE.getIntColor());
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected boolean isValidClickButton(int button) {
        return false;
    }
}

