/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.platform.services;

import dev.buildtool.satako.BetterSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public interface IPlatformHooks {
    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    public void dropItemsIfAny(Level var1, BlockPos var2, BlockState var3);

    default public void drawSlot(Slot slot, int mouseX, int mouseY, GuiGraphics guiGraphics, AbstractContainerScreen<?> screen) {
        if (slot instanceof BetterSlot) {
            BetterSlot betterSlot = (BetterSlot)slot;
            if (slot.getItem().isEmpty() && mouseX > slot.x + screen.leftPos && mouseX < slot.x + screen.leftPos + 18 && mouseY > slot.y + screen.topPos && mouseY < slot.y + screen.topPos + 18 && betterSlot.getTooltip() != null) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, betterSlot.getTooltip(), mouseX, mouseY);
            }
        }
    }

    default public void drawSlotBackground(Slot slot, GuiGraphics guiGraphics, AbstractContainerScreen<?> screen) {
        int sx = slot.x;
        int sy = slot.y;
        if (slot instanceof BetterSlot) {
            BetterSlot betterSlot = (BetterSlot)slot;
            if (betterSlot.getTexture() == null) {
                if (betterSlot.getColor() != null) {
                    guiGraphics.fill(sx + screen.leftPos, sy + screen.topPos, sx + screen.leftPos + 16, sy + screen.topPos + 16, betterSlot.getColor().getIntColor());
                }
            } else {
                guiGraphics.blitSprite(betterSlot.getTexture(), sx + screen.leftPos, sy + screen.topPos, sx + screen.leftPos + 16, sy + screen.topPos + 16);
            }
        } else {
            guiGraphics.fill(sx + screen.leftPos, sy + screen.topPos, sx + screen.leftPos + 16, sy + screen.topPos + 16, -10066330);
        }
    }

    public TextureAtlasSprite getFluidTexture(Fluid var1, boolean var2);

    public boolean isClient();

    public boolean isServer();

    public boolean isFabric();

    public boolean isNeoforge();

    public MenuType<?> getTestMenu();
}

