/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.registry.register;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.service.Services;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public record RegisterItemTab(String owner, BiConsumer<ResourceLocation, CreativeModeTab> registerFunc) {
    public void add(String path, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator display) {
        this.add(path, (CreativeModeTab.Builder builder) -> {
            builder.title(this.title(path));
            builder.icon(icon);
            builder.displayItems(display);
        });
    }

    public void add(String path, Supplier<ItemStack> icon) {
        this.add(path, (CreativeModeTab.Builder builder) -> {
            builder.title(this.title(path));
            builder.icon(icon);
        });
    }

    public void add(String path, Consumer<CreativeModeTab.Builder> builderFunc) {
        CreativeModeTab.Builder builder = Services.GAMEPLAY.tabBuilder();
        builderFunc.accept(builder);
        this.add(path, builder.build());
    }

    public void add(String path, CreativeModeTab tab) {
        this.registerFunc.accept(ResourceLocation.fromNamespaceAndPath((String)this.owner, (String)path), tab);
    }

    public Component title(String path) {
        return Component.translatable((String)("itemGroup." + this.owner + "." + path));
    }
}

