/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackableBookBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<StackableBookBlock> CODEC = StackableBookBlock.simpleCodec(StackableBookBlock::new);
    public static final IntegerProperty BOOKS = IntegerProperty.create((String)"books", (int)1, (int)4);
    public static final IntegerProperty SEED = IntegerProperty.create((String)"seed", (int)1, (int)256);
    public static final VoxelShape SHAPE_1 = Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)4.0, (double)14.0);
    public static final VoxelShape SHAPE_2 = Shapes.join((VoxelShape)Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)4.0, (double)14.0), (VoxelShape)Block.box((double)3.0, (double)4.0, (double)2.0, (double)13.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    public static final VoxelShape SHAPE_3 = Stream.of(Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)4.0, (double)14.0), Block.box((double)3.0, (double)4.0, (double)2.0, (double)13.0, (double)8.0, (double)14.0), Block.box((double)3.0, (double)8.0, (double)2.0, (double)13.0, (double)12.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_4 = Stream.of(Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)4.0, (double)14.0), Block.box((double)3.0, (double)4.0, (double)2.0, (double)13.0, (double)8.0, (double)14.0), Block.box((double)3.0, (double)8.0, (double)2.0, (double)13.0, (double)12.0, (double)14.0), Block.box((double)3.0, (double)12.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public StackableBookBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BOOKS, (Comparable)Integer.valueOf(1))).setValue((Property)SEED, (Comparable)Integer.valueOf(1)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BOOKS, SEED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)BOOKS)) {
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            case 4 -> SHAPE_4;
            default -> SHAPE_1;
        };
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)BOOKS) < 4 || super.canBeReplaced(state, useContext);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.is((Block)this)) {
            return (BlockState)state.setValue((Property)BOOKS, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.getValue((Property)BOOKS) + 1)));
        }
        BlockState placementState = super.getStateForPlacement(context);
        if (placementState == null) {
            return null;
        }
        Random seededRandom = new Random(context.getClickedPos().asLong());
        return (BlockState)((BlockState)placementState.setValue((Property)FACING, (Comparable)Direction.from2DDataValue((int)seededRandom.nextInt(4)))).setValue((Property)SEED, (Comparable)Integer.valueOf(seededRandom.nextInt(256) + 1));
    }

    public static String bookName(BlockState state) {
        return switch ((Integer)state.getValue((Property)BOOKS)) {
            case 2 -> "double";
            case 3 -> "triple";
            case 4 -> "quadruple";
            default -> "single";
        };
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

