/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import samebutdifferent.ecologics.registry.ModBlocks;

public class FloweringAzaleaLogBlock
extends RotatedPillarBlock {
    public FloweringAzaleaLogBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG));
    }

    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (itemstack.is(Items.SHEARS)) {
            if (!world.isClientSide) {
                Direction direction = hitResult.getDirection().getAxis() == Direction.Axis.Y ? player.getDirection().getOpposite() : hitResult.getDirection();
                FloweringAzaleaLogBlock.shearAzalea(world, player, pos, itemstack, hand, direction, (BlockState)(Objects.equals(this.getName(), ModBlocks.FLOWERING_AZALEA_LOG.getName()) ? ModBlocks.AZALEA_LOG : ModBlocks.AZALEA_WOOD).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS))));
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(itemstack, state, world, pos, player, hand, hitResult);
    }

    public static void shearAzalea(Level world, Player player, BlockPos pos, ItemStack stack, InteractionHand hand, Direction direction, BlockState replacementState) {
        world.playSound(null, pos, SoundEvents.FLOWERING_AZALEA_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.setBlock(pos, replacementState, 11);
        ItemEntity itementity = new ItemEntity(world, (double)pos.getX() + 0.5 + (double)direction.getStepX() * 0.65, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5 + (double)direction.getStepZ() * 0.65, new ItemStack((ItemLike)ModBlocks.AZALEA_FLOWER.asItem()));
        itementity.setDeltaMovement(0.05 * (double)direction.getStepX() + world.random.nextDouble() * 0.02, 0.05, 0.05 * (double)direction.getStepZ() + world.random.nextDouble() * 0.02);
        world.addFreshEntity((Entity)itementity);
        stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)hand));
        world.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
        player.awardStat(Stats.ITEM_USED.get((Object)Items.SHEARS));
    }
}

