/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeashellBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)3.0, (double)14.0), (VoxelShape)Block.box((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)3.0, (double)4.0));
    protected static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)3.0, (double)12.0, (double)3.0, (double)13.0), (VoxelShape)Block.box((double)12.0, (double)0.0, (double)5.0, (double)14.0, (double)3.0, (double)11.0));
    protected static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)3.0, (double)12.0), (VoxelShape)Block.box((double)5.0, (double)0.0, (double)12.0, (double)11.0, (double)3.0, (double)14.0));
    protected static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0, (double)13.0), (VoxelShape)Block.box((double)2.0, (double)0.0, (double)5.0, (double)4.0, (double)3.0, (double)11.0));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public SeashellBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).noOcclusion().strength(0.5f).sound(SoundType.BONE_BLOCK));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return pFacing == Direction.DOWN && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.below()).isFaceSturdy((BlockGetter)pLevel, pPos, Direction.UP);
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }
}

