/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.ModelUtils;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import samebutdifferent.ecologics.entity.Penguin;

@OnlyIn(value=Dist.CLIENT)
public class PenguinModel
extends AgeableListModel<Penguin> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"penguin"), "main");
    private final ModelPart body;
    public final ModelPart head;
    private final ModelPart leftFlipper;
    private final ModelPart rightFlipper;
    private final ModelPart egg;
    private final ModelPart leftFoot;
    private final ModelPart rightFoot;
    private float slidingAnimationProgress;
    private float swimmingAnimationProgress;

    public PenguinModel(ModelPart root) {
        super(true, 4.75f, 0.0f, 1.5f, 2.0f, 24.0f);
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.leftFlipper = this.body.getChild("leftFlipper");
        this.rightFlipper = this.body.getChild("rightFlipper");
        this.egg = this.body.getChild("egg");
        this.leftFoot = this.body.getChild("leftFoot");
        this.rightFoot = this.body.getChild("rightFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -5.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-1.0f, -2.0f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -2.0f, -3.0f, 8.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition leftFlipper = body.addOrReplaceChild("leftFlipper", CubeListBuilder.create().texOffs(18, 21).addBox(0.0f, -1.0f, -3.0f, 1.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-1.0f, (float)0.0f));
        PartDefinition rightFlipper = body.addOrReplaceChild("rightFlipper", CubeListBuilder.create().texOffs(18, 21).mirror().addBox(-1.0f, -1.0f, -3.0f, 1.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)-1.0f, (float)0.0f));
        PartDefinition egg = body.addOrReplaceChild("egg", CubeListBuilder.create().texOffs(31, 0).addBox(-1.5f, -4.0f, -6.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition leftFoot = body.addOrReplaceChild("leftFoot", CubeListBuilder.create().texOffs(16, 16).addBox(-1.0f, 0.0f, -2.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)7.0f, (float)-3.0f));
        PartDefinition rightFoot = body.addOrReplaceChild("rightFoot", CubeListBuilder.create().texOffs(16, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)7.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(Penguin entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTick);
        this.slidingAnimationProgress = entity.getSlidingAnimationProgress(partialTick);
        this.swimmingAnimationProgress = entity.getSwimmingAnimationProgress(partialTick);
    }

    public void setupAnim(Penguin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.getAllParts().forEach(ModelPart::resetPose);
        this.egg.visible = entity.isPregnant();
        this.head.resetPose();
        float swingSlowdownFactor = 0.3f;
        if (this.swimmingAnimationProgress > 0.0f) {
            this.body.xRot += ModelUtils.rotlerpRad((float)this.body.xRot, (float)((float)Math.toRadians(90.0)), (float)this.swimmingAnimationProgress) - Mth.cos((float)(0.7f * ageInTicks)) * (swingSlowdownFactor * 0.25f);
            this.body.y = Mth.lerp((float)this.swimmingAnimationProgress, (float)this.body.getInitialPose().y, (float)(this.body.getInitialPose().y + 7.0f));
            this.body.y += -Mth.cos((float)(0.7f * ageInTicks)) * (swingSlowdownFactor * 0.025f);
            this.head.xRot = Mth.lerp((float)this.swimmingAnimationProgress, (float)(headPitch * ((float)Math.PI / 180)), (float)0.0f);
            this.head.yRot = Mth.lerp((float)this.swimmingAnimationProgress, (float)(netHeadYaw * ((float)Math.PI / 180)), (float)0.0f);
            this.head.y = Mth.lerp((float)this.swimmingAnimationProgress, (float)this.head.getInitialPose().y, (float)(entity.isBaby() ? 21.0f : 24.0f));
            this.head.z = Mth.lerp((float)this.swimmingAnimationProgress, (float)this.head.getInitialPose().z, (float)-2.0f);
            this.head.xRot += Mth.cos((float)(0.7f * ((float)Math.toRadians(-40.0) + ageInTicks))) * (swingSlowdownFactor * 0.3f);
            this.leftFoot.xRot = (float)((double)this.leftFoot.xRot + (Math.toRadians(17.5) - (double)Mth.cos((float)((float)Math.toRadians(-40.0) + ageInTicks))) * (double)swingSlowdownFactor);
            this.rightFoot.xRot = (float)((double)this.rightFoot.xRot + (Math.toRadians(17.5) - (double)Mth.sin((float)((float)Math.toRadians(-40.0) + ageInTicks))) * (double)swingSlowdownFactor);
            this.leftFlipper.xRot += Mth.cos((float)((float)Math.toRadians(-80.0) + ageInTicks)) * (swingSlowdownFactor * 0.2f);
            this.leftFlipper.zRot = (float)((double)this.leftFlipper.zRot + (Math.toRadians(-5.0) - (double)Mth.cos((float)((float)Math.toRadians(-80.0) + ageInTicks))) * (double)(swingSlowdownFactor * 0.25f));
            this.rightFlipper.xRot += Mth.cos((float)((float)Math.toRadians(-80.0) + ageInTicks)) * (swingSlowdownFactor * 0.2f);
            this.rightFlipper.zRot = (float)((double)this.rightFlipper.zRot + (Math.toRadians(5.0) - (double)Mth.cos((float)((float)Math.toRadians(-80.0) + ageInTicks))) * (double)(swingSlowdownFactor * 0.25f));
        } else if (this.slidingAnimationProgress > 0.0f) {
            this.body.xRot += ModelUtils.rotlerpRad((float)this.body.xRot, (float)((float)Math.toRadians(90.0)), (float)this.slidingAnimationProgress);
            this.body.y = Mth.lerp((float)this.slidingAnimationProgress, (float)this.body.getInitialPose().y, (float)(this.body.getInitialPose().y + 7.0f));
            this.body.z += -Mth.cos((float)(2.0f * limbSwing)) * swingSlowdownFactor * limbSwingAmount;
            this.head.xRot = Mth.lerp((float)this.slidingAnimationProgress, (float)(headPitch * ((float)Math.PI / 180)), (float)0.0f);
            this.head.yRot = Mth.lerp((float)this.slidingAnimationProgress, (float)(netHeadYaw * ((float)Math.PI / 180)), (float)0.0f);
            this.head.y = Mth.lerp((float)this.slidingAnimationProgress, (float)this.head.getInitialPose().y, (float)(entity.isBaby() ? 20.0f : 24.0f));
            this.head.z = Mth.lerp((float)this.slidingAnimationProgress, (float)this.head.getInitialPose().z, (float)-4.0f);
            this.head.y += -Mth.cos((float)(2.0f * ((float)Math.toRadians(-80.0) + limbSwing))) * swingSlowdownFactor * limbSwingAmount;
            this.head.z += -Mth.cos((float)(2.0f * limbSwing)) * swingSlowdownFactor * limbSwingAmount;
            this.leftFoot.xRot += ModelUtils.rotlerpRad((float)this.leftFoot.xRot, (float)((float)Math.toRadians(90.0)), (float)this.slidingAnimationProgress);
            this.rightFoot.xRot += ModelUtils.rotlerpRad((float)this.rightFoot.xRot, (float)((float)Math.toRadians(90.0)), (float)this.slidingAnimationProgress);
            this.leftFlipper.zRot = (float)((double)this.leftFlipper.zRot + (Math.toRadians(-2.5) - (double)Mth.cos((float)(2.0f * limbSwing))) * (double)(swingSlowdownFactor * 0.5f) * (double)limbSwingAmount);
            this.rightFlipper.zRot = (float)((double)this.rightFlipper.zRot + (Math.toRadians(2.5) - (double)Mth.cos((float)(2.0f * limbSwing))) * (double)(swingSlowdownFactor * 0.5f) * (double)limbSwingAmount);
        } else {
            this.body.yRot += Mth.cos((float)((float)Math.toRadians(-20.0) + limbSwing)) * swingSlowdownFactor * limbSwingAmount;
            this.body.zRot += Mth.cos((float)limbSwing) * (swingSlowdownFactor * 0.5f) * limbSwingAmount;
            this.head.xRot = headPitch * ((float)Math.PI / 180);
            this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
            this.head.yRot += -Mth.cos((float)((float)Math.toRadians(-80.0) + limbSwing)) * (swingSlowdownFactor * 0.5f) * limbSwingAmount;
            this.head.zRot += -Mth.cos((float)((float)Math.toRadians(-40.0) + limbSwing)) * (swingSlowdownFactor * 0.5f) * limbSwingAmount;
            this.head.x += Mth.cos((float)limbSwing) * (swingSlowdownFactor * 0.1f) * limbSwingAmount;
            this.leftFoot.xRot = (float)((double)this.leftFoot.xRot + (Math.toRadians(-10.0) + (double)Mth.cos((float)limbSwing)) * (double)(swingSlowdownFactor * 2.0f) * (double)limbSwingAmount);
            this.rightFoot.xRot = (float)((double)this.rightFoot.xRot + (Math.toRadians(-10.0) - (double)Mth.cos((float)limbSwing)) * (double)(swingSlowdownFactor * 2.0f) * (double)limbSwingAmount);
            this.leftFlipper.zRot = (float)((double)this.leftFlipper.zRot + (Math.toRadians(-10.0) + (double)Mth.cos((float)((float)Math.toRadians(-40.0) + limbSwing))) * (double)(swingSlowdownFactor * 0.8f) * (double)limbSwingAmount);
            this.rightFlipper.zRot = (float)((double)this.rightFlipper.zRot + (Math.toRadians(10.0) + (double)Mth.cos((float)((float)Math.toRadians(-40.0) + limbSwing))) * (double)(swingSlowdownFactor * 0.8f) * (double)limbSwingAmount);
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

