/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import samebutdifferent.ecologics.block.SandcastleBlock;
import samebutdifferent.ecologics.registry.ModBlocks;

public class SandcastleBlockItem
extends BlockItem {
    public SandcastleBlockItem() {
        super(ModBlocks.SANDCASTLE, new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos pos;
        Level level = pContext.getLevel();
        BlockState state = level.getBlockState(pos = pContext.getClickedPos());
        if (!state.is(Blocks.TURTLE_EGG)) {
            return super.useOn(pContext);
        }
        level.playSound(pContext.getPlayer(), pos, SoundEvents.SAND_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)ModBlocks.SANDCASTLE.defaultBlockState().setValue((Property)SandcastleBlock.FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)SandcastleBlock.EGGS_INSIDE, (Comparable)((Integer)state.getValue((Property)TurtleEggBlock.EGGS)))).setValue((Property)SandcastleBlock.HATCH, (Comparable)((Integer)state.getValue((Property)TurtleEggBlock.HATCH))));
        pContext.getItemInHand().shrink(1);
        Player player = pContext.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CriteriaTriggers.PLACED_BLOCK.trigger(player2, pos, pContext.getItemInHand());
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

