/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.registry;

import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import oshi.util.tuples.Triplet;
import samebutdifferent.ecologics.block.AzaleaFlowerBlock;
import samebutdifferent.ecologics.block.AzaleaLogBlock;
import samebutdifferent.ecologics.block.CoconutBlock;
import samebutdifferent.ecologics.block.CoconutLeavesBlock;
import samebutdifferent.ecologics.block.CoconutSaplingBlock;
import samebutdifferent.ecologics.block.FloweringAzaleaLogBlock;
import samebutdifferent.ecologics.block.HangingCoconutBlock;
import samebutdifferent.ecologics.block.ModCeilingHangingSignBlock;
import samebutdifferent.ecologics.block.ModStandingSignBlock;
import samebutdifferent.ecologics.block.ModWallHangingSignBlock;
import samebutdifferent.ecologics.block.ModWallSignBlock;
import samebutdifferent.ecologics.block.MossLayerBlock;
import samebutdifferent.ecologics.block.PotBlock;
import samebutdifferent.ecologics.block.PricklyPearBlock;
import samebutdifferent.ecologics.block.SandcastleBlock;
import samebutdifferent.ecologics.block.SeashellBlock;
import samebutdifferent.ecologics.block.SurfaceMossBlock;
import samebutdifferent.ecologics.block.ThinIceBlock;
import samebutdifferent.ecologics.block.grower.ModTreeGrower;
import samebutdifferent.ecologics.block.properties.ModWoodType;

public class ModBlocks {
    public static final ArrayList<Triplet<ResourceLocation, Block, Boolean>> BLOCKS = new ArrayList();
    public static final Block AZALEA_LOG = ModBlocks.registerBlock("azalea_log", (Block)new AzaleaLogBlock());
    public static final Block FLOWERING_AZALEA_LOG = ModBlocks.registerBlock("flowering_azalea_log", (Block)new FloweringAzaleaLogBlock());
    public static final Block STRIPPED_AZALEA_LOG = ModBlocks.registerBlock("stripped_azalea_log", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final Block AZALEA_WOOD = ModBlocks.registerBlock("azalea_wood", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final Block FLOWERING_AZALEA_WOOD = ModBlocks.registerBlock("flowering_azalea_wood", (Block)new FloweringAzaleaLogBlock());
    public static final Block STRIPPED_AZALEA_WOOD = ModBlocks.registerBlock("stripped_azalea_wood", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    public static final Block AZALEA_PLANKS = ModBlocks.registerBlock("azalea_planks", new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block FLOWERING_AZALEA_PLANKS = ModBlocks.registerBlock("flowering_azalea_planks", new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block AZALEA_SLAB = ModBlocks.registerBlock("azalea_slab", (Block)new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block FLOWERING_AZALEA_SLAB = ModBlocks.registerBlock("flowering_azalea_slab", (Block)new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block AZALEA_STAIRS = ModBlocks.registerBlock("azalea_stairs", (Block)new StairBlock(Blocks.OAK_PLANKS.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block FLOWERING_AZALEA_STAIRS = ModBlocks.registerBlock("flowering_azalea_stairs", (Block)new StairBlock(Blocks.OAK_PLANKS.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block AZALEA_FENCE = ModBlocks.registerBlock("azalea_fence", (Block)new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block FLOWERING_AZALEA_FENCE = ModBlocks.registerBlock("flowering_azalea_fence", (Block)new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block AZALEA_FENCE_GATE = ModBlocks.registerBlock("azalea_fence_gate", (Block)new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block FLOWERING_AZALEA_FENCE_GATE = ModBlocks.registerBlock("flowering_azalea_fence_gate", (Block)new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block AZALEA_DOOR = ModBlocks.registerBlock("azalea_door", (Block)new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)){});
    public static final Block FLOWERING_AZALEA_DOOR = ModBlocks.registerBlock("flowering_azalea_door", (Block)new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)){});
    public static final Block AZALEA_TRAPDOOR = ModBlocks.registerBlock("azalea_trapdoor", (Block)new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)){});
    public static final Block FLOWERING_AZALEA_TRAPDOOR = ModBlocks.registerBlock("flowering_azalea_trapdoor", (Block)new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)){});
    public static final Block AZALEA_BUTTON = ModBlocks.registerBlock("azalea_button", (Block)new ButtonBlock(BlockSetType.OAK, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)){});
    public static final Block AZALEA_PRESSURE_PLATE = ModBlocks.registerBlock("azalea_pressure_plate", (Block)new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE)){});
    public static final Block AZALEA_FLOWER = ModBlocks.registerBlock("azalea_flower", (Block)new AzaleaFlowerBlock(BlockBehaviour.Properties.of().instabreak().noCollission().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ)));
    public static final Block POTTED_AZALEA_FLOWER = ModBlocks.registerBlock("potted_azalea_flower", (Block)new FlowerPotBlock(AZALEA_FLOWER, BlockBehaviour.Properties.of().instabreak().noOcclusion()), false);
    public static final Block AZALEA_SIGN = ModBlocks.registerBlock("azalea_sign", (Block)new ModStandingSignBlock(ModWoodType.AZALEA, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD)), false);
    public static final Block AZALEA_WALL_SIGN = ModBlocks.registerBlock("azalea_wall_sign", (Block)new ModWallSignBlock(ModWoodType.AZALEA, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD).dropsLike(AZALEA_SIGN)), false);
    public static final Block AZALEA_HANGING_SIGN = ModBlocks.registerBlock("azalea_hanging_sign", (Block)new ModCeilingHangingSignBlock(ModWoodType.AZALEA, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD)), false);
    public static final Block AZALEA_WALL_HANGING_SIGN = ModBlocks.registerBlock("azalea_wall_hanging_sign", (Block)new ModWallHangingSignBlock(ModWoodType.AZALEA, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD).dropsLike(AZALEA_HANGING_SIGN)), false);
    public static final Block FLOWERING_AZALEA_SIGN = ModBlocks.registerBlock("flowering_azalea_sign", (Block)new ModStandingSignBlock(ModWoodType.FLOWERING_AZALEA, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD)), false);
    public static final Block FLOWERING_AZALEA_WALL_SIGN = ModBlocks.registerBlock("flowering_azalea_wall_sign", (Block)new ModWallSignBlock(ModWoodType.FLOWERING_AZALEA, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD).dropsLike(FLOWERING_AZALEA_SIGN)), false);
    public static final Block FLOWERING_AZALEA_HANGING_SIGN = ModBlocks.registerBlock("flowering_azalea_hanging_sign", (Block)new ModCeilingHangingSignBlock(ModWoodType.FLOWERING_AZALEA, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD)), false);
    public static final Block FLOWERING_AZALEA_WALL_HANGING_SIGN = ModBlocks.registerBlock("flowering_azalea_wall_hanging_sign", (Block)new ModWallHangingSignBlock(ModWoodType.FLOWERING_AZALEA, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD).dropsLike(FLOWERING_AZALEA_HANGING_SIGN)), false);
    public static final Block COCONUT_LOG = ModBlocks.registerBlock("coconut_log", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final Block STRIPPED_COCONUT_LOG = ModBlocks.registerBlock("stripped_coconut_log", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final Block COCONUT_WOOD = ModBlocks.registerBlock("coconut_wood", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final Block STRIPPED_COCONUT_WOOD = ModBlocks.registerBlock("stripped_coconut_wood", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    public static final Block COCONUT_LEAVES = ModBlocks.registerBlock("coconut_leaves", (Block)new CoconutLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
    public static final Block COCONUT_PLANKS = ModBlocks.registerBlock("coconut_planks", new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block COCONUT_SLAB = ModBlocks.registerBlock("coconut_slab", (Block)new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block COCONUT_STAIRS = ModBlocks.registerBlock("coconut_stairs", (Block)new StairBlock(Blocks.OAK_PLANKS.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block COCONUT_FENCE = ModBlocks.registerBlock("coconut_fence", (Block)new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block COCONUT_FENCE_GATE = ModBlocks.registerBlock("coconut_fence_gate", (Block)new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block COCONUT_DOOR = ModBlocks.registerBlock("coconut_door", (Block)new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)){});
    public static final Block COCONUT_TRAPDOOR = ModBlocks.registerBlock("coconut_trapdoor", (Block)new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)){});
    public static final Block COCONUT_BUTTON = ModBlocks.registerBlock("coconut_button", (Block)new ButtonBlock(BlockSetType.OAK, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)){});
    public static final Block COCONUT_PRESSURE_PLATE = ModBlocks.registerBlock("coconut_pressure_plate", (Block)new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE)){});
    public static final Block COCONUT_SIGN = ModBlocks.registerBlock("coconut_sign", (Block)new ModStandingSignBlock(ModWoodType.COCONUT, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD)), false);
    public static final Block COCONUT_WALL_SIGN = ModBlocks.registerBlock("coconut_wall_sign", (Block)new ModWallSignBlock(ModWoodType.COCONUT, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD).dropsLike(COCONUT_SIGN)), false);
    public static final Block COCONUT_HANGING_SIGN = ModBlocks.registerBlock("coconut_hanging_sign", (Block)new ModCeilingHangingSignBlock(ModWoodType.COCONUT, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD)), false);
    public static final Block COCONUT_WALL_HANGING_SIGN = ModBlocks.registerBlock("coconut_wall_hanging_sign", (Block)new ModWallHangingSignBlock(ModWoodType.COCONUT, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD).dropsLike(COCONUT_HANGING_SIGN)), false);
    public static final Block COCONUT_SEEDLING = ModBlocks.registerBlock("coconut_seedling", (Block)new CoconutSaplingBlock(ModTreeGrower.COCONUT, BlockBehaviour.Properties.of().noCollission().randomTicks().instabreak().sound(SoundType.GRASS)));
    public static final Block POTTED_COCONUT_SEEDLING = ModBlocks.registerBlock("potted_coconut_seedling", (Block)new FlowerPotBlock(COCONUT_SEEDLING, BlockBehaviour.Properties.of().instabreak().noOcclusion()), false);
    public static final Block WALNUT_LOG = ModBlocks.registerBlock("walnut_log", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final Block STRIPPED_WALNUT_LOG = ModBlocks.registerBlock("stripped_walnut_log", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final Block WALNUT_WOOD = ModBlocks.registerBlock("walnut_wood", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final Block STRIPPED_WALNUT_WOOD = ModBlocks.registerBlock("stripped_walnut_wood", (Block)new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    public static final Block WALNUT_LEAVES = ModBlocks.registerBlock("walnut_leaves", (Block)new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
    public static final Block WALNUT_PLANKS = ModBlocks.registerBlock("walnut_planks", new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block WALNUT_SLAB = ModBlocks.registerBlock("walnut_slab", (Block)new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block WALNUT_STAIRS = ModBlocks.registerBlock("walnut_stairs", (Block)new StairBlock(Blocks.OAK_PLANKS.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block WALNUT_FENCE = ModBlocks.registerBlock("walnut_fence", (Block)new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Block WALNUT_FENCE_GATE = ModBlocks.registerBlock("walnut_fence_gate", (Block)new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){});
    public static final Block WALNUT_DOOR = ModBlocks.registerBlock("walnut_door", (Block)new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)){});
    public static final Block WALNUT_TRAPDOOR = ModBlocks.registerBlock("walnut_trapdoor", (Block)new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)){});
    public static final Block WALNUT_BUTTON = ModBlocks.registerBlock("walnut_button", (Block)new ButtonBlock(BlockSetType.OAK, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)){});
    public static final Block WALNUT_PRESSURE_PLATE = ModBlocks.registerBlock("walnut_pressure_plate", (Block)new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE)){});
    public static final Block WALNUT_SIGN = ModBlocks.registerBlock("walnut_sign", (Block)new ModStandingSignBlock(ModWoodType.WALNUT, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD)), false);
    public static final Block WALNUT_WALL_SIGN = ModBlocks.registerBlock("walnut_wall_sign", (Block)new ModWallSignBlock(ModWoodType.WALNUT, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD).dropsLike(WALNUT_SIGN)), false);
    public static final Block WALNUT_HANGING_SIGN = ModBlocks.registerBlock("walnut_hanging_sign", (Block)new ModCeilingHangingSignBlock(ModWoodType.WALNUT, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD)), false);
    public static final Block WALNUT_WALL_HANGING_SIGN = ModBlocks.registerBlock("walnut_wall_hanging_sign", (Block)new ModWallHangingSignBlock(ModWoodType.WALNUT, BlockBehaviour.Properties.of().noCollission().strength(1.0f).sound(SoundType.WOOD).dropsLike(WALNUT_HANGING_SIGN)), false);
    public static final Block WALNUT_SAPLING = ModBlocks.registerBlock("walnut_sapling", (Block)new SaplingBlock(ModTreeGrower.WALNUT, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)){});
    public static final Block POTTED_WALNUT_SAPLING = ModBlocks.registerBlock("potted_walnut_sapling", (Block)new FlowerPotBlock(WALNUT_SAPLING, BlockBehaviour.Properties.of().instabreak().noOcclusion()), false);
    public static final Block SEASHELL = ModBlocks.registerBlock("seashell", (Block)new SeashellBlock());
    public static final Block SEASHELL_BLOCK = ModBlocks.registerBlock("seashell_block", new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(1.5f, 6.0f).sound(SoundType.DEEPSLATE_TILES).requiresCorrectToolForDrops()));
    public static final Block SEASHELL_TILES = ModBlocks.registerBlock("seashell_tiles", new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)SEASHELL_BLOCK)));
    public static final Block SEASHELL_TILE_STAIRS = ModBlocks.registerBlock("seashell_tile_stairs", (Block)new StairBlock(SEASHELL_BLOCK.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)SEASHELL_BLOCK)));
    public static final Block SEASHELL_TILE_SLAB = ModBlocks.registerBlock("seashell_tile_slab", (Block)new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)SEASHELL_BLOCK)));
    public static final Block SEASHELL_TILE_WALL = ModBlocks.registerBlock("seashell_tile_wall", (Block)new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)SEASHELL_BLOCK)));
    public static final Block ICE_BRICKS = ModBlocks.registerBlock("ice_bricks", new Block(BlockBehaviour.Properties.of().friction(0.98f).strength(0.5f).sound(SoundType.GLASS)));
    public static final Block ICE_BRICK_STAIRS = ModBlocks.registerBlock("ice_brick_stairs", (Block)new StairBlock(ICE_BRICKS.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ICE_BRICKS)));
    public static final Block ICE_BRICK_SLAB = ModBlocks.registerBlock("ice_brick_slab", (Block)new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ICE_BRICKS)));
    public static final Block ICE_BRICK_WALL = ModBlocks.registerBlock("ice_brick_wall", (Block)new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ICE_BRICKS)));
    public static final Block SNOW_BRICKS = ModBlocks.registerBlock("snow_bricks", new Block(BlockBehaviour.Properties.of().strength(0.5f).sound(SoundType.SNOW)));
    public static final Block SNOW_BRICK_STAIRS = ModBlocks.registerBlock("snow_brick_stairs", (Block)new StairBlock(SNOW_BRICKS.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)SNOW_BRICKS)));
    public static final Block SNOW_BRICK_SLAB = ModBlocks.registerBlock("snow_brick_slab", (Block)new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)SNOW_BRICKS)));
    public static final Block SNOW_BRICK_WALL = ModBlocks.registerBlock("snow_brick_wall", (Block)new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)SNOW_BRICKS)));
    public static final Block SURFACE_MOSS = ModBlocks.registerBlock("surface_moss", (Block)new SurfaceMossBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).noCollission().strength(0.2f).pushReaction(PushReaction.DESTROY).sound(SoundType.MOSS_CARPET).noOcclusion()));
    public static final Block MOSS_LAYER = ModBlocks.registerBlock("moss_layer", (Block)new MossLayerBlock());
    public static final Block HANGING_COCONUT = ModBlocks.registerBlock("hanging_coconut", (Block)new HangingCoconutBlock(BlockBehaviour.Properties.of().randomTicks().strength(2.0f, 3.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.WOOD).noOcclusion()), false);
    public static final Block COCONUT = ModBlocks.registerBlock("coconut", new CoconutBlock());
    public static final Block SANDCASTLE = ModBlocks.registerBlock("sandcastle", (Block)new SandcastleBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(0.7f).sound(SoundType.SAND).pushReaction(PushReaction.DESTROY).noOcclusion().randomTicks()), false);
    public static final Block PRICKLY_PEAR = ModBlocks.registerBlock("prickly_pear", (Block)new PricklyPearBlock(), false);
    public static final Block POT = ModBlocks.registerBlock("pot", (Block)new PotBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).requiresCorrectToolForDrops().strength(1.0f)));
    public static final Block THIN_ICE = ModBlocks.registerBlock("thin_ice", (Block)new ThinIceBlock());

    public static void init() {
        for (Triplet<ResourceLocation, Block, Boolean> registry : BLOCKS) {
            Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)((ResourceLocation)registry.getA()), (Object)((Block)registry.getB()));
        }
    }

    public static Block registerBlock(String name, Block block) {
        return ModBlocks.registerBlock(name, block, true);
    }

    public static Block registerBlock(String name, Block block, boolean addItem) {
        BLOCKS.add((Triplet<ResourceLocation, Block, Boolean>)new Triplet((Object)ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)name), (Object)block, (Object)addItem));
        return block;
    }
}

