/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.client.animation.Animator;
import fuzs.mutantmonsters.client.model.MutantCrossbowModel;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MutantSkeletonModel
extends EntityModel<MutantSkeleton> {
    private final Animator animator = new Animator();
    private final List<ModelPart> parts;
    private final ModelPart skeleBase;
    private final ModelPart pelvis;
    private final ModelPart waist;
    private final Spine[] spine = new Spine[3];
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart innerhead;
    private final ModelPart jaw;
    private final ModelPart shoulder1;
    private final ModelPart shoulder2;
    private final ModelPart arm1;
    private final ModelPart innerarm1;
    private final ModelPart arm2;
    private final ModelPart innerarm2;
    private final ModelPart forearm1;
    private final ModelPart innerforearm1;
    private final ModelPart forearm2;
    private final ModelPart innerforearm2;
    private final ModelPart leg1;
    private final ModelPart innerleg1;
    private final ModelPart leg2;
    private final ModelPart innerleg2;
    private final ModelPart foreleg1;
    private final ModelPart innerforeleg1;
    private final ModelPart foreleg2;
    private final ModelPart innerforeleg2;
    private final MutantCrossbowModel crossbow;
    private float partialTick;

    public MutantSkeletonModel(ModelPart modelPart, ModelPart crossbowModelPart) {
        this.parts = (List)Stream.of(modelPart, crossbowModelPart).flatMap(ModelPart::getAllParts).collect(ImmutableList.toImmutableList());
        this.skeleBase = modelPart.getChild("base");
        this.pelvis = this.skeleBase.getChild("pelvis");
        modelPart = this.waist = this.pelvis.getChild("waist");
        for (int i = 0; i < 3; ++i) {
            this.spine[i] = new Spine(modelPart, "" + (i + 1));
            modelPart = this.spine[i].middle;
        }
        this.neck = modelPart.getChild("neck");
        this.head = this.neck.getChild("head");
        this.innerhead = this.head.getChild("inner_head");
        this.jaw = this.innerhead.getChild("jaw");
        this.shoulder1 = modelPart.getChild("shoulder1");
        this.shoulder2 = modelPart.getChild("shoulder2");
        this.arm1 = this.shoulder1.getChild("arm1");
        this.innerarm1 = this.arm1.getChild("inner_arm1");
        this.arm2 = this.shoulder2.getChild("arm2");
        this.innerarm2 = this.arm2.getChild("inner_arm2");
        this.forearm1 = this.innerarm1.getChild("fore_arm1");
        this.innerforearm1 = this.forearm1.getChild("inner_fore_arm1");
        this.forearm2 = this.innerarm2.getChild("fore_arm2");
        this.innerforearm2 = this.forearm2.getChild("inner_fore_arm2");
        this.leg1 = this.pelvis.getChild("leg1");
        this.innerleg1 = this.leg1.getChild("inner_leg1");
        this.leg2 = this.pelvis.getChild("leg2");
        this.innerleg2 = this.leg2.getChild("inner_leg2");
        this.foreleg1 = this.innerleg1.getChild("fore_leg1");
        this.innerforeleg1 = this.foreleg1.getChild("inner_fore_leg1");
        this.foreleg2 = this.innerleg2.getChild("fore_leg2");
        this.innerforeleg2 = this.foreleg2.getChild("inner_fore_leg2");
        this.crossbow = new MutantCrossbowModel(crossbowModelPart);
    }

    public static LayerDefinition createBodyLayer() {
        PartDefinition waist;
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition base = root.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition pelvis = base.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f), PartPose.ZERO);
        PartDefinition middle = waist = pelvis.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(32, 0).addBox(-2.5f, -8.0f, -2.0f, 5.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        for (int i = 0; i < 3; ++i) {
            Spine.createSpineLayer(middle, i);
            middle = middle.getChild("middle" + (i + 1));
        }
        PartDefinition neck = middle.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(64, 0).addBox(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition innerHead = head.addOrReplaceChild("inner_head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.4f)), PartPose.ZERO);
        innerHead.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(72, 0).addBox(-4.0f, -3.0f, -8.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.7f)), PartPose.offset((float)0.0f, (float)-0.2f, (float)3.5f));
        PartDefinition shoulder1 = middle.addOrReplaceChild("shoulder1", CubeListBuilder.create().texOffs(28, 16).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 6.0f), PartPose.offset((float)-7.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition shoulder2 = middle.addOrReplaceChild("shoulder2", CubeListBuilder.create().texOffs(28, 16).mirror().addBox(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 6.0f), PartPose.offset((float)7.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition arm1 = shoulder1.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(0, 28), PartPose.offset((float)-1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition innerArm1 = arm1.addOrReplaceChild("inner_arm1", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        PartDefinition arm2 = shoulder2.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(0, 28).mirror(), PartPose.offset((float)1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition innerArm2 = arm2.addOrReplaceChild("inner_arm2", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        PartDefinition foreArm1 = innerArm1.addOrReplaceChild("fore_arm1", CubeListBuilder.create().texOffs(16, 28), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        foreArm1.addOrReplaceChild("inner_fore_arm1", CubeListBuilder.create().texOffs(16, 28).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.ZERO);
        PartDefinition foreArm2 = innerArm2.addOrReplaceChild("fore_arm2", CubeListBuilder.create().texOffs(16, 28).mirror(), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        foreArm2.addOrReplaceChild("inner_fore_arm2", CubeListBuilder.create().texOffs(16, 28).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.ZERO);
        PartDefinition leg1 = pelvis.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 28), PartPose.offset((float)-2.5f, (float)-2.5f, (float)0.0f));
        PartDefinition innerLeg1 = leg1.addOrReplaceChild("inner_leg1", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        PartDefinition leg2 = pelvis.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 28).mirror(), PartPose.offset((float)2.5f, (float)-2.5f, (float)0.0f));
        PartDefinition innerLeg2 = leg2.addOrReplaceChild("inner_leg2", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        PartDefinition foreLeg1 = innerLeg1.addOrReplaceChild("fore_leg1", CubeListBuilder.create().texOffs(32, 28), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        foreLeg1.addOrReplaceChild("inner_fore_leg1", CubeListBuilder.create().texOffs(32, 28).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        PartDefinition foreLeg2 = innerLeg2.addOrReplaceChild("fore_leg2", CubeListBuilder.create().texOffs(32, 28).mirror(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        foreLeg2.addOrReplaceChild("inner_fore_leg2", CubeListBuilder.create().texOffs(32, 28).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.skeleBase.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(MutantSkeleton entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.partialTick = Mth.frac((float)ageInTicks);
        this.animator.update(entityIn, this.partialTick);
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void setAngles() {
        for (ModelPart renderer : this.parts) {
            renderer.xRot = 0.0f;
            renderer.yRot = 0.0f;
            renderer.zRot = 0.0f;
        }
        this.skeleBase.y = 3.0f;
        this.pelvis.xRot = -0.31415927f;
        this.waist.xRot = 0.22439948f;
        for (int i = 0; i < this.spine.length; ++i) {
            this.spine[i].setAngles(i == 1);
        }
        this.neck.xRot = -0.1308997f;
        this.head.xRot = -0.1308997f;
        this.jaw.xRot = 0.09817477f;
        this.shoulder1.xRot = -0.7853982f;
        this.shoulder2.xRot = -0.7853982f;
        this.innerarm1.xRot = 0.5235988f;
        this.innerarm1.zRot = 0.31415927f;
        this.innerarm2.xRot = 0.5235988f;
        this.innerarm2.zRot = -0.31415927f;
        this.innerforearm1.xRot = -0.5235988f;
        this.innerforearm2.xRot = -0.5235988f;
        this.leg1.xRot = -0.2617994f - this.pelvis.xRot;
        this.leg1.zRot = 0.19634955f;
        this.leg2.xRot = -0.2617994f - this.pelvis.xRot;
        this.leg2.zRot = -0.19634955f;
        this.foreleg1.zRot = -0.1308997f;
        this.innerforeleg1.xRot = 0.31415927f;
        this.foreleg2.zRot = 0.1308997f;
        this.innerforeleg2.xRot = 0.31415927f;
        this.crossbow.setAngles((float)Math.PI);
        this.crossbow.rotateRope();
    }

    private void animate(MutantSkeleton skele, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float walkAnim1 = Mth.sin((float)(limbSwing * 0.5f));
        float walkAnim2 = Mth.sin((float)(limbSwing * 0.5f - 1.1f));
        float breatheAnim = Mth.sin((float)(ageInTicks * 0.1f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        if (skele.getAnimation() == MutantSkeleton.MELEE_ANIMATION) {
            this.animateMelee(skele.getAnimationTick(), skele.isLeftHanded());
            this.crossbow.rotateRope();
            scale = 1.0f - Mth.clamp((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
        } else if (skele.getAnimation() == MutantSkeleton.SHOOT_ANIMATION) {
            this.animateShoot(skele.getAnimationTick(), facePitch, faceYaw, skele.isLeftHanded());
            scale = 1.0f - Mth.clamp((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (skele.getAnimation() == MutantSkeleton.MULTI_SHOT_ANIMATION) {
            this.animateMultiShoot(skele.getAnimationTick(), facePitch, faceYaw, skele.isLeftHanded());
            scale = 1.0f - Mth.clamp((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (this.animator.setAnimation(MutantSkeleton.CONSTRICT_RIBS_ANIMATION)) {
            this.animateConstrict();
            this.crossbow.rotateRope();
            scale = 1.0f - Mth.clamp((float)((float)skele.getAnimationTick() / 6.0f), (float)0.0f, (float)1.0f);
            facePitch *= scale;
            faceYaw *= scale;
        } else {
            this.crossbow.rotateRope();
        }
        this.skeleBase.y -= (-0.5f + Math.abs(walkAnim1)) * limbSwingAmount;
        this.spine[0].middle.yRot -= walkAnim1 * 0.06f * limbSwingAmount;
        this.arm1.xRot -= walkAnim1 * 0.9f * limbSwingAmount;
        this.arm2.xRot += walkAnim1 * 0.9f * limbSwingAmount;
        this.leg1.xRot += (0.2f + walkAnim1) * 1.0f * limbSwingAmount;
        this.leg2.xRot -= (-0.2f + walkAnim1) * 1.0f * limbSwingAmount;
        this.innerforeleg1.xRot += (0.6f + walkAnim2) * 0.6f * limbSwingAmount;
        this.innerforeleg2.xRot -= (-0.6f + walkAnim2) * 0.6f * limbSwingAmount;
        for (Spine spine : this.spine) {
            spine.animate(breatheAnim);
        }
        this.head.xRot -= breatheAnim * 0.02f;
        this.jaw.xRot += breatheAnim * 0.04f + 0.04f;
        this.arm1.zRot += breatheAnim * 0.025f;
        this.arm2.zRot -= breatheAnim * 0.025f;
        this.innerhead.xRot += facePitch;
        this.innerhead.yRot += faceYaw;
    }

    private void animateMelee(int fullTick, boolean leftHanded) {
        int offset;
        ModelPart meleeArm = leftHanded ? this.arm2 : this.arm1;
        ModelPart offArm = leftHanded ? this.arm1 : this.arm2;
        int n = offset = leftHanded ? -1 : 1;
        if (fullTick < 3) {
            float tick = ((float)fullTick + this.partialTick) / 3.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.yRot += f * (float)Math.PI / 16.0f * (float)offset;
            }
            meleeArm.yRot += f * (float)Math.PI / 10.0f * (float)offset;
            meleeArm.zRot += f * (float)Math.PI / 4.0f * (float)offset;
            offArm.zRot += f * (float)(-Math.PI) / 16.0f * (float)offset;
        } else if (fullTick < 5) {
            float tick = ((float)(fullTick - 3) + this.partialTick) / 2.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.yRot += (f * 0.5890486f - 0.3926991f) * (float)offset;
            }
            meleeArm.yRot += (f * 2.7307692f - 2.41661f) * (float)offset;
            meleeArm.zRot += (f * 1.1780972f - 0.3926991f) * (float)offset;
            offArm.zRot += -0.19634955f * (float)offset;
        } else if (fullTick < 8) {
            for (Spine spine : this.spine) {
                spine.middle.yRot += -0.3926991f * (float)offset;
            }
            meleeArm.yRot += -2.41661f * (float)offset;
            meleeArm.zRot += -0.3926991f * (float)offset;
            offArm.zRot += -0.19634955f * (float)offset;
        } else if (fullTick < 14) {
            float tick = ((float)(fullTick - 8) + this.partialTick) / 6.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.yRot += f * (float)(-Math.PI) / 8.0f * (float)offset;
            }
            meleeArm.yRot += f * (float)(-Math.PI) / 1.3f * (float)offset;
            meleeArm.zRot += f * (float)(-Math.PI) / 8.0f * (float)offset;
            offArm.zRot += f * (float)(-Math.PI) / 16.0f * (float)offset;
        }
    }

    private void animateShoot(int fullTick, float facePitch, float faceYaw, boolean leftHanded) {
        int offset;
        ModelPart drawingArm = leftHanded ? this.arm2 : this.arm1;
        ModelPart holdingArm = leftHanded ? this.arm1 : this.arm2;
        ModelPart innerDrawingArm = leftHanded ? this.innerarm2 : this.innerarm1;
        ModelPart innerHoldingArm = leftHanded ? this.innerarm1 : this.innerarm2;
        ModelPart drawingForearm = leftHanded ? this.forearm2 : this.forearm1;
        ModelPart holdingforearm = leftHanded ? this.forearm1 : this.forearm2;
        int n = offset = leftHanded ? -1 : 1;
        if (fullTick < 5) {
            float tick = ((float)fullTick + this.partialTick) / 5.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            innerDrawingArm.xRot += -f * (float)Math.PI / 4.0f;
            drawingArm.yRot += -f * (float)Math.PI / 2.0f * (float)offset;
            drawingArm.zRot += f * (float)Math.PI / 16.0f * (float)offset;
            drawingForearm.xRot += f * (float)Math.PI / 7.0f;
            innerHoldingArm.xRot += -f * (float)Math.PI / 4.0f;
            holdingArm.yRot += f * (float)Math.PI / 2.0f * (float)offset;
            holdingArm.zRot += -f * (float)Math.PI / 16.0f * (float)offset;
            innerHoldingArm.zRot += -f * (float)Math.PI / 8.0f * (float)offset;
            holdingforearm.xRot += -f * (float)Math.PI / 6.0f;
            this.crossbow.rotateRope();
        } else if (fullTick < 12) {
            float tick = ((float)(fullTick - 5) + this.partialTick) / 7.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            float f1s = Mth.sin((float)(tick * (float)Math.PI / 2.0f * 0.4f));
            this.innerhead.yRot += f1 * (float)Math.PI / 4.0f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.yRot += -f1 * (float)Math.PI / 12.0f * (float)offset;
                spine.middle.xRot += f1 * facePitch / 3.0f;
                spine.middle.yRot += f1 * faceYaw / 3.0f;
            }
            innerDrawingArm.xRot += f * 0.2617994f - 1.0471976f;
            drawingArm.yRot += (f * -0.9424778f - 0.62831855f) * (float)offset;
            drawingArm.zRot += (f * -0.850848f + 1.0471976f) * (float)offset;
            drawingForearm.xRot += 0.44879895f;
            innerHoldingArm.xRot += f * 1.8325956f - 2.6179938f;
            holdingArm.yRot += (f * 0.9424778f + 0.62831855f) * (float)offset;
            holdingArm.zRot += (f * 0.850848f - 1.0471976f) * (float)offset;
            innerHoldingArm.zRot += -f * (float)Math.PI / 8.0f * (float)offset;
            holdingforearm.xRot += f * 0.10471976f - 0.62831855f;
            this.crossbow.middle1.xRot += -f1s * (float)Math.PI / 16.0f;
            this.crossbow.side1.xRot += -f1s * (float)Math.PI / 24.0f;
            this.crossbow.middle2.xRot += f1s * (float)Math.PI / 16.0f;
            this.crossbow.side2.xRot += f1s * (float)Math.PI / 24.0f;
            this.crossbow.rotateRope();
            this.crossbow.rope1.xRot += f1s * (float)Math.PI / 6.0f;
            this.crossbow.rope2.xRot += -f1s * (float)Math.PI / 6.0f;
        } else if (fullTick < 26) {
            this.innerhead.yRot += 0.7853982f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.yRot += -0.2617994f * (float)offset;
                spine.middle.xRot += facePitch / 3.0f;
                spine.middle.yRot += faceYaw / 3.0f;
            }
            innerDrawingArm.xRot += -1.0471976f;
            drawingArm.yRot += -0.62831855f * (float)offset;
            drawingArm.zRot += (float)offset;
            drawingForearm.xRot += 0.44879895f;
            innerHoldingArm.xRot += -2.6179938f;
            holdingArm.yRot += 0.62831855f * (float)offset;
            holdingArm.zRot += -1.0471976f * (float)offset;
            holdingforearm.xRot += -0.62831855f;
            float tick = Mth.clamp((float)((float)(fullTick - 25) + this.partialTick), (float)0.0f, (float)1.0f);
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.crossbow.middle1.xRot += -f * (float)Math.PI / 16.0f;
            this.crossbow.side1.xRot += -f * (float)Math.PI / 24.0f;
            this.crossbow.middle2.xRot += f * (float)Math.PI / 16.0f;
            this.crossbow.side2.xRot += f * (float)Math.PI / 24.0f;
            this.crossbow.rotateRope();
            this.crossbow.rope1.xRot += f * (float)Math.PI / 6.0f;
            this.crossbow.rope2.xRot += -f * (float)Math.PI / 6.0f;
        } else if (fullTick < 30) {
            float tick = ((float)(fullTick - 26) + this.partialTick) / 4.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.innerhead.yRot += f * (float)Math.PI / 4.0f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.yRot += -f * (float)Math.PI / 12.0f * (float)offset;
                spine.middle.xRot += f * facePitch / 3.0f;
                spine.middle.yRot += f * faceYaw / 3.0f;
            }
            innerDrawingArm.xRot += -f * (float)Math.PI / 3.0f;
            drawingArm.yRot += -f * (float)Math.PI / 5.0f * (float)offset;
            drawingArm.zRot += f * (float)Math.PI / 3.0f * (float)offset;
            drawingForearm.xRot += f * (float)Math.PI / 7.0f;
            innerHoldingArm.xRot += -f * (float)Math.PI / 1.2f;
            holdingArm.yRot += f * (float)Math.PI / 5.0f * (float)offset;
            holdingArm.zRot += -f * (float)Math.PI / 3.0f * (float)offset;
            holdingforearm.xRot += -f * (float)Math.PI / 5.0f;
            this.crossbow.rotateRope();
        }
    }

    private void animateMultiShoot(int fullTick, float facePitch, float faceYaw, boolean leftHanded) {
        if (fullTick < 10) {
            float tick = ((float)fullTick + this.partialTick) / 10.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.skeleBase.y += f * 3.5f;
            this.spine[0].middle.xRot += f * (float)Math.PI / 6.0f;
            this.head.xRot += -f * (float)Math.PI / 4.0f;
            this.arm1.xRot += f * (float)Math.PI / 6.0f;
            this.arm1.zRot += f * (float)Math.PI / 16.0f;
            this.arm2.xRot += f * (float)Math.PI / 6.0f;
            this.arm2.zRot += -f * (float)Math.PI / 16.0f;
            this.leg1.xRot += -f * (float)Math.PI / 8.0f;
            this.leg2.xRot += -f * (float)Math.PI / 8.0f;
            this.innerforeleg1.xRot += f * (float)Math.PI / 4.0f;
            this.innerforeleg2.xRot += f * (float)Math.PI / 4.0f;
            this.crossbow.rotateRope();
        } else {
            int offset;
            ModelPart drawingArm = leftHanded ? this.arm2 : this.arm1;
            ModelPart holdingArm = leftHanded ? this.arm1 : this.arm2;
            ModelPart innerDrawingArm = leftHanded ? this.innerarm2 : this.innerarm1;
            ModelPart innerHoldingArm = leftHanded ? this.innerarm1 : this.innerarm2;
            ModelPart drawingForearm = leftHanded ? this.forearm2 : this.forearm1;
            ModelPart holdingforearm = leftHanded ? this.forearm1 : this.forearm2;
            int n = offset = leftHanded ? -1 : 1;
            if (fullTick < 12) {
                float tick = ((float)(fullTick - 10) + this.partialTick) / 2.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
                this.skeleBase.y += f * 3.5f;
                this.spine[0].middle.xRot += f * (float)Math.PI / 6.0f;
                this.head.xRot += -f * (float)Math.PI / 4.0f;
                drawingArm.xRot += f * (float)Math.PI / 6.0f;
                drawingArm.zRot += f * (float)Math.PI / 16.0f * (float)offset;
                holdingArm.xRot += f * (float)Math.PI / 6.0f;
                holdingArm.zRot += -f * (float)Math.PI / 16.0f * (float)offset;
                this.leg1.xRot += -f * (float)Math.PI / 8.0f;
                this.leg2.xRot += -f * (float)Math.PI / 8.0f;
                this.innerforeleg1.xRot += f * (float)Math.PI / 4.0f;
                this.innerforeleg2.xRot += f * (float)Math.PI / 4.0f;
                drawingArm.zRot += -f1 * (float)Math.PI / 14.0f * (float)offset;
                holdingArm.zRot += f1 * (float)Math.PI / 14.0f * (float)offset;
                this.leg1.zRot += -f1 * (float)Math.PI / 24.0f;
                this.leg2.zRot += f1 * (float)Math.PI / 24.0f;
                this.foreleg1.zRot += f1 * (float)Math.PI / 64.0f;
                this.foreleg2.zRot += -f1 * (float)Math.PI / 64.0f;
                this.crossbow.rotateRope();
            } else if (fullTick < 14) {
                drawingArm.zRot += -0.22439948f * (float)offset;
                holdingArm.zRot += 0.22439948f * (float)offset;
                this.leg1.zRot += -0.1308997f;
                this.leg2.zRot += 0.1308997f;
                this.foreleg1.zRot += 0.049087387f;
                this.foreleg2.zRot += -0.049087387f;
                this.crossbow.rotateRope();
            } else if (fullTick < 17) {
                float tick = ((float)(fullTick - 14) + this.partialTick) / 3.0f;
                float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                drawingArm.zRot += -f1 * (float)Math.PI / 14.0f * (float)offset;
                holdingArm.zRot += f1 * (float)Math.PI / 14.0f * (float)offset;
                this.leg1.zRot += -f1 * (float)Math.PI / 24.0f;
                this.leg2.zRot += f1 * (float)Math.PI / 24.0f;
                this.foreleg1.zRot += f1 * (float)Math.PI / 64.0f;
                this.foreleg2.zRot += -f1 * (float)Math.PI / 64.0f;
                innerDrawingArm.xRot += -f * (float)Math.PI / 4.0f;
                drawingArm.yRot += -f * (float)Math.PI / 2.0f * (float)offset;
                drawingArm.zRot += f * (float)Math.PI / 16.0f * (float)offset;
                drawingForearm.xRot += f * (float)Math.PI / 7.0f;
                innerHoldingArm.xRot += -f * (float)Math.PI / 4.0f;
                holdingArm.yRot += f * (float)Math.PI / 2.0f * (float)offset;
                holdingArm.zRot += -f * (float)Math.PI / 16.0f * (float)offset;
                innerHoldingArm.zRot += -f * (float)Math.PI / 8.0f * (float)offset;
                holdingforearm.xRot += -f * (float)Math.PI / 6.0f;
                this.crossbow.rotateRope();
            } else if (fullTick < 20) {
                float tick = ((float)(fullTick - 17) + this.partialTick) / 3.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
                float f1s = Mth.sin((float)(tick * (float)Math.PI / 2.0f * 0.4f));
                this.innerhead.yRot += f1 * (float)Math.PI / 4.0f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.yRot += -f1 * (float)Math.PI / 12.0f * (float)offset;
                    spine.middle.xRot += f1 * facePitch / 3.0f;
                    spine.middle.yRot += f1 * faceYaw / 3.0f;
                }
                innerDrawingArm.xRot += f * 0.2617994f - 1.0471976f;
                drawingArm.yRot += (f * -0.9424778f - 0.62831855f) * (float)offset;
                drawingArm.zRot += (f * -0.850848f + 1.0471976f) * (float)offset;
                drawingForearm.xRot += 0.44879895f;
                innerHoldingArm.xRot += f * 1.8325956f - 2.6179938f;
                holdingArm.yRot += (f * 0.9424778f + 0.62831855f) * (float)offset;
                holdingArm.zRot += (f * 0.850848f - 1.0471976f) * (float)offset;
                innerHoldingArm.zRot += -f * (float)Math.PI / 8.0f * (float)offset;
                holdingforearm.xRot += f * 0.10471976f - 0.62831855f;
                this.crossbow.middle1.xRot += -f1s * (float)Math.PI / 16.0f;
                this.crossbow.side1.xRot += -f1s * (float)Math.PI / 24.0f;
                this.crossbow.middle2.xRot += f1s * (float)Math.PI / 16.0f;
                this.crossbow.side2.xRot += f1s * (float)Math.PI / 24.0f;
                this.crossbow.rotateRope();
                this.crossbow.rope1.xRot += f1s * (float)Math.PI / 6.0f;
                this.crossbow.rope2.xRot += -f1s * (float)Math.PI / 6.0f;
            } else if (fullTick < 24) {
                this.innerhead.yRot += 0.7853982f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.yRot += -0.2617994f * (float)offset;
                    spine.middle.xRot += facePitch / 3.0f;
                    spine.middle.yRot += faceYaw / 3.0f;
                }
                innerDrawingArm.xRot += -1.0471976f;
                drawingArm.yRot += -0.62831855f * (float)offset;
                drawingArm.zRot += (float)offset;
                drawingForearm.xRot += 0.44879895f;
                innerHoldingArm.xRot += -2.6179938f;
                holdingArm.yRot += 0.62831855f * (float)offset;
                holdingArm.zRot += -1.0471976f * (float)offset;
                holdingforearm.xRot += -0.62831855f;
                float tick = Mth.clamp((float)((float)(fullTick - 25) + this.partialTick), (float)0.0f, (float)1.0f);
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                this.crossbow.middle1.xRot += -f * (float)Math.PI / 16.0f;
                this.crossbow.side1.xRot += -f * (float)Math.PI / 24.0f;
                this.crossbow.middle2.xRot += f * (float)Math.PI / 16.0f;
                this.crossbow.side2.xRot += f * (float)Math.PI / 24.0f;
                this.crossbow.rotateRope();
                this.crossbow.rope1.xRot += f * (float)Math.PI / 6.0f;
                this.crossbow.rope2.xRot += -f * (float)Math.PI / 6.0f;
            } else if (fullTick < 28) {
                float tick = ((float)(fullTick - 24) + this.partialTick) / 4.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                this.innerhead.yRot += f * (float)Math.PI / 4.0f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.yRot += -f * (float)Math.PI / 12.0f * (float)offset;
                    spine.middle.xRot += f * facePitch / 3.0f;
                    spine.middle.yRot += f * faceYaw / 3.0f;
                }
                innerDrawingArm.xRot += -f * (float)Math.PI / 3.0f;
                drawingArm.yRot += -f * (float)Math.PI / 5.0f * (float)offset;
                drawingArm.zRot += f * (float)Math.PI / 3.0f * (float)offset;
                drawingForearm.xRot += f * (float)Math.PI / 7.0f;
                innerHoldingArm.xRot += -f * (float)Math.PI / 1.2f;
                holdingArm.yRot += f * (float)Math.PI / 5.0f * (float)offset;
                holdingArm.zRot += -f * (float)Math.PI / 3.0f * (float)offset;
                holdingforearm.xRot += -f * (float)Math.PI / 5.0f;
                this.crossbow.rotateRope();
            }
        }
    }

    private void animateConstrict() {
        float f;
        float tick;
        int animTick;
        this.animator.startPhase(5);
        this.animator.rotate(this.waist, 0.1308997f, 0.0f, 0.0f);
        for (animTick = 0; animTick < this.spine.length; ++animTick) {
            tick = animTick == 0 ? 0.3926991f : (animTick == 2 ? -0.3926991f : 0.0f);
            f = animTick == 1 ? 0.3926991f : 0.31415927f;
            this.animator.rotate(this.spine[animTick].side1[0], tick, f, 0.0f);
            this.animator.rotate(this.spine[animTick].side1[1], 0.0f, 0.15707964f, 0.0f);
            this.animator.rotate(this.spine[animTick].side1[2], 0.0f, 0.2617994f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[0], tick, -f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[1], 0.0f, -0.15707964f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[2], 0.0f, -0.2617994f, 0.0f);
        }
        this.animator.rotate(this.arm1, 0.0f, 0.0f, 0.8975979f);
        this.animator.rotate(this.arm2, 0.0f, 0.0f, -0.8975979f);
        this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.leg1, -0.44879895f, 0.0f, 0.0f);
        this.animator.rotate(this.leg2, -0.44879895f, 0.0f, 0.0f);
        this.animator.rotate(this.innerforeleg1, 0.5235988f, 0.0f, 0.0f);
        this.animator.rotate(this.innerforeleg2, 0.5235988f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(2);
        this.animator.startPhase(1);
        this.animator.rotate(this.neck, 0.19634955f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.15707964f, 0.0f, 0.0f);
        this.animator.rotate(this.waist, 0.31415927f, 0.0f, 0.0f);
        this.animator.rotate(this.spine[0].middle, 0.2617994f, 0.0f, 0.0f);
        for (animTick = 0; animTick < this.spine.length; ++animTick) {
            tick = animTick == 0 ? 0.1308997f : (animTick == 2 ? -0.1308997f : 0.0f);
            f = animTick == 1 ? -0.17453294f : -0.22439948f;
            this.animator.rotate(this.spine[animTick].side1[0], tick - 0.08f, f, 0.0f);
            this.animator.rotate(this.spine[animTick].side1[1], 0.0f, 0.15707964f, 0.0f);
            this.animator.rotate(this.spine[animTick].side1[2], 0.0f, 0.2617994f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[0], tick + 0.08f, -f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[1], 0.0f, -0.15707964f, 0.0f);
            this.animator.rotate(this.spine[animTick].side2[2], 0.0f, -0.2617994f, 0.0f);
        }
        this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.leg1, -0.44879895f, 0.0f, 0.0f);
        this.animator.rotate(this.leg2, -0.44879895f, 0.0f, 0.0f);
        this.animator.rotate(this.innerforeleg1, 0.5235988f, 0.0f, 0.0f);
        this.animator.rotate(this.innerforeleg2, 0.5235988f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(4);
        this.animator.resetPhase(8);
        animTick = this.animator.getEntity().getAnimationTick();
    }

    public void translateHand(boolean leftHanded, PoseStack matrixStackIn) {
        this.skeleBase.translateAndRotate(matrixStackIn);
        this.pelvis.translateAndRotate(matrixStackIn);
        this.waist.translateAndRotate(matrixStackIn);
        for (Spine spine : this.spine) {
            spine.middle.translateAndRotate(matrixStackIn);
        }
        if (leftHanded) {
            this.shoulder2.translateAndRotate(matrixStackIn);
            this.arm2.translateAndRotate(matrixStackIn);
            this.innerarm2.translateAndRotate(matrixStackIn);
            this.forearm2.translateAndRotate(matrixStackIn);
            this.innerforearm2.translateAndRotate(matrixStackIn);
        } else {
            this.shoulder1.translateAndRotate(matrixStackIn);
            this.arm1.translateAndRotate(matrixStackIn);
            this.innerarm1.translateAndRotate(matrixStackIn);
            this.forearm1.translateAndRotate(matrixStackIn);
            this.innerforearm1.translateAndRotate(matrixStackIn);
        }
    }

    public MutantCrossbowModel getCrossbow() {
        return this.crossbow;
    }

    public static class Spine {
        public final ModelPart middle;
        public final ModelPart[] side1 = new ModelPart[3];
        public final ModelPart[] side2 = new ModelPart[3];

        public Spine(ModelPart modelPart, String indexString) {
            int i;
            modelPart = this.middle = modelPart.getChild("middle" + indexString);
            for (i = 0; i < 3; ++i) {
                modelPart = this.side1[i] = modelPart.getChild("side1" + (i + 1) + indexString);
            }
            modelPart = this.middle;
            for (i = 0; i < 3; ++i) {
                modelPart = this.side2[i] = modelPart.getChild("side2" + (i + 1) + indexString);
            }
        }

        public static void createSpineLayer(PartDefinition root, int index) {
            PartPose partPose = PartPose.ZERO;
            if (index == 0) {
                partPose = PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f);
            } else if (index > 0) {
                partPose = PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f);
            }
            boolean skeletonPart = index < 0;
            String indexString = skeletonPart ? "" : "" + (index + 1);
            PartDefinition middle = root.addOrReplaceChild("middle" + indexString, CubeListBuilder.create().texOffs(50, 0).addBox(-2.5f, -4.0f, -2.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.5f)), partPose);
            partPose = !skeletonPart ? PartPose.offset((float)-3.0f, (float)-1.0f, (float)1.75f) : PartPose.ZERO;
            PartDefinition side11 = middle.addOrReplaceChild("side11" + indexString, CubeListBuilder.create().texOffs(32, 12).addBox(skeletonPart ? 0.0f : -6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.25f)), partPose);
            PartDefinition side12 = side11.addOrReplaceChild("side12" + indexString, CubeListBuilder.create().texOffs(32, 12).mirror().addBox(-6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.offset((float)(skeletonPart ? -0.5f : -6.5f), (float)0.0f, (float)0.0f));
            side12.addOrReplaceChild("side13" + indexString, CubeListBuilder.create().texOffs(32, 12).addBox(-6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.15f)), PartPose.offset((float)-6.4f, (float)0.0f, (float)0.0f));
            partPose = !skeletonPart ? PartPose.offset((float)3.0f, (float)-1.0f, (float)1.75f) : PartPose.ZERO;
            PartDefinition side21 = middle.addOrReplaceChild("side21" + indexString, CubeListBuilder.create().texOffs(32, 12).mirror().addBox(skeletonPart ? -6.0f : 0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.25f)), partPose);
            PartDefinition side22 = side21.addOrReplaceChild("side22" + indexString, CubeListBuilder.create().texOffs(32, 12).addBox(0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.offset((float)(skeletonPart ? 0.5f : 6.5f), (float)0.0f, (float)0.0f));
            side22.addOrReplaceChild("side23" + indexString, CubeListBuilder.create().texOffs(32, 12).mirror().addBox(0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.15f)), PartPose.offset((float)6.4f, (float)0.0f, (float)0.0f));
        }

        public void setAngles(boolean middleSpine) {
            Animator.resetAngles(this.middle);
            Animator.resetAngles(this.side1);
            Animator.resetAngles(this.side2);
            this.middle.xRot = 0.17453294f;
            this.side1[0].yRot = -0.69813174f;
            this.side2[0].yRot = 0.69813174f;
            this.side1[1].yRot = -1.0471976f;
            this.side2[1].yRot = 1.0471976f;
            this.side1[2].yRot = -0.8975979f;
            this.side2[2].yRot = 0.8975979f;
            if (middleSpine) {
                for (int i = 0; i < this.side1.length; ++i) {
                    this.side1[i].yRot *= 0.98f;
                    this.side2[i].yRot *= 0.98f;
                }
            }
        }

        public void animate(float breatheAnim) {
            this.side1[1].yRot += breatheAnim * 0.02f;
            this.side2[1].yRot -= breatheAnim * 0.02f;
        }
    }
}

