/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;

public class CreeperChargeLayer<T extends Entity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final ResourceLocation LIGHTNING_TEXTURE = ResourceLocationHelper.withDefaultNamespace((String)"textures/entity/creeper/creeper_armor.png");
    private final M model;

    public CreeperChargeLayer(RenderLayerParent<T, M> renderer, M model) {
        super(renderer);
        this.model = model;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        CreeperMinion creeperMinion;
        MutantCreeper mutantCreeper;
        if (entity instanceof MutantCreeper && (mutantCreeper = (MutantCreeper)((Object)entity)).isCharged() || entity instanceof CreeperMinion && (creeperMinion = (CreeperMinion)((Object)entity)).isCharged()) {
            this.model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
            this.getParentModel().copyPropertiesTo(this.model);
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(MutantRenderTypes.energySwirl(LIGHTNING_TEXTURE, ageInTicks * 0.01f, ageInTicks * 0.01f));
            this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            int color = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
            this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        }
    }
}

