/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.network;

import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class S2CMutantEndermanHeldBlockMessage
implements MessageV2<S2CMutantEndermanHeldBlockMessage> {
    private int entityId;
    private int blockId;
    private byte index;

    public S2CMutantEndermanHeldBlockMessage() {
    }

    public S2CMutantEndermanHeldBlockMessage(MutantEnderman mutantEnderman, int blockId, int index) {
        this.entityId = mutantEnderman.getId();
        this.blockId = blockId;
        this.index = (byte)index;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.entityId);
        buf.writeVarInt(this.blockId);
        buf.writeByte((int)this.index);
    }

    public void read(FriendlyByteBuf buf) {
        this.entityId = buf.readVarInt();
        this.blockId = buf.readVarInt();
        this.index = buf.readByte();
    }

    public MessageV2.MessageHandler<S2CMutantEndermanHeldBlockMessage> makeHandler() {
        return new MessageV2.MessageHandler<S2CMutantEndermanHeldBlockMessage>(this){

            public void handle(S2CMutantEndermanHeldBlockMessage message, Player player, Object gameInstance) {
                ClientLevel level = ((Minecraft)gameInstance).level;
                Entity entity = level.getEntity(message.entityId);
                if (entity instanceof MutantEnderman) {
                    ((MutantEnderman)entity).setHeldBlock(message.index, message.blockId, 0);
                }
            }
        };
    }
}

