/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class EndersoulClone
extends Monster {
    private MutantEnderman cloner;

    public EndersoulClone(EntityType<? extends EndersoulClone> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = this.random.nextInt(2);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, -1.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.2));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return EndersoulClone.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void setCloner(MutantEnderman cloner) {
        this.cloner = cloner;
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)cloner.getMaxHealth());
        this.setHealth(cloner.getHealth());
        if (cloner.hasCustomName()) {
            this.setCustomName(cloner.getCustomName());
            this.setCustomNameVisible(cloner.isCustomNameVisible());
        }
    }

    public int getMaxFallDistance() {
        return 3;
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 0) {
            EntityUtil.spawnEndersoulParticles((Entity)this, this.random, 256, 1.8f);
        }
    }

    public void aiStep() {
        this.jumping = false;
        super.aiStep();
        if (this.cloner != null && (this.cloner.isNoAi() || !this.cloner.isAlive() || this.cloner.level() != this.level())) {
            this.discard();
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        boolean flag = super.doHurtTarget(entityIn);
        if (!this.level().isClientSide && this.random.nextInt(3) != 0) {
            this.teleportToEntity(entityIn);
        }
        if (flag) {
            this.heal(2.0f);
        }
        this.swing(InteractionHand.MAIN_HAND);
        return flag;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (this.isInvulnerableTo(damageSource)) {
            return false;
        }
        if (damageSource.getEntity() instanceof EnderDragon) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isAlive() && this.tickCount > 10) {
                if (damageSource.getEntity() instanceof Player) {
                    this.setLastHurtByPlayer((Player)damageSource.getEntity());
                }
                this.dropAllDeathLoot(serverLevel, damageSource);
                this.dropExperience(damageSource.getEntity());
                this.remove(Entity.RemovalReason.KILLED);
                this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                return true;
            }
        }
        return false;
    }

    protected void customServerAiStep() {
        LivingEntity entity = this.getTarget();
        if (this.random.nextInt(10) == 0 && entity != null && (this.isInWater() || this.isPassengerOfSameVehicle((Entity)entity) || this.distanceToSqr((Entity)entity) > 1024.0 || !this.isPathFinding())) {
            this.teleportToEntity((Entity)entity);
        }
        if (this.cloner != null && entity != this.cloner.getTarget()) {
            this.setTarget(this.cloner.getTarget());
        }
    }

    private boolean teleportToEntity(Entity entity) {
        double z;
        double y;
        double x = entity.getX() + (this.random.nextDouble() - 0.5) * 24.0;
        boolean teleport = EntityUtil.teleportTo((Mob)this, x, y = entity.getY() + (double)this.random.nextInt(5) + 4.0, z = entity.getZ() + (this.random.nextDouble() - 0.5) * 24.0);
        if (teleport) {
            this.level().playSound(null, this.xo, this.yo, this.zo, (SoundEvent)ModSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.value(), this.getSoundSource(), 1.0f, 1.0f);
            this.playSound((SoundEvent)ModSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.value(), 1.0f, 1.0f);
            this.stopRiding();
        }
        return teleport;
    }

    protected void pushEntities() {
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean addEffect(MobEffectInstance effectInstanceIn, @Nullable Entity entity) {
        return false;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.cloner != null;
    }

    public void kill() {
        super.kill();
        this.level().broadcastEntityEvent((Entity)this, (byte)0);
        this.playSound(this.getDeathSound(), this.getSoundVolume(), this.getVoicePitch());
    }

    public boolean is(Entity entityIn) {
        return super.is(entityIn) || entityIn instanceof MutantEnderman;
    }

    public boolean saveAsPassenger(CompoundTag compound) {
        return this.cloner == null && super.saveAsPassenger(compound);
    }

    public boolean isAlliedTo(Entity entityIn) {
        return this.cloner != null && (this.cloner == entityIn || this.cloner.isAlliedTo(entityIn)) || super.isAlliedTo(entityIn);
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_ENDERSOUL_CLONE_DEATH_SOUND_EVENT.value();
    }
}

