/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.world.effect.ChemicalXMobEffect;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SkullSpirit
extends Entity {
    private static final EntityDataAccessor<OptionalInt> TARGET_ENTITY_ID = SynchedEntityData.defineId(SkullSpirit.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private static final EntityDataAccessor<Boolean> ATTACHED = SynchedEntityData.defineId(SkullSpirit.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Mob target;
    private int startTick = 15;
    private int attachedTick = 80 + this.random.nextInt(40);
    private UUID targetUUID;
    @Nullable
    private UUID conversionStarter;

    public SkullSpirit(EntityType<? extends SkullSpirit> type, Level level) {
        super(type, level);
        this.noPhysics = true;
    }

    public SkullSpirit(Level level, Mob target, @Nullable UUID conversionStarter) {
        this((EntityType<? extends SkullSpirit>)((EntityType)ModEntityTypes.SKULL_SPIRIT_ENTITY_TYPE.value()), level);
        this.entityData.set(TARGET_ENTITY_ID, (Object)OptionalInt.of(target.getId()));
        this.conversionStarter = conversionStarter;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TARGET_ENTITY_ID, (Object)OptionalInt.empty());
        builder.define(ATTACHED, (Object)false);
    }

    public boolean isAttached() {
        return (Boolean)this.entityData.get(ATTACHED);
    }

    private void setAttached(boolean attached) {
        this.entityData.set(ATTACHED, (Object)attached);
    }

    public Mob getTarget() {
        return this.target;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (TARGET_ENTITY_ID.equals(key)) {
            ((OptionalInt)this.entityData.get(TARGET_ENTITY_ID)).ifPresent(id -> {
                Entity entity = this.level().getEntity(id);
                if (entity instanceof Mob) {
                    Mob mob;
                    this.target = mob = (Mob)entity;
                }
            });
        }
    }

    public void tick() {
        Entity entity;
        if (this.targetUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.targetUUID)) instanceof Mob) {
            Mob mob = (Mob)entity;
            this.entityData.set(TARGET_ENTITY_ID, (Object)OptionalInt.of(mob.getId()));
            this.targetUUID = null;
        }
        if (this.target != null && this.target.isAlive()) {
            if (this.isAttached()) {
                if (!this.level().isClientSide) {
                    this.target.setDeltaMovement((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), this.target.getDeltaMovement().y, (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f));
                    if (--this.attachedTick <= 0) {
                        EntityType<?> mutantType = ChemicalXMobEffect.getMutantOf(this.target);
                        if (mutantType != null && this.random.nextInt(4) != 0) {
                            MutatedExplosionHelper.explode(this, 2.0f, false, Level.ExplosionInteraction.NONE);
                            Mob mutant = this.target.convertTo(mutantType, true);
                            if (mutant != null) {
                                Player player;
                                mutant.setPersistenceRequired();
                                AABB boundingBox = mutant.getBoundingBox();
                                for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)boundingBox.minX), (int)Mth.floor((double)mutant.getY()), (int)Mth.floor((double)boundingBox.minZ), (int)Mth.floor((double)boundingBox.maxX), (int)Mth.floor((double)boundingBox.maxY), (int)Mth.floor((double)boundingBox.maxZ))) {
                                    if (!(this.level().getBlockState(pos).getDestroySpeed((BlockGetter)this.level(), pos) > -1.0f)) continue;
                                    this.level().destroyBlock(pos, true);
                                }
                                if (this.conversionStarter != null && (player = this.level().getPlayerByUUID(this.conversionStarter)) instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)mutant);
                                }
                            }
                        } else {
                            this.setAttached(false);
                            MutatedExplosionHelper.explode(this, 2.0f, false, Level.ExplosionInteraction.NONE);
                        }
                        this.discard();
                    }
                }
                this.setPos(this.target.getX(), this.target.getY(), this.target.getZ());
                if (this.random.nextInt(8) == 0) {
                    this.target.hurt(this.level().damageSources().magic(), 0.0f);
                }
                for (int i = 0; i < 3; ++i) {
                    double posX = this.target.getX() + (double)(this.random.nextFloat() * this.target.getBbWidth() * 2.0f) - (double)this.target.getBbWidth();
                    double posY = this.target.getY() + 0.5 + (double)(this.random.nextFloat() * this.target.getBbHeight());
                    double posZ = this.target.getZ() + (double)(this.random.nextFloat() * this.target.getBbWidth() * 2.0f) - (double)this.target.getBbWidth();
                    double x = this.random.nextGaussian() * 0.02;
                    double y = this.random.nextGaussian() * 0.02;
                    double z = this.random.nextGaussian() * 0.02;
                    this.level().addParticle((ParticleOptions)ModRegistry.SKULL_SPIRIT_PARTICLE_TYPE.value(), posX, posY, posZ, x, y, z);
                }
            } else {
                double z;
                double y;
                double x;
                double d;
                this.xo = this.getX();
                this.yo = this.getY();
                this.zo = this.getZ();
                this.setDeltaMovement(Vec3.ZERO);
                if (this.startTick-- >= 0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(0.3f * (float)this.startTick / 15.0f), 0.0));
                }
                if ((d = Math.sqrt((x = this.target.getX() - this.getX()) * x + (y = this.target.getY() - this.getY()) * y + (z = this.target.getZ() - this.getZ()) * z)) != 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(x / d * 0.2, y / d * 0.2, z / d * 0.2));
                    this.move(MoverType.SELF, this.getDeltaMovement());
                }
                if (!this.level().isClientSide && this.distanceToSqr((Entity)this.target) < 1.0) {
                    this.setAttached(true);
                }
                for (int i = 0; i < 16; ++i) {
                    float xx = (this.random.nextFloat() - 0.5f) * 1.2f;
                    float yy = (this.random.nextFloat() - 0.5f) * 1.2f;
                    float zz = (this.random.nextFloat() - 0.5f) * 1.2f;
                    this.level().addParticle((ParticleOptions)ModRegistry.SKULL_SPIRIT_PARTICLE_TYPE.value(), this.getX() + (double)xx, this.getY() + (double)yy, this.getZ() + (double)zz, 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.discard();
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean("Attached", this.isAttached());
        compound.putInt("AttachedTick", this.attachedTick);
        if (this.target != null) {
            compound.putUUID("Target", this.target.getUUID());
        }
        if (this.conversionStarter != null) {
            compound.putUUID("ConversionPlayer", this.conversionStarter);
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setAttached(compound.getBoolean("Attached"));
        this.attachedTick = compound.getInt("AttachedTick");
        if (compound.hasUUID("Target")) {
            this.targetUUID = compound.getUUID("Target");
        }
        if (compound.hasUUID("ConversionPlayer")) {
            this.conversionStarter = compound.getUUID("ConversionPlayer");
        }
    }
}

