/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.FleeRainGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantSnowGolem
extends AbstractGolem
implements RangedAttackMob,
Shearable {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(MutantSnowGolem.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.defineId(MutantSnowGolem.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private boolean isThrowing;
    private int throwingTick;

    public MutantSnowGolem(EntityType<? extends MutantSnowGolem> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SwimJumpGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FleeRainGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.1, 30, 12.0f));
        this.goalSelector.addGoal(3, (Goal)new ThrowIceGoal());
        this.goalSelector.addGoal(4, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, entity -> entity instanceof Enemy && (!(entity instanceof Creeper) || ((Creeper)entity).getTarget() == this)));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MutantSnowGolem.createMobAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, 0.26);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER_UNIQUE_ID, Optional.empty());
        builder.define(STATUS, (Object)1);
    }

    @Nullable
    public Player getOwner() {
        return this.getOwnerId().map(arg_0 -> ((Level)this.level()).getPlayerByUUID(arg_0)).orElse(null);
    }

    public Optional<UUID> getOwnerId() {
        return (Optional)this.entityData.get(OWNER_UNIQUE_ID);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public boolean hasJackOLantern() {
        return ((Byte)this.entityData.get(STATUS) & 1) != 0;
    }

    public void setJackOLantern(boolean jackOLantern) {
        byte b0 = (Byte)this.entityData.get(STATUS);
        this.entityData.set(STATUS, (Object)(jackOLantern ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean getSwimJump() {
        return ((Byte)this.entityData.get(STATUS) & 4) != 0;
    }

    public void setSwimJump(boolean swimJumping) {
        byte b0 = (Byte)this.entityData.get(STATUS);
        this.entityData.set(STATUS, (Object)(swimJumping ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    public boolean canAttack(LivingEntity target) {
        return super.canAttack(target) && target instanceof Enemy;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        if (worldIn.getBiome(pos).is(BiomeTags.SNOW_GOLEM_MELTS)) {
            return -10.0f;
        }
        return worldIn.getBlockState(pos).getBlock() == Blocks.SNOW ? 10.0f : 0.0f;
    }

    public void tick() {
        int x;
        super.tick();
        if (this.level().isClientSide && this.getSwimJump()) {
            for (x = 0; x < 6; ++x) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW.defaultBlockState()), this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
                d0 = this.random.nextGaussian() * 0.02;
                d1 = this.random.nextGaussian() * 0.02;
                d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
        }
        if (this.isThrowing) {
            ++this.throwingTick;
            if (this.throwingTick >= 20) {
                this.isThrowing = false;
                this.throwingTick = 0;
            }
        }
        if (this.level().dimensionType().ultraWarm() || this.level().getBiome(this.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS)) {
            if (this.random.nextFloat() > Math.min(80.0f, this.getHealth()) * 0.01f) {
                this.level().addParticle((ParticleOptions)ParticleTypes.FALLING_WATER, this.getRandomX(0.6), this.getRandomY() - 0.15, this.getRandomZ(0.6), 0.0, 0.0, 0.0);
            }
            if (this.tickCount % 60 == 0) {
                this.hurt(this.level().damageSources().onFire(), 1.0f);
            }
        }
        if (this.tickCount % 80 == 0 && this.isAlive() && this.getHealth() < this.getMaxHealth() && this.isSnowingAt(this.blockPosition())) {
            this.heal(1.0f);
        }
        if (!this.level().isClientSide && this.onGround() && !this.level().dimensionType().ultraWarm() && CommonAbstractions.INSTANCE.getMobGriefingRule(this.level(), (Entity)this)) {
            x = Mth.floor((double)this.getX());
            int y = Mth.floor((double)this.getBoundingBox().minY);
            int z = Mth.floor((double)this.getZ());
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    boolean placeIce;
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    BlockPos pos = new BlockPos(x + i, y, z + j);
                    BlockPos posDown = pos.below();
                    BlockPos posAbove = pos.above();
                    boolean placeSnow = this.level().isEmptyBlock(pos) && Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)this.level(), pos);
                    boolean bl = placeIce = this.level().isWaterAt(posDown) && this.level().getBlockState(posDown).getBlock() instanceof LiquidBlock;
                    if (this.level().getFluidState(pos).getType() == Fluids.FLOWING_WATER) {
                        this.level().setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
                    }
                    if (this.level().getFluidState(posAbove).getType() == Fluids.FLOWING_WATER) {
                        this.level().setBlockAndUpdate(posAbove, Blocks.ICE.defaultBlockState());
                    }
                    if (placeSnow && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.random.nextInt(20) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.random.nextInt(10) != 0) || placeIce && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.random.nextInt(14) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.random.nextInt(6) != 0)) continue;
                    if (placeSnow) {
                        this.level().setBlockAndUpdate(pos, Blocks.SNOW.defaultBlockState());
                    }
                    if (!placeIce) continue;
                    this.level().setBlockAndUpdate(posDown, Blocks.ICE.defaultBlockState());
                }
            }
        }
    }

    private boolean isSnowingAt(BlockPos position) {
        if (!this.level().isRaining()) {
            return false;
        }
        if (!this.level().canSeeSky(position)) {
            return false;
        }
        if (this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, position).getY() > position.getY()) {
            return false;
        }
        return ((Biome)this.level().getBiome(position).value()).getPrecipitationAt(position) == Biome.Precipitation.SNOW;
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public boolean readyForShearing() {
        return this.isAlive() && this.hasJackOLantern();
    }

    public void shear(SoundSource source) {
        this.level().playSound(null, (Entity)this, SoundEvents.SNOW_GOLEM_SHEAR, source, 1.0f, 1.0f);
        if (!this.level().isClientSide()) {
            this.setJackOLantern(false);
            this.spawnAtLocation(new ItemStack((ItemLike)Items.JACK_O_LANTERN), 1.7f);
        }
    }

    protected void customServerAiStep() {
        if (!this.isLeashed()) {
            Player owner = this.getOwner();
            if (owner != null && owner.isAlive()) {
                this.restrictTo(owner.blockPosition(), this.getTarget() == null ? 8 : 16);
            } else if (this.hasRestriction()) {
                this.restrictTo(BlockPos.ZERO, -1);
            }
        }
    }

    public boolean isThrowing() {
        return this.isThrowing;
    }

    public int getThrowingTick() {
        return this.throwingTick;
    }

    private void setThrowing(boolean isThrowing) {
        this.isThrowing = isThrowing;
        this.throwingTick = 0;
        this.level().broadcastEntityEvent((Entity)this, (byte)(isThrowing ? 1 : 0));
    }

    public void handleEntityEvent(byte id) {
        if (id != 0 && id != 1) {
            super.handleEntityEvent(id);
            if (id == 2 || id == 33 || id == 36 || id == 37 || id == 44) {
                for (int i = 0; i < 30; ++i) {
                    double d0 = this.random.nextGaussian() * 0.02;
                    double d1 = this.random.nextGaussian() * 0.02;
                    double d2 = this.random.nextGaussian() * 0.02;
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW.defaultBlockState()), this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
                }
            }
        } else {
            this.isThrowing = id == 1;
            this.throwingTick = 0;
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.getDirectEntity() instanceof Snowball) {
            if (this.isAlive() && this.getHealth() < this.getMaxHealth()) {
                this.heal(1.0f);
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2);
            }
            return false;
        }
        return super.hurt(source, amount);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (!this.isThrowing) {
            this.setThrowing(true);
        }
    }

    public static boolean canHarm(Entity attacker, Entity target) {
        if (!(attacker instanceof MutantSnowGolem)) {
            return true;
        }
        if (target instanceof CreeperMinion) {
            return !((CreeperMinion)target).isTame();
        }
        return target instanceof Enemy || target instanceof Mob && ((Mob)target).getTarget() == attacker || ((MutantSnowGolem)attacker).getTarget() == target;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        InteractionResult actionresulttype = itemStack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (actionresulttype.consumesAction()) {
            return actionresulttype;
        }
        if (!(this.getOwnerId().isPresent() && player != this.getOwner() || itemStack.getItem() == Items.SNOWBALL)) {
            if (!this.level().isClientSide) {
                this.setOwnerId(!this.getOwnerId().isPresent() ? player.getUUID() : null);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.9f * this.getEyeHeight()), (double)this.getBbWidth() * (double)0.2f);
    }

    public void die(DamageSource cause) {
        if (!this.level().isClientSide && this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getOwner() instanceof ServerPlayer) {
            this.getOwner().sendSystemMessage(this.getCombatTracker().getDeathMessage());
        }
        super.die(cause);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("JackOLantern", this.hasJackOLantern());
        this.getOwnerId().ifPresent(uuid -> compound.putUUID("Owner", uuid));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Pumpkin") || compound.contains("JackOLantern")) {
            this.setJackOLantern(compound.getBoolean("Pumpkin") || compound.getBoolean("JackOLantern"));
        }
        if (compound.hasUUID("OwnerUUID")) {
            this.setOwnerId(compound.getUUID("OwnerUUID"));
        } else if (compound.hasUUID("Owner")) {
            this.setOwnerId(compound.getUUID("Owner"));
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_DEATH_SOUND_EVENT.value();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.SNOW_STEP, 0.15f, 1.0f);
    }

    static class SwimJumpGoal
    extends Goal {
        private final MutantSnowGolem golem;
        private int jumpTick = 20;
        private boolean waterReplaced;
        private BlockPos.MutableBlockPos prevPos;

        public SwimJumpGoal(MutantSnowGolem golem) {
            this.golem = golem;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP));
            golem.navigation.setCanFloat(true);
        }

        public boolean canUse() {
            return this.golem.isInWater();
        }

        public void start() {
            this.prevPos = new BlockPos.MutableBlockPos(this.golem.getX(), this.golem.getBoundingBox().minY - 1.0, this.golem.getZ());
            this.golem.setDeltaMovement((this.golem.random.nextFloat() - this.golem.random.nextFloat()) * 0.9f, 1.5, (this.golem.random.nextFloat() - this.golem.random.nextFloat()) * 0.9f);
            this.golem.hurt(this.golem.level().damageSources().drown(), 16.0f);
            this.golem.setSwimJump(true);
        }

        public boolean canContinueToUse() {
            return this.jumpTick > 0;
        }

        public void tick() {
            --this.jumpTick;
            if (!this.waterReplaced && !this.golem.isInWater() && this.jumpTick < 17 && CommonAbstractions.INSTANCE.getMobGriefingRule(this.golem.level(), (Entity)this.golem)) {
                this.prevPos.setY(this.getWaterSurfaceHeight(this.golem.level(), (BlockPos)this.prevPos));
                if ((double)this.prevPos.getY() > this.golem.getY()) {
                    return;
                }
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            if (y != 0 && (Math.abs(x) == 2 || Math.abs(z) == 2)) continue;
                            BlockPos pos = this.prevPos.offset(x, y, z);
                            if (!this.golem.level().isEmptyBlock(pos) && !this.golem.level().isWaterAt(pos) || (y != 0 ? (Math.abs(x) == 1 || Math.abs(z) == 1) && this.golem.random.nextInt(4) == 0 : (Math.abs(x) == 2 || Math.abs(z) == 2) && this.golem.random.nextInt(3) == 0)) continue;
                            this.golem.level().setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
                        }
                    }
                }
                BlockPos topPos = this.prevPos.above(2);
                if (this.golem.level().isEmptyBlock(topPos)) {
                    this.golem.level().setBlockAndUpdate(topPos, Blocks.ICE.defaultBlockState());
                }
                this.waterReplaced = true;
            }
        }

        public void stop() {
            this.jumpTick = 20;
            this.waterReplaced = false;
            this.golem.setSwimJump(false);
            this.prevPos = null;
        }

        private int getWaterSurfaceHeight(Level world, BlockPos coord) {
            int y = coord.getY();
            while (world.isWaterAt(new BlockPos(coord.getX(), y + 1, coord.getZ()))) {
                ++y;
            }
            return y;
        }
    }

    class ThrowIceGoal
    extends Goal {
        ThrowIceGoal() {
        }

        public boolean canUse() {
            return MutantSnowGolem.this.getTarget() != null && MutantSnowGolem.this.isThrowing;
        }

        public boolean canContinueToUse() {
            return MutantSnowGolem.this.isThrowing && MutantSnowGolem.this.throwingTick < 20;
        }

        public void tick() {
            LivingEntity target = MutantSnowGolem.this.getTarget();
            if (target != null) {
                MutantSnowGolem.this.getNavigation().stop();
                MutantSnowGolem.this.yBodyRot = MutantSnowGolem.this.getYRot();
                if (MutantSnowGolem.this.throwingTick == 7) {
                    ThrowableBlock block = new ThrowableBlock(MutantSnowGolem.this);
                    double x = target.getX() - block.getX();
                    double y = target.getY() - block.getY();
                    double z = target.getZ() - block.getZ();
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    block.shoot(x, y + distance * 0.5, z, 0.9f, 1.0f);
                    MutantSnowGolem.this.level().addFreshEntity((Entity)block);
                }
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }
}

