/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.projectile;

import fuzs.mutantmonsters.init.ModEntityTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantArrow
extends Arrow {
    private static final EntityDataAccessor<Integer> CLONES = SynchedEntityData.defineId(MutantArrow.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public MutantArrow(EntityType<? extends MutantArrow> type, Level level) {
        super(type, level);
    }

    public MutantArrow(Level level, LivingEntity shooter) {
        this((EntityType<? extends MutantArrow>)((EntityType)ModEntityTypes.MUTANT_ARROW_ENTITY_TYPE.value()), level);
        this.setPos(shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ());
        this.setNoGravity(true);
        this.setOwner((Entity)shooter);
        this.setCritArrow(true);
    }

    public void shoot(LivingEntity target, float velocity, float randomization) {
        Vec3 attackLocation = this.getAttackLocation(target, randomization);
        Vec3 attackVector = attackLocation.subtract(this.position());
        double horizontalDistance = attackVector.horizontalDistance();
        double x = attackVector.x;
        double y = attackVector.y;
        double z = attackVector.z;
        this.shoot(x, y, z, velocity, 0.0f);
        this.setYRot(180.0f + (float)Math.toDegrees(Math.atan2(x, z)));
        while (this.getYRot() > 360.0f) {
            this.setYRot(this.getYRot() - 360.0f);
        }
        this.setXRot((float)Math.toDegrees(Math.atan2(y, horizontalDistance)));
    }

    private Vec3 getAttackLocation(LivingEntity target, float randomization) {
        double x = target.getX() + (double)((this.random.nextFloat() - 0.5f) * randomization * 2.0f);
        double y = target.getY(0.8) + (double)((this.random.nextFloat() - 0.5f) * randomization * 2.0f);
        double z = target.getZ() + (double)((this.random.nextFloat() - 0.5f) * randomization * 2.0f);
        return new Vec3(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CLONES, (Object)1);
    }

    public int getClones() {
        return (Integer)this.entityData.get(CLONES);
    }

    public void setClones(int clones) {
        this.entityData.set(CLONES, (Object)clones);
    }

    public void tick() {
        float xRot = this.getXRot();
        float xRotO = this.xRotO;
        float yRot = this.getYRot();
        float yRotO = this.yRotO;
        super.tick();
        this.setXRot(xRot);
        this.xRotO = xRotO;
        this.setYRot(yRot);
        this.yRotO = yRotO;
        if (!this.isRemoved() && this.tickCount > 200) {
            this.discard();
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (result.getType() != HitResult.Type.MISS) {
            this.discard();
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    protected void tickDespawn() {
        this.discard();
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0), (float)1.0f);
    }

    protected void doPostHurtEffects(LivingEntity target) {
        super.doPostHurtEffects(target);
        if (!this.isSilent()) {
            this.level().playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.CROSSBOW_HIT, this.getSoundSource(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        }
    }
}

