/*
 * Decompiled with CFR 0.152.
 */
package suszombification;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import suszombification.SuspiciousZombification;
import suszombification.block.TrophyBlock;
import suszombification.entity.ZombifiedAnimal;
import suszombification.glm.CatMorningGiftModifier;
import suszombification.glm.NoDecomposingDropsModifier;
import suszombification.registration.SZBlocks;
import suszombification.registration.SZEntityTypes;
import suszombification.registration.SZItems;

@EventBusSubscriber(modid="suszombification", bus=EventBusSubscriber.Bus.MOD)
public class RegistrationHandler {
    private RegistrationHandler() {
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ZombifiedAnimal.VANILLA_TO_ZOMBIFIED.put(EntityType.CAT, (EntityType<? extends Animal>)((EntityType)SZEntityTypes.ZOMBIFIED_CAT.get()));
            ZombifiedAnimal.VANILLA_TO_ZOMBIFIED.put(EntityType.CHICKEN, (EntityType<? extends Animal>)((EntityType)SZEntityTypes.ZOMBIFIED_CHICKEN.get()));
            ZombifiedAnimal.VANILLA_TO_ZOMBIFIED.put(EntityType.COW, (EntityType<? extends Animal>)((EntityType)SZEntityTypes.ZOMBIFIED_COW.get()));
            ZombifiedAnimal.VANILLA_TO_ZOMBIFIED.put(EntityType.PIG, (EntityType<? extends Animal>)((EntityType)SZEntityTypes.ZOMBIFIED_PIG.get()));
            ZombifiedAnimal.VANILLA_TO_ZOMBIFIED.put(EntityType.SHEEP, (EntityType<? extends Animal>)((EntityType)SZEntityTypes.ZOMBIFIED_SHEEP.get()));
            ZombifiedAnimal.VANILLA_TO_ZOMBIFIED.put(EntityType.HORSE, (EntityType<? extends Animal>)EntityType.ZOMBIE_HORSE);
        });
    }

    @SubscribeEvent
    public static void registerItems(RegisterEvent event) {
        event.register(Registries.ITEM, helper -> {
            for (DeferredHolder holder : SZBlocks.BLOCKS.getEntries()) {
                Block block = (Block)holder.get();
                if (block instanceof TrophyBlock) continue;
                helper.register(holder.getId(), (Object)new BlockItem(block, new Item.Properties()));
            }
        });
        event.register(NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, helper -> {
            helper.register(SuspiciousZombification.resLoc("cat_morning_gift"), CatMorningGiftModifier.CODEC);
            helper.register(SuspiciousZombification.resLoc("no_decomposing_drops"), NoDecomposingDropsModifier.CODEC);
        });
    }

    @SubscribeEvent
    public static void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.COLORED_BLOCKS) {
            event.acceptAll(List.of(new ItemStack((ItemLike)SZBlocks.WHITE_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.LIGHT_GRAY_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.GRAY_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.BLACK_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.BROWN_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.RED_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.ORANGE_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.YELLOW_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.LIME_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.GREEN_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.CYAN_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.LIGHT_BLUE_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.BLUE_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.PURPLE_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.MAGENTA_ROTTEN_WOOL.get()), new ItemStack((ItemLike)SZBlocks.PINK_ROTTEN_WOOL.get())));
        } else if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            for (DeferredHolder holder : SZItems.ITEMS.getEntries()) {
                Item item = (Item)holder.get();
                if (!(item instanceof SpawnEggItem)) continue;
                event.accept((ItemLike)item);
            }
        }
    }
}

