/*
 * Decompiled with CFR 0.152.
 */
package suszombification.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import suszombification.block.entity.TrophyBlockEntity;
import suszombification.registration.SZBlockEntityTypes;

public class TrophyBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0)});
    private final TrophyType trophyType;

    public TrophyBlock(TrophyType trophyType, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.trophyType = trophyType;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrophyBlockEntity((BlockEntityType<? extends TrophyBlockEntity>)((BlockEntityType)SZBlockEntityTypes.TROPHY.get()), pos, state, this.trophyType);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public static enum TrophyType {
        CARROT(new ItemStack((ItemLike)Items.CARROT)),
        POTATO(new ItemStack((ItemLike)Items.POTATO)),
        IRON_INGOT(new ItemStack((ItemLike)Items.IRON_INGOT));

        public final ItemStack displayItem;

        private TrophyType(ItemStack displayItem) {
            this.displayItem = displayItem;
        }
    }
}

